#!/usr/bin/perl -w

use File::Basename;

# $BJ8Cf$N(B URI $B$r%j%s%/$K$9$k(B (morimoto)
my $link_uri = 1;

my $templete = shift;

foreach my $docinfo (@ARGV) {
  my ($NAME, $TITL, $CONT, $AUTH, $TRNS, $BVER, $JDAT);
  my ($AUT2, $AUT3, $TRN2, $TRN3) = ('', '', '', '');
  $docinfo =~ s,^\./,,;

  my $basedoc = $docinfo;
  $basedoc =~ s/\.info$//;

  my $doc = basename($basedoc);
  my $dir = dirname($basedoc);
  if ($dir eq '.') {
    $dir = '';
  } else {
    $dir = $dir . '/';
  }

#  print STDERR "Processing $dir $doc.html\n";

  open(INFO, $docinfo) or next;
  while (<INFO>) {
    s/\s*#.*$//; #;
    next if /^\s*$/;
    s/&/&amp;/g;
    s/</&lt;/g;
    s/>/&gt;/g;
    if (/^(\w+):\s*(.*)$/) {
      my $key = '$' . $1 . ' = $2'; #'
      eval $key;
    }
  }
  close INFO;
  open(M4, "| m4 -P | nkf -w > $basedoc.html") or die;
  open(TMPLT, "$templete") or die;
  print M4 while <TMPLT>;
  close TMPLT;
  open(DOC, "$basedoc") or next;
  if ($dir =~ /.+\/.+\/.+\/$/) {
    print M4 "m4_define(_INDEX_DIR,../../../index.html)\n";
    print M4 "m4_define(_JF_ROOT_DIR,../../../../..)\n";
  } elsif ($dir =~ /.+\/.+\/$/) {
    print M4 "m4_define(_INDEX_DIR,../../index.html)\n";
    print M4 "m4_define(_JF_ROOT_DIR,../../../..)\n";
  } elsif ($dir) {
    print M4 "m4_define(_INDEX_DIR,../index.html)\n";
    print M4 "m4_define(_JF_ROOT_DIR,../../..)\n";
  } else {
    print M4 "m4_define(_INDEX_DIR,index.html)\n";
    print M4 "m4_define(_JF_ROOT_DIR,../..)\n";
  }
  print M4 "m4_define(_HOME_PAGE,_JF_ROOT_DIR/index.html)\n";
  print M4 "_HEADER(`$doc', `$CONT')\n";
  print M4 "_EDIT_WARNING\n";
  print M4 "m4_define(_AUTH, `$AUTH $AUT2 $AUT3')\n" if $AUTH;
  print M4 "m4_define(_TRNS, `$TRNS $TRN2 $TRN3')\n" if $TRNS;
  print M4 "m4_define(_BVER, `$BVER')\n" if $BVER;
  print M4 "m4_define(_JDAT, `$JDAT')\n" if $JDAT;
  print M4 "_BODY_DOC(`$dir', `$doc',`$CONT')\n";
  print M4 "m4_changequote(`[[[[[[[[',`]]]]]]]]')\n";

  while (<DOC>){
    s/&/&amp;/g;
    s/</&lt;/g;
    s/>/&gt;/g;

    if($link_uri){
	unless(s,(http|ftp)(://[!#$%'*-\177]+[-!#$%'*=/-\177]),<a href="$1$2">$1$2</a>,g){
	    s|(www\.[!#$%'*-\177]+[-!#$%'*=/-\177])|<a href="http://$1">$1</a>|g;
	}
    }

    print M4;
  }
  print M4 "_FOOTER\n";
  close DOC;
  close M4;
}

# EOF
