/*
 * Decompiled with CFR 0.152.
 */
package org.python.parser.ast;

import java.io.DataOutputStream;
import java.io.IOException;
import org.python.parser.SimpleNode;
import org.python.parser.ast.VisitorIF;
import org.python.parser.ast.exprType;
import org.python.parser.ast.keywordType;

public class Call
extends exprType {
    public exprType func;
    public exprType[] args;
    public keywordType[] keywords;
    public exprType starargs;
    public exprType kwargs;

    public Call(exprType exprType2, exprType[] exprTypeArray, keywordType[] keywordTypeArray, exprType exprType3, exprType exprType4) {
        this.func = exprType2;
        this.args = exprTypeArray;
        this.keywords = keywordTypeArray;
        this.starargs = exprType3;
        this.kwargs = exprType4;
    }

    public Call(exprType exprType2, exprType[] exprTypeArray, keywordType[] keywordTypeArray, exprType exprType3, exprType exprType4, SimpleNode simpleNode) {
        this(exprType2, exprTypeArray, keywordTypeArray, exprType3, exprType4);
        this.beginLine = simpleNode.beginLine;
        this.beginColumn = simpleNode.beginColumn;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Call[");
        stringBuffer.append("func=");
        stringBuffer.append(this.dumpThis(this.func));
        stringBuffer.append(", ");
        stringBuffer.append("args=");
        stringBuffer.append(this.dumpThis(this.args));
        stringBuffer.append(", ");
        stringBuffer.append("keywords=");
        stringBuffer.append(this.dumpThis(this.keywords));
        stringBuffer.append(", ");
        stringBuffer.append("starargs=");
        stringBuffer.append(this.dumpThis(this.starargs));
        stringBuffer.append(", ");
        stringBuffer.append("kwargs=");
        stringBuffer.append(this.dumpThis(this.kwargs));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void pickle(DataOutputStream dataOutputStream) throws IOException {
        this.pickleThis(35, dataOutputStream);
        this.pickleThis(this.func, dataOutputStream);
        this.pickleThis(this.args, dataOutputStream);
        this.pickleThis(this.keywords, dataOutputStream);
        this.pickleThis(this.starargs, dataOutputStream);
        this.pickleThis(this.kwargs, dataOutputStream);
    }

    public Object accept(VisitorIF visitorIF) throws Exception {
        return visitorIF.visitCall(this);
    }

    public void traverse(VisitorIF visitorIF) throws Exception {
        int n;
        if (this.func != null) {
            this.func.accept(visitorIF);
        }
        if (this.args != null) {
            for (n = 0; n < this.args.length; ++n) {
                if (this.args[n] == null) continue;
                this.args[n].accept(visitorIF);
            }
        }
        if (this.keywords != null) {
            for (n = 0; n < this.keywords.length; ++n) {
                if (this.keywords[n] == null) continue;
                this.keywords[n].accept(visitorIF);
            }
        }
        if (this.starargs != null) {
            this.starargs.accept(visitorIF);
        }
        if (this.kwargs != null) {
            this.kwargs.accept(visitorIF);
        }
    }
}

