/*
 * Copyright (C) 2004-2013 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package events.GiftOfVitality;

import static com.l2jserver.gameserver.datatables.SkillTable.getSkill;
import static com.l2jserver.gameserver.datatables.SkillTable.getSkillHashCode;

import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.event.LongTimeEvent;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.quest.State;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

/**
 * Gift of Vitality event AI.
 * @author Gnacik, Adry_85
 */
public class GiftOfVitality extends LongTimeEvent
{
	// NPC
	private static final int STEVE_SHYAGEL = 4306;
	// Skills
	private static final int GIFT_OF_VITALITY = getSkillHashCode(23179, 1);
	private static final int JOY_OF_VITALITY = getSkillHashCode(23180, 1);
	
	private static int[] FIGHTER_SKILLS =
	{
		getSkillHashCode(5627, 1), // Wind Walk
		getSkillHashCode(5628, 1), // Shield
		getSkillHashCode(5637, 1), // Magic Barrier
		getSkillHashCode(5629, 1), // Bless the Body
		getSkillHashCode(5630, 1), // Vampiric Rage
		getSkillHashCode(5631, 1), // Regeneration
		getSkillHashCode(5632, 1), // Haste
	};
	
	private static int[] MAGE_SKILLS =
	{
		getSkillHashCode(5627, 1), // Wind Walk
		getSkillHashCode(5628, 1), // Shield
		getSkillHashCode(5637, 1), // Magic Barrier
		getSkillHashCode(5633, 1), // Bless the Soul
		getSkillHashCode(5634, 1), // Acumen
		getSkillHashCode(5635, 1), // Concentration
		getSkillHashCode(5636, 1), // Empower
	};
	
	private static int[] SERVITOR_SKILLS =
	{
		getSkillHashCode(5627, 1), // Wind Walk
		getSkillHashCode(5628, 1), // Shield
		getSkillHashCode(5637, 1), // Magic Barrier
		getSkillHashCode(5629, 1), // Bless the Body
		getSkillHashCode(5633, 1), // Bless the Soul
		getSkillHashCode(5630, 1), // Vampiric Rage
		getSkillHashCode(5634, 1), // Acumen
		getSkillHashCode(5631, 1), // Regeneration
		getSkillHashCode(5635, 1), // Concentration
		getSkillHashCode(5632, 1), // Haste
		getSkillHashCode(5636, 1), // Empower
	};
	
	public GiftOfVitality(String name, String descr)
	{
		super(name, descr);
		addStartNpc(STEVE_SHYAGEL);
		addFirstTalkId(STEVE_SHYAGEL);
		addTalkId(STEVE_SHYAGEL);
	}
	
	// Misc
	private static final int HOURS = 5; // Reuse between buffs
	private static final int MIN_LEVEL = 75;
	
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		String htmltext = event;
		QuestState st = player.getQuestState(getName());
		
		switch (event)
		{
			case "vitality":
			{
				final long now = System.currentTimeMillis();
				final String streuse = st.get("reuse");
				final long reuseTime = streuse == null ? 0 : Long.parseLong(streuse);
				if (reuseTime > now)
				{
					final long remainingTime = reuseTime - now + 59999;	// ceil
					final int hours = (int) (remainingTime / 3600000L);
					final int minutes = (int) (remainingTime / 60000L % 60);
					SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.AVAILABLE_AFTER_S1_S2_HOURS_S3_MINUTES);
					sm.addSkillName(23179);
					sm.addNumber(hours);
					sm.addNumber(minutes);
					player.sendPacket(sm);
					htmltext = "4306-notime.htm";
				}
				else
				{
					player.doCast(getSkill(GIFT_OF_VITALITY));
					player.doCast(getSkill(JOY_OF_VITALITY));
					st.setState(State.STARTED);
					st.set("reuse", String.valueOf(now + (HOURS * 3600000)));
					htmltext = "4306-okvitality.htm";
				}
				break;
			}
			case "memories_player":
			{
				if (player.getLevel() <= MIN_LEVEL)
				{
					htmltext = "4306-nolevel.htm";
				}
				else
				{
					final int[] skills = (player.isMageClass()) ? MAGE_SKILLS : FIGHTER_SKILLS;
					npc.setTarget(player);
					for (int sk : skills)
					{
						npc.doCast(getSkill(sk));
					}
					htmltext = "4306-okbuff.htm";
				}
				break;
			}
			case "memories_summon":
			{
				if (player.getLevel() <= MIN_LEVEL)
				{
					htmltext = "4306-nolevel.htm";
				}
				else if (!player.hasServitor())
				{
					htmltext = "4306-nosummon.htm";
				}
				else
				{
					npc.setTarget(player.getSummon());
					for (int sk : SERVITOR_SKILLS)
					{
						npc.doCast(getSkill(sk));
					}
					htmltext = "4306-okbuff.htm";
				}
				break;
			}
		}
		return htmltext;
	}
	
	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
		if (player.getQuestState(getName()) == null)
		{
			newQuestState(player);
		}
		return "4306.htm";
	}
	
	public static void main(String[] args)
	{
		new GiftOfVitality(GiftOfVitality.class.getSimpleName(), "events");
	}
}
