use utf8;
use warnings;
use strict;

&start('../L2J_DataPack_BETA/build.xml');
&start('../L2J_Server_BETA/build.xml');

exit;

sub start($)
{
	my ($buildxml) = @_;
##	print '-'x72,"\n";
	print $buildxml,"\n";
##	print '-'x72,"\n";

	my $modify = 0;

	open IN, '<:utf8', $buildxml  or die;
	my @xml = <IN>;
	close IN;

	foreach my $line (@xml) {
		if ($line =~ m|<copy [^>]*>$|
		 && $line !~ m| preservelastmodified="true">$|) {
			print '- ',$line;
			$line =~ s|>$| preservelastmodified="true">|;
			print '+ ',$line;
			$modify = 1;
		}
	}

	my $xml = join '', @xml;

if (0) {{
	if ($xml =~ s|<(zip [^>]*/)>|<!--$1-->|sg) {
		print "* zip...\n";
		$modify = 1;
	}
}}

	if ($xml =~ s|(^[ \t]*<target name="export".*?">$)|$1<!-- -->
		<defaultexcludes add="**/.*" />
		<defaultexcludes add="**/.*/**" />
		<defaultexcludes add="**/#*" />
		<defaultexcludes add="**/#*/**" />
		<defaultexcludes add="**/*.#*" />
		<defaultexcludes add="**/*.BAK" />
		<defaultexcludes add="**/*.bak" />
		<defaultexcludes add="**/*.lnk" />
		<defaultexcludes add="**/*.url" />
		<defaultexcludes add="**/* - *" />
		<defaultexcludes add="**/* &#45;&#45;*" />
		<defaultexcludes add="**/*～*" />
|mg) {
		print "* set defaultexcludes\n";
		$modify = 1;
	}

	if ($xml =~ s|<exclude name="build.xml"/>|<exclude name="build*.*"/>
<exclude name="ant_*.*"/>|g) {
		print "* exclude build*.*\n";
		$modify = 1;
	}

	# OK - "../builder/yavac/yavac.exe"
	# OK - "../yavac.exe"
	# NG - "./yavac.exe"
	if ($xml =~ s|^([\t ]*?)(<javac [^>]+")>$|$1$2
$1	fork="yes" executable="../builder/yavac/yavac.exe"><!-- -->|m) {
		print "* <javac fork=yes executable=yavac>\n";
		$modify = 1;
	}

	if ($xml =~ s|(<target name="dist"\s*depends="export)"|$1,language"|s) {
		print "* TextBuilder-PATCH\n";
		$modify = 1;
	}

	if ($modify) {
		open OUT, '>:utf8', $buildxml  or die;
#		open OUT, '>:utf8', $buildxml.'-TEST.txt'  or die;
		print OUT $xml;
		close OUT;
	}
}
