﻿<?php
/**
 * Template manager engine for p0int
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @copyright Copyright &copy; 2003, Lauri Lüüs 
 * @version v0.6, last update on 21.03.2004 
 * @package p0intEngine
 * @filesource
 */

/**
 * Loads template from file
 * @param string
 * @return string
 */
 function temp_load($filename)
{
   	if(@file($filename))
	{
		$fp = fopen($filename, "r");
		$source = fread($fp, filesize($filename));
		
		//$source = join("",file($filename));
		if (strlen($source) == 0){
			die("Can't open template: - $filename <br>");
		}
		return $source;
	}else{
		echo "Can't find template: - $filename <br>";
	}
}

/**
 * Fills parts in template
 * @param string
 * @param string
 * @param array
 * @return string
 */
function temp_subs($source ,$varname, $vars){
	if (is_array($vars))
	{
		foreach($vars as $key => $value)
		{
			$tag = "{".$varname.":".$key."}";
			$source = str_replace($tag,$value,$source);
		}
	}
	return $source;
}

/**
 * Creates blocks from template to refill
 *
 * Returns array of strings in where
 *
 * tpl - is Block to be filled
 * clean - is left clean never filled
 * src - is source block taken out
 * add - is string where you add filled blocks
 * done - is final output when block is unlocked
 *
 * @param string - template
 * @param string - block name
 * @return array
 */
function temp_lock($source,$block)
{
	eregi("<BLOCK:$block>(.*)</BLOCK:$block>", $source, $new_tpl);
	//$block = $new_tpl[1];
	//$source = eregi_replace("<BLOCK:$block>(.*(</BLOCK:$block>))", "{block:$block}", $template);

	$output['tpl'] = $new_tpl[1];
	$output['clean'] = $new_tpl[1];
	$output['src'] = eregi_replace("<BLOCK:$block>(.*(</BLOCK:$block>))", "{block:$block}", $source);
	$output['add'] = "";
	$output['done'] = "";
	return $output;
}

/**
 * If block is filled and starts with new one
 * @param string 
 * @return string 
 */
function temp_done($tpl)
{
	$tpl['tpl'] = $tpl['add']."\n".$tpl['clean'];
	if($tpl['add']!="")
	{
		$tpl['done'] = $tpl['add'];
	}else{
		$tpl['done'] = $tpl['clean'];
	}
	return $tpl;
}

/**
 * Unlocks block
 * @param string
 * @param string
 * @return string
 */
function temp_unlock($block,$block_name)
{
	$b_output[$block_name] = $block['done'];
	$source = temp_subs($block['src'], "block", $b_output);
	return $source;
}
?>