## Active Perl 5.8.8 or later

# Add comments to enchantItemOptions.xml
# Author JOJO

use utf8;
use strict;
use warnings;
use Encode;
use DBI;

binmode STDOUT,':encoding(cp932)'; $|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $DEBUG = 0; # 1 or 0

my $vars_txt = '../../../tools/vars.txt';
open FILE,'<',$vars_txt  or do {warn "'$vars_txt' $!";exit 0};
read FILE,my $vars,-s FILE;
close FILE;
my $gsuser = ($vars =~ m/^@*set gsuser=(.+)$/m)[0];
my $gspass = ($vars =~ m/^@*set gspass=(.+)$/m)[0];
my $gsdb   = ($vars =~ m/^@*set gsdb=(.+)$/m)[0];
my $gshost = ($vars =~ m/^@*set gshost=(.+)$/m)[0];

my $db = DBI->connect("DBI:mysql:$gsdb:$gshost", $gsuser, $gspass, {mysql_enable_utf8=>1}) or do{warn DBI::errstr;exit 0};
   $db->do('SET NAMES UTF8');

&start('./enchantItemOptions.xml');

exit 0;

sub start {
	my ($filePath) = @_;

	print "  $filePath\n" if $DEBUG;
	open FILE, '<:utf8', FS($filePath) or die "'$filePath' $!";
	my $mtime = (stat FILE)[9];
	read FILE,my $text,-s FILE;
	close FILE;

	my $backup = $text;
	my @T = split m/(?<=[\n])/, $text;
	for (my $i = 0; $i <= $#T; ++$i) {
		if ($T[$i] =~ m/<!--/ && $T[$i] !~ m/-->/) {	# skip comment
			do {++$i} while $T[$i] !~ m/-->/;
			next;
		}
		
		my $line = $T[$i];
#	<item id="15383"> <!-- Weaver's Multi-colored Clothes - 7-day limited period -->
		if ($line =~ m{<item id="(\d+)">}) {
			my $itemId = $1;
			my $itemName = getItemName($itemId);
			$T[$i] =~ s{(?<=>) +<!--.+?-->$}{};
			$T[$i] =~ s{$}{ <!-- $itemName -->};
			print "\t$itemName\n" if $DEBUG;
		}
	}
	$text = join '',@T;

	if ($backup ne $text) {
		my $outPath = $filePath;
		   $outPath = $filePath . '.text' if $DEBUG;
		open FILE, '>:utf8', FS($outPath) or die "'$outPath' $!";
		print FILE $text;
		close FILE;
		utime $mtime, $mtime, FS($outPath);
	}
}

sub getItemName {
	my ($id) = @_;

	my $sql = "SELECT name,add_name FROM itemname_ja WHERE id=?";
	my $sth = $db->prepare($sql);
	$sth->execute($id) or die DBI::errstr;
	$sth->bind_columns(undef, \(my($N_name,$N_add_name))) or die DBI::errstr;
	my $rc = $sth->fetch();

	return $N_add_name ? join ' - ', $N_name,$N_add_name : $N_name
}
