/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.log;

import com.mchange.v1.util.StringTokenizerUtils;
import com.mchange.v2.log.FallbackMLog;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLogClasses;
import com.mchange.v2.log.MLogConfig;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.log.NameTransformer;
import java.util.ArrayList;

public abstract class MLog {
    private static NameTransformer transformer;
    private static MLog mlog;
    private static MLogger logger;

    public static MLog findByClassnames(String[] stringArray, boolean bl) {
        int n;
        ArrayList<String> arrayList = null;
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            try {
                return (MLog)Class.forName(MLogClasses.resolveIfAlias(stringArray[n])).newInstance();
            }
            catch (Exception exception) {
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(stringArray[n]);
                if (!bl) continue;
                System.err.println("com.mchange.v2.log.MLog '" + stringArray[n] + "' could not be loaded!");
                exception.printStackTrace();
                continue;
            }
        }
        System.err.println("Tried without success to load the following MLog classes:");
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            System.err.println("\t" + arrayList.get(n));
        }
        return null;
    }

    public static MLog instance() {
        return mlog;
    }

    public static MLogger getLogger(String string) {
        String string2;
        MLogger mLogger = transformer == null ? MLog.instance().getMLogger(string) : ((string2 = transformer.transformName(string)) != null ? MLog.instance().getMLogger(string2) : MLog.instance().getMLogger(string));
        return mLogger;
    }

    public static MLogger getLogger(Class clazz) {
        String string;
        MLogger mLogger = transformer == null ? MLog.instance().getMLogger(clazz) : ((string = transformer.transformName(clazz)) != null ? MLog.instance().getMLogger(string) : MLog.instance().getMLogger(clazz));
        return mLogger;
    }

    public static MLogger getLogger() {
        String string;
        MLogger mLogger = transformer == null ? MLog.instance().getMLogger() : ((string = transformer.transformName()) != null ? MLog.instance().getMLogger(string) : MLog.instance().getMLogger());
        return mLogger;
    }

    public static void log(MLevel mLevel, String string) {
        MLog.instance();
        MLog.getLogger().log(mLevel, string);
    }

    public static void log(MLevel mLevel, String string, Object object) {
        MLog.instance();
        MLog.getLogger().log(mLevel, string, object);
    }

    public static void log(MLevel mLevel, String string, Object[] objectArray) {
        MLog.instance();
        MLog.getLogger().log(mLevel, string, objectArray);
    }

    public static void log(MLevel mLevel, String string, Throwable throwable) {
        MLog.instance();
        MLog.getLogger().log(mLevel, string, throwable);
    }

    public static void logp(MLevel mLevel, String string, String string2, String string3) {
        MLog.instance();
        MLog.getLogger().logp(mLevel, string, string2, string3);
    }

    public static void logp(MLevel mLevel, String string, String string2, String string3, Object object) {
        MLog.instance();
        MLog.getLogger().logp(mLevel, string, string2, string3, object);
    }

    public static void logp(MLevel mLevel, String string, String string2, String string3, Object[] objectArray) {
        MLog.instance();
        MLog.getLogger().logp(mLevel, string, string2, string3, objectArray);
    }

    public static void logp(MLevel mLevel, String string, String string2, String string3, Throwable throwable) {
        MLog.instance();
        MLog.getLogger().logp(mLevel, string, string2, string3, throwable);
    }

    public static void logrb(MLevel mLevel, String string, String string2, String string3, String string4) {
        MLog.instance();
        MLog.getLogger().logp(mLevel, string, string2, string3, string4);
    }

    public static void logrb(MLevel mLevel, String string, String string2, String string3, String string4, Object object) {
        MLog.instance();
        MLog.getLogger().logrb(mLevel, string, string2, string3, string4, object);
    }

    public static void logrb(MLevel mLevel, String string, String string2, String string3, String string4, Object[] objectArray) {
        MLog.instance();
        MLog.getLogger().logrb(mLevel, string, string2, string3, string4, objectArray);
    }

    public static void logrb(MLevel mLevel, String string, String string2, String string3, String string4, Throwable throwable) {
        MLog.instance();
        MLog.getLogger().logrb(mLevel, string, string2, string3, string4, throwable);
    }

    public static void entering(String string, String string2) {
        MLog.instance();
        MLog.getLogger().entering(string, string2);
    }

    public static void entering(String string, String string2, Object object) {
        MLog.instance();
        MLog.getLogger().entering(string, string2, object);
    }

    public static void entering(String string, String string2, Object[] objectArray) {
        MLog.instance();
        MLog.getLogger().entering(string, string2, objectArray);
    }

    public static void exiting(String string, String string2) {
        MLog.instance();
        MLog.getLogger().exiting(string, string2);
    }

    public static void exiting(String string, String string2, Object object) {
        MLog.instance();
        MLog.getLogger().exiting(string, string2, object);
    }

    public static void throwing(String string, String string2, Throwable throwable) {
        MLog.instance();
        MLog.getLogger().throwing(string, string2, throwable);
    }

    public static void severe(String string) {
        MLog.instance();
        MLog.getLogger().severe(string);
    }

    public static void warning(String string) {
        MLog.instance();
        MLog.getLogger().warning(string);
    }

    public static void info(String string) {
        MLog.instance();
        MLog.getLogger().info(string);
    }

    public static void config(String string) {
        MLog.instance();
        MLog.getLogger().config(string);
    }

    public static void fine(String string) {
        MLog.instance();
        MLog.getLogger().fine(string);
    }

    public static void finer(String string) {
        MLog.instance();
        MLog.getLogger().finer(string);
    }

    public static void finest(String string) {
        MLog.instance();
        MLog.getLogger().finest(string);
    }

    public MLogger getMLogger(Class clazz) {
        return this.getMLogger(clazz.getName());
    }

    public abstract MLogger getMLogger(String var1);

    public abstract MLogger getMLogger();

    static {
        String string = MLogConfig.getProperty("com.mchange.v2.log.MLog");
        String[] stringArray = null;
        if (string == null) {
            string = MLogConfig.getProperty("com.mchange.v2.log.mlog");
        }
        if (string != null) {
            stringArray = StringTokenizerUtils.tokenizeToArray(string, ", \t\r\n");
        }
        boolean bl = false;
        MLog mLog = null;
        if (stringArray != null) {
            mLog = MLog.findByClassnames(stringArray, true);
        }
        if (mLog == null) {
            mLog = MLog.findByClassnames(MLogClasses.SEARCH_CLASSNAMES, false);
        }
        if (mLog == null) {
            bl = true;
            mLog = new FallbackMLog();
        }
        mlog = mLog;
        if (bl) {
            MLog.info("Using " + mlog.getClass().getName() + " -- Named logger's not supported, everything goes to System.err.");
        }
        NameTransformer nameTransformer = null;
        String string2 = MLogConfig.getProperty("com.mchange.v2.log.NameTransformer");
        if (string2 == null) {
            string2 = MLogConfig.getProperty("com.mchange.v2.log.nametransformer");
        }
        try {
            if (string2 != null) {
                nameTransformer = (NameTransformer)Class.forName(string2).newInstance();
            }
        }
        catch (Exception exception) {
            System.err.println("Failed to instantiate com.mchange.v2.log.NameTransformer '" + string2 + "'!");
            exception.printStackTrace();
        }
        transformer = nameTransformer;
        logger = MLog.getLogger(MLog.class);
        Thread thread = new Thread("MLog-Init-Reporter"){

            @Override
            public void run() {
                String string = mlog.getClass().getName();
                if ("com.mchange.v2.log.jdk14logging.Jdk14MLog".equals(string)) {
                    string = "java 1.4+ standard";
                } else if ("com.mchange.v2.log.log4j.Log4jMLog".equals(string)) {
                    string = "log4j";
                } else if ("com.mchange.v2.log.slf4j.Slf4jMLog".equals(string)) {
                    string = "slf4j";
                }
                if (logger.isLoggable(MLevel.INFO)) {
                    logger.log(MLevel.INFO, "MLog clients using " + string + " logging.");
                }
                MLogConfig.logDelayedItems(logger);
                if (logger.isLoggable(MLevel.FINEST)) {
                    logger.log(MLevel.FINEST, "Config available to MLog library: " + MLogConfig.dump());
                }
            }
        };
        thread.start();
    }
}

