﻿<?php
/**
 * Access level module Class
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @version $Id: AccountEdit.php 8 2005-05-25 22:19:23Z madest $
 * @package AccountManager
 * @filesource
 */
 
/**
 * Module for changing access level
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @version $Id: AccountEdit.php 8 2005-05-25 22:19:23Z madest $
 * @package AccountManager
 */
class AccountEdit extends Module
{
	/**
	 * @var object - Account object for editing
	 */
	var $account;
	
	/**
	 * @var string - module output, usually HTML content
	 */
	var $output;

	/**
	 * Constructor loads template and starts content creation
	 */
	function AccountEdit($login, $password)
	{
		$this->Module();
		$this->account = new account($login, $password);
		$this->template = temp_load($this->config->manager['template_path'].'edit_access.htm');
		$this->login = $login;
		$this->check_form();
		$this->get_current();		
		$this->output = $this->template;
	}
	
	function check_form()
	{		
		if(isset($_POST['access']))
		{
			if(is_numeric($_POST['access']))
			{
				if($_POST['access'] <= 999 && $_POST['access'] >= -999)
				{
					$this->account->get();
					$this->account->set_access($_POST['access']);
					$this->write_log("'{$this->active_user->login}' changed access of ACCOUNT: '{$this->account->login}' from {$this->account->access_level} to {$_POST['access']}");
				} else {
					$this->template = "<font color=red>アクセスレベルは-999から999の間でなければなりません。</font>".$this->template;
				}
			} else {
				$this->template = "<font color=red>あなたが入力した値は数字ではありません。</font>".$this->template;
			}
		}
	}
	
	function get_current()
	{
		$q = mysql_query("SELECT * FROM accounts WHERE login = '{$this->login}'");
		$r = mysql_fetch_array($q);
		$this->template = temp_subs($this->template, "account", $r);
	}
	
}
?>