/*
 * Copyright (C) 2004-2013 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package quests.Q00264_KeenClaws;

import jp.sf.l2j.arrayMaps.SortedIntObjectArrayMap;

import com.l2jserver.gameserver.enums.QuestSound;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.quest.State;

/**
 * Keen Claws (264)
 * @author xban1x
 */
public final class Q00264_KeenClaws extends Quest
{
	// Npc
	private static final int PAINT = 30136;
	// Item
	private static final int WOLF_CLAW = 1367;
	// Misc
	private static final int MIN_LVL = 3;
	private static final int WOLF_CLAW_COUNT = 50;
	// Monsters
	private static final SortedIntObjectArrayMap<int[][]> MONSTER_CHANCES = new SortedIntObjectArrayMap<int[][]>()
		// { item_count, random_chance }
		.append(20003, new int[][]{{2, 25}, {8, 50}})
		.append(20456, new int[][]{{1, 80}, {2, 100}})
	;
	// Rewards
	private static final SortedIntObjectArrayMap<ItemHolder[]> REWARDS = new SortedIntObjectArrayMap<ItemHolder[]>()
		.append(1, new ItemHolder[]{new ItemHolder(4633, 1)})
		.append(2, new ItemHolder[]{new ItemHolder(57, 2000)})
		.append(5, new ItemHolder[]{new ItemHolder(5140, 1)})
		.append(8, new ItemHolder[]{new ItemHolder(735, 1), new ItemHolder(57, 50)})
		.append(11, new ItemHolder[]{new ItemHolder(737, 1)})
		.append(14, new ItemHolder[]{new ItemHolder(734, 1)})
		.append(17, new ItemHolder[]{new ItemHolder(35, 1), new ItemHolder(57, 50)})
	;
	
	private Q00264_KeenClaws()
	{
		super(264, Q00264_KeenClaws.class.getSimpleName(), "Keen Claws");
		addStartNpc(PAINT);
		addTalkId(PAINT);
		addKillId(MONSTER_CHANCES.keySet());
		registerQuestItems(WOLF_CLAW);
	}
	
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		final QuestState st = player.getQuestState(getName());
		if ((st != null) && event.equals("30136-03.htm"))
		{
			st.startQuest();
			return event;
		}
		return null;
	}
	
	@Override
	public String onKill(L2Npc npc, L2PcInstance killer, boolean isSummon)
	{
		final QuestState st = killer.getQuestState(getName());
		if ((st != null) && st.isCond(1))
		{
			final int random = getRandom(100);
			for (int[] drop : MONSTER_CHANCES.get(npc.getId()))
			{
				if (random < drop[1])
				{
					if (st.giveItemRandomly(WOLF_CLAW, drop[0], WOLF_CLAW_COUNT, 1, true))
					{
						st.setCond(2);
					}
					break;
				}
			}
		}
		return super.onKill(npc, killer, isSummon);
	}
	
	@Override
	public String onTalk(L2Npc npc, L2PcInstance player)
	{
		final QuestState st = player.getQuestState(getName());
		String htmltext = getNoQuestMsg(player);
		if (st == null)
		{
			return htmltext;
		}
		
		switch (st.getState())
		{
			case State.CREATED:
			{
				htmltext = (player.getLevel() >= MIN_LVL) ? "30136-02.htm" : "30136-01.htm";
				break;
			}
			case State.STARTED:
			{
				switch (st.getCond())
				{
					case 1:
					{
						htmltext = "30136-04.html";
						break;
					}
					case 2:
					{
						if (st.getQuestItemsCount(WOLF_CLAW) >= WOLF_CLAW_COUNT)
						{
							final int chance = getRandom(17);
							for (int index = 0; index < REWARDS.size(); ++index)	// 
							{
								if (chance < REWARDS.keyAt(index))
								{
									for (ItemHolder item : REWARDS.valueAt(index))
									{
										st.rewardItems(item);
									}
									if (chance == 0)
									{
										st.playSound(QuestSound.ITEMSOUND_QUEST_JACKPOT);
									}
									break;
								}
							}
							st.exitQuest(true, true);
							htmltext = "30136-05.html";
						}
						break;
					}
				}
				break;
			}
		}
		return htmltext;
	}
	
	public static void main(String[] args)
	{
		new Q00264_KeenClaws();
	}
}
