﻿## Active Perl 5.8.8

use utf8;
use warnings;
use strict;
use Encode;
binmode STDOUT, ':encoding(cp932)'; $|=1;

my $DEBUG = 0;

opendir DIR,'.'  or die $!;
my @files = readdir DIR;
closedir DIR;

foreach my $fileName (@files) {
	next if $fileName =~ m!^\.!;
	next unless $fileName =~ m!\.html?$!;

	open FILE, '<:utf8', $fileName  or die "'$fileName' $!";
	read FILE, my $htm, -s FILE;
	my $mtime = (stat FILE)[9];
	close FILE;

	my $original = $htm;
	$_           = $htm;
#----------------------------------------------------------------------------
# *-t1.html、*-t2.html テレポート

# ～ Town Square
s!\bAden Town Square\b!アデン城の村 広場!gi;
s!\bDion Town Square\b!ディオン城の村 広場!gi;
s!\bGiran Town Square\b!ギラン城の村 広場!gi;
s!\bGludio Town Square\b!グルーディオ城の村 広場!gi;
s!\bGoddard Town Square\b!ゴダード城の村 広場!gi;
s!\bHeine Town Square\b!水上都市ハイネス 広場!gi;
s!\bOren Town Square\b!オーレン城の村 広場!gi;
s!\bRune Town Square\b!ルウン城の村 広場!gi;
s!\bSchuttgart Town Square\b!シュチュッツガルト城の村 広場!gi;

# Front of the ～ Castle Gate
s!\bFront Of Aden Castle\b!アデン城門前!gi;
s!\bFront Of Dion Castle\b!ディオン城門前!gi;
s!\bFront Of Giran Castle\b!ギラン城門前!gi;
s!\bFront of the Gludio Castle\b!グルーディオ城門前!gi;
s!\bFront Of Goddard Castle\b!ゴダード城門前!gi;
s!\bFront Of Innadril Castle\b!インナドリル城門前!gi;
s!\bFront Of Oren Castle\b!オーレン城門前!gi;
s!\bFront Of Rune Castle\b!ルウン城門前!gi;
s!\bFront Of Schuttgart Castle\b!シュチュッツガルト城門前!gi;

# Front of the ～ Fortress
s!\bFront of the Aaru Fortress\b!草原の境界要塞前!gi;	#静寂の草原
s!\bFront of the Antharas' Fortress\b!地竜の境界要塞前!gi;	#リザードプレイン
s!\bFront of the Archaic Fortress\b!遺跡要塞前!gi;	#空中列車の遺跡
s!\bFront of the Bayou Fortress\b!盆地要塞前!gi;	#巨人たちの洞窟
s!\bFront of the Borderland Fortress\b!アウトポスト要塞前!gi;	#ケトラー オーク アウトポスト
s!\bFront of the Cloud Mountain Fortress\b!霧の山脈境界要塞前!gi;	#ダーク エルフの森
s!\bFront of the Demon Fortress\b!死霊の境界要塞前!gi;	#死霊の関門
s!\bFront of the Dragonspine Fortress\b!ドラゴンスパイン境界要塞前!gi;	#クルマの塔
s!\bFront of the Floran Fortress\b!フローラン境界要塞前!gi;	#フローラン開拓地
s!\bFront of the Hive Fortress\b!ハイヴ要塞前!gi;	#ビーハイヴ
s!\bFront of the Hunter's Fortress\b!猟師の境界要塞前!gi;	#猟師の村
s!\bFront of the Ivory Fortress\b!象牙の塔要塞前!gi;	#象牙の塔
s!\bFront of the Marshland Fortress\b!沼地帯要塞前!gi;	#悲鳴の沼
s!\bFront of the Monastic Fortress\b!聖者の境界要塞前!gi;	#聖者の渓谷
s!\bFront of the Narsell Fortress\b!湖の要塞前!gi;	#ナルセル湖
s!\bFront of the Shanty Fortress\b!露営地要塞前!gi;	#捨てられた露営地
s!\bFront of the Southern Fortress\b!グルーディオ南部要塞前!gi;	#ランク リザードマン生息地
s!\bFront of the Swamp Fortress\b!沼地帯要塞前!gi;	#悲鳴の沼
s!\bFront of the Tanor Fortress\b!タノール境界要塞前!gi;	#タノール渓谷
s!\bFront of the Valley Fortress\b!渓谷要塞前!gi;	#ドラゴンバレー
s!\bFront of the Western Fortress\b!西部国境要塞前!gi;	#国境守備隊
s!\bFront of the White Sands Fortress\b!白浜要塞前!gi;	#クロコダイルの白浜

# 上記以外は L2J_DataPack/build_ja/build_teleports_ja.pl にて処理。

#----------------------------------------------------------------------------
# *****-d.html 門・扉
s/\Q>Open</>開く</g;
s/\Q>open.</>開く</g;
s/\Q>Close</>閉じる</g;
s/\Q>Closed</>閉じる</g;
s/\Q>closed.</>閉じる</g;

s/\Q>Inner gate</>内郭門を</;
s/\Q>Outer gate</>外郭門を</;
s/\Q>Mooring place</>係留所入口を</;
s/\Q>All gates</>城門をすべて</;

s/\Q>Western inner gate</>西内郭門を</;	#35274アデン城
s/\Q>Eastern inner gate</>東内郭門を</;	#35274アデン城
s/\Q>Hall entrance</>ホール入口を</;		#35274アデン城
s/\Q>Second level western gate</>2階西門を</;	#35274アデン城
s/\Q>Second level eastern gate</>2階東門を</;	#35274アデン城
s/\Q>Terrace entrance</>テラス入口を</;	#35274アデン城
s/\Q>Eastern entrance to the sky walk</>東の空中通路入口を</;	#35274アデン城
s/\Q>Eastern outer gate</>東の外郭壁通路入口を</;	#35274アデン城
s/\Q>Western entrance to the sky walk</>西の空中通路入口を</;	#35274アデン城
s/\Q>Western outer gate</>西の外郭壁通路入口を</;	#35274アデン城

s/\Q>The outer gate is</>外郭門を</;	#35509ルウン城
s/\Q>The inner gate is</>内郭門を</;	#35509ルウン城
s/\Q>The east inner gate is</>東内郭門を</;	#35509ルウン城
s/\Q>All the gates are</>城門をすべて</;	#35509ルウン城

s/\Q>Outer castle gate is</>外郭門を</;	#35363ゴダード城、35555シュチュッツガルト城〓仮〓
s/\Q>Inner castle gate on the 1st floor is</>1階内郭門を</;	#35363ゴダード城〓仮〓
s/\Q>Inner castle gate on the 2nd floor is</>2階内郭門を</;	#35363ゴダード城〓仮〓
s/\Q>Entrance to the mooring is</>係留所入口を</;	#35363ゴダード城
s/\Q>All the castle gates are</>城門をすべて</;	#35363ゴダード城、35555シュチュッツガルト城
#----------------------------------------------------------------------------
# *****-du.html 城門・城壁
s/\Q>Reinforce outer castle gate.</>外郭門強化</;
s/\Q>Reinforce inner castle gate.</>内閣門強化</;
s/\Q>Reinforce castle walls.</>城壁強化</;

s/\Q>Reinforce outer castle gate</>外郭門強化</;	#35274アデン城〓仮〓
s/\Q>Reinforce western inner castle gate</>西内郭門強化</;	#35274アデン城〓仮〓
s/\Q>Reinforce eastern inner castle gate</>東内郭門強化</;	#35274アデン城〓仮〓
s/\Q>Reinforce entrance to inner castle hall</>ホール入口を強化</;	#35274アデン城〓仮〓
s/\Q>Reinforce outer castle wall</>城壁強化</;	#35274アデン城〓仮〓
s/\Q>Reinforce inner castle wall</>内郭壁強化</;	#35274アデン城〓仮〓

s/\Q>Reinforce the outer gate</>外郭門強化</;	#35509ルウン城〓仮〓
s/\Q>Reinforce the inner gate</>内閣門強化</;	#35509ルウン城〓仮〓
s/\Q>Reinforce the east inner gate</>東内郭門強化</;	#35509ルウン城〓仮〓
s/\Q>Reinforce the outer wall</>外郭城壁強化</;	#35509ルウン城〓仮〓
s/\Q>Reinforce the inner wall</>内閣城壁強化</;	#35509ルウン城〓仮〓

s/\Q>Outer Door Reinforcement</>外郭門強化</;	#35363ゴダード城、35555シュチュッツガルト城〓仮〓
s/\Q>Inner Door Reinforcement 1F</>1階内郭門強化</;	#35363ゴダード城、35555シュチュッツガルト城〓仮〓
s/\Q>Inner Door Reinforcement 2F</>2階内郭門強化</;	#35363ゴダード城、35555シュチュッツガルト城〓仮〓
s/\Q>Wall Reinforcement</>城壁強化</;	#35363ゴダード城、35555シュチュッツガルト城〓仮〓
#----------------------------------------------------------------------------
# *****-tu.html 罠
s/\Q>Activate the trap near the entrance of the inner castle.</>内郭の入口の罠を作動させる</;
s/\Q>Activate the trap behind the garden in the inner castle.</>内閣の庭園裏の罠を作動させる</;
s/\Q>Activate the trap near the east entrance of the 2nd floor.</>2階東側入口の罠を作動させる</;	#〓仮〓
s/\Q>Activate the trap near the west entrance of the 2nd floor.</>2階西側入口の罠を作動させる</;	#〓仮〓
s/\Q>Deploy the device east of the castle</>城の東の罠を作動させる</;	#35274アデン城〓仮〓
s/\Q>Deploy the device west of the castle</>城の西の罠を作動させる</;	#35274アデン城〓仮〓
#----------------------------------------------------------------------------
s/\Q>Back</>戻る</;
s/\Q>Go back</>戻る</;
s/\Q>Return</>戻る</;
#----------------------------------------------------------------------------

	$htm = $_;

	if ($htm ne $original) {
		print $fileName,"\n";
		my $output = $fileName;
		   $output = "$fileName.text" if $DEBUG;
		open FILE, '>:utf8', $output  or die "'$output' $!";
		$htm = "\x{feff}".$htm unless $htm =~ m/^\x{feff}/;  #BOM
		print FILE $htm;
		close FILE;
		utime $mtime,$mtime,$output;
	}
}
