﻿## Active Perl 5.8.8

# 目的：
#   Windows エクスプローラからクリック起動したときは PAUSE で止める。
#   コマンド プロンプトから起動したときは止めない。
#
# 原理：
#   バッチファイルのいちばん最後の pause を書き換えるだけ。
#   フルパスで起動されたときだけ PAUSE で止めるようにする。

use utf8;
use strict;
use warnings;
use Encode;

binmode STDOUT,':encoding(cp932)';
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

&start('game/startGameServer.bat');
&start('login/RegisterGameServer.bat');
&start('login/startLoginServer.bat');
&start('login/startSQLAccountManager.bat');

exit 0;

sub start($) {
	my ($filepath) = @_;

	print $filepath;
	open FILE, '<:encoding(cp932)', FS($filepath)  or die;
	read FILE, my $bat, -s FILE;
	close FILE;

	my $pattern = '@?pause$';
	my $string1 = '@@IF "%~0" == "%cd%\%~nx0" @PAUSE';
	if ($bat =~ s/\n$pattern/\n$string1/si) {
		open FILE, '>:encoding(cp932)', FS($filepath)  or die;
		print FILE $bat;
		close FILE;
		print " - updat\n";
	} else {
		print "\n";
	}
}
