/*
 * Copyright (C) 2005-2008 L2J_JP / 2008-2013 L2J-SFJP
 * 
 * This file is part of L2J Server.
 * 
 * L2J Server is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J Server is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package events.Watermelon;

import static com.l2jserver.gameserver.util.EventNpcAligner.align;
import static com.l2jserver.gameserver.util.EventNpcAligner.getSpawns;
import static com.l2jserver.gameserver.util.Util.contains;

import java.util.Arrays;
import java.util.Comparator;

import javolution.util.FastMap;

import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2ChronoMonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.network.clientpackets.Say2;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;
import com.l2jserver.util.Rnd;

/**
 * @author JOJO
 *
 * Original: "SquashEvent" Gnacik version 1.0
 * Java   By JOJO@L2J-SFJP 06-08-2010
 * Update By pmq@L2J-TW    04-09-2010
 * Update By JOJO@L2J-SFJP 03-12-2010
 */
public class Watermelon extends Quest
{
	private static final String qn = "Watermelon";
/**
 * Cxgis t@X U Lbg Npc ID (31227) Original: ID (32727) For Freya New Npc
 */
	private static final int MANAGER = 31227;
/**
 * lN^[ Skill ID (2005)
 */
	private static final int NECTAR_SKILL = 2005;

	private static final long DESPAWN_FIRST = 180000;
	private static final long DESPAWN_NEXT = 90000;

	private static final int DAMAGE_MAX = 12;
	private static final int DAMAGE_DEFAULT = 5;
/**
 * C1LOy Nm L^   Item ID (4202) * C2LOy Nm ^o Item ID (5133)
 * C3LOy Nm Jpi Item ID (5817) * C4LOy Nm _ubJ Item ID (7058)
 * C5LOy Nm }JX Item ID (8350)
 */
	private static final int[] CHRONO_LIST =
	{
		4202,5133,5817,7058,8350
	};
/**
 * c傫ȃXCJ     Mob ID (13271) * ǎȑ傫ȃXCJ       Mob ID (13273) * sǂȑ傫ȃXCJ     Mob ID (13272)
 * c傫ȊÂXCJ Mob ID (13275) * ǎȑ傫ȊÂXCJ   Mob ID (13277) * sǂȑ傫ȊÂXCJ Mob ID (13276)
 * ǎȑ傫ȃXCJ Mob ID (13274) * ǎȑ傫ȊÂXCJ Mob ID (13278)
 */
	private static final int[] WATERMELON_LIST =
	{
		13271,13273,13272,
		13275,13277,13276,
		13274,13278
	};

	// ŗc`҂Ƃ̋
	private static final int[] SPAWN_TEXT =
	{
		1800903,	//͂ǂIĂ񂾂̂͒NI
		1800904,	//[IAXCJłI
		1800905,	//̂ƁAĂ񂾁H
		1800906,	//XCJ̓ołIꂩǂǂłI
		1800907,	//ւAЂԂI
		1800908,	//傫XCJɂȁ`IςĂ̓XCJ˂B
		1800909,	//̂ƁAĂ񂾁H낻뉽oĎvĂƂႤ́H
		1800910,	//hɈ̎pAH
		1800911,	//ւււIꏏɂ낤I
		1800912,	//܂ƈĂrbOXCJAsoȂłI
	};
	// lN^[ŐƂ̋
	private static final int[] GROWUP_TEXT =
	{
		1800913,	//[IϐgłI
		1800914,	//[āAǎȑ傫ȃXCJ납ȁHsǂȑ傫ȃXCJ납ȁH
		1800915,	//傫ȂĂȁ`AI
		1800916,	//傫Ȃ那`Ȃ那`肢Ă݁I
		1800917,	//oȂɂȁ`IāA炿܂I
		1800918,	//łXCJɂȁ`I͂NĂI
		1800919,	//Ăȁ`قȁAłI
		1800920,	//1000Afi邩AĂI
		1800921,	//`āA̒ɂ͉l܂Ă邩ȂH
		1800922,	//AIقȂA炦̂킩ĂH
	};
	// lN^[܂Ƃ̋
	private static final int[] POISON_TEXT =
	{
		1800923,	//ƂIڂĂIق܂ɂȂDDD
		1800924,	//ACIƂāI
		1800925,	//ނCIƂȂ́H
		1800926,	//̉肭I͂܂I
		1800927,	//I˂AIܖ؂Ă񂿂ႤH
		1800928,	//ȁAȁBƂ񂪂񂩂ĂI
		1800929,	//AႤ`˂IAÍAw^N\I
		1800930,	//Ỉ˂IlN^[ႤƂႤ́H
		1800931,	//ƂĂȁI܂Ƃւ񂩂A炽łI
		1800932,	//ق܂ɃlN^[̓XCJlN^[ōȂI͂͂͂I
	};
	// lN^[^ȂŕuƂ̋
	private static final int[] HUNGRY_TEXT =
	{
	/*	1800933,	//ȁAȁIƂ񂪂ǂĂ`			*/
	/*	1800934,	//Ȃłǂ˂I\̓n^`CIƃlN^[I	*/
		1800935,	//ꂽǂȂ˂I
		1800936,	//Ă̂ɐH񂩂IɂI
		1800937,	//ǂǂǂĂ`lN^[ق˂I
		1800938,	//ĂǂȂ˂IӔCĂ`
		1800939,	//ĂA܂葹̂тׂłIȂɉȂ񂩁H
		1800940,	//AƂ΂`
		1800941,	//̓lN^[܂Ǝł܂BmƎʂ悤ȂIĂI
		1800942,	//A͂ʂDDD߂DDD
	};
	// Ԑ؂̂Ƃ̋
	private static final int[] TIMEUP_TEXT =
	{
		1800948,	//AABقȁAȂI
		1800949,	//cOȁBrbNXCJƂ͂ł΂B
		1800950,	//x˂IقȁAȂI
		1800951,	//AsȂ˂By݂ɂĂłI
		1800952,	//cOȁBƂ̂ɁB
	};
	// ÂXCJNmōUƂ̋
	private static final int[] CHRONO_TEXT =
	{
		1800953,	//ւAFȁB
		1800954,	//ȂAȂAȉ̂ĂH
		1800955,	//Ȃイ͉̂ʕɂ`˂B
		1800956,	//AoC₟`ƕĂȂI
		1800957,	//̂߂ɒeĂ񂩁HꂵȂI
		1800958,	//ȂAƂႤH
		1800959,	//ȁAȁI
		1800960,	//`AĝYYĂI
		1800961,	//A̘aIōȁIƕĂȂI
		1800962,	//₪ȁĨTEhĂIA^A~[WVɂȂƂႤH
	};
	// ÂXCJwO̕ōUƂ̋
	private static final int[] NOCHRONO_TEXT =
	{
		1800963,	//Ȃ񂿂ႤIǂAƂƂI
		1800964,	//ɂ`˂I͉y˂IƂI
		1800965,	//̐SƐĝɋ悤ȁATEhŗނłI
		1800966,	//ꂿႤȁIAINm̊yIłI
		1800967,	//Aq}ByȂAq}ł`ȂBAAłB
		1800968,	//ȂAD˂ȈoŗނI
		1800969,	//傫XCJ͉yłJ˂ŁBłǂĂB
		1800970,	//yŗނIȂAD˂IyłȁI
		1800971,	//ނႷA^bNȁI₯ǉȂ疳ʂłI
		1800972,	//̓X^[p`˂INm˂I
	};
	// ̋
	private static final int[] KILL_TEXT =
	{
		1800973,	//łI
		1800974,	//łȂȂɑ厖ɂĂ˂I
		1800975,	//ǂȂAƂ̂ЂƎAyH
		1800976,	//rbOXCJɂȂ܂悤ɂI
		1800977,	//I͂ʁI
		1800978,	//IA`I
		1800979,	//ŎdI
		1800980,	//A₵I
		1800981,	//XCJAłIACeołI
		1800982,	//ĂȂIgǂǂoĂI
	};
	// ʏXCJUƂ̋
	private static final int[] ATTACK_TEXT =
	{
		1800983,	//قȁADނłI
		1800984,	//ւAȂȂ̘rI
		1800985,	//炨AƂǂ񂩂`˂I
		1800986,	//̓hM˂BƂǂĂI
		1800987,	//΂񂩂ȁIԁAւ񂪂ȁB
		1800988,	//ȂŊvĂ̂ႤȁH
		1800989,	//ȁAȁIȂňނB
		1800990,	//₹AIႤႤIƉEI
		1800991,	//ȂÃlRp`݂Ȃ́HO͂I
		1800992,	//l@ՂA`ȁB
	};
	// lN^[Ƃ̋
	private static final int[] NECTAR_TEXT =
	{
		1800993,	//ށAƃlN^[I
		1800994,	//lN^[Ȃ炽ւI
		1800995,	//΂ĈĂI܂ƈĂrbOXCJAsoȂłI
		1800996,	//`lN^[܂I`lN^[܂Ỉ́Am񂩁H
		1800997,	//lN^[AlN^[悱IlN^CAႤŁIԂI
		1800998,	//lN^[ꂽǂǂłI
		1800999,	//͂܂n˂Iق܂ɃC`Ȃ`Ƒ҂ĂI
		1801000,	//͂ȂA啨ɂȂ˂IƈĂĂꂳȁB
		1801001,	//rbOȃXCJق񂩁H͏oȂłB
		1801002,	//MălN^[ꂽ炦˂IقȂArbOȃXCJɂȂłI
	};
	// hbv Xg y ID X^[ , NO m , ID ACe, NO  z
	private static final int[][] DROPLIST =
	{
		/**
		 * <DEL>must be sorted by npcId !</DEL>
		 * npcId, chance, itemId,qty [,itemId,qty...]
		 *
		 * Young Watermelon
		 * c傫ȃXCJ
		 */
		{ 13271,100,  6391,2 },		// Nectar
		/**
		 * Defective Watermelon
		 * sǂȑ傫ȃXCJ
		 */
		{ 13272,100,  6391,50 },	// Nectar
		/**
		 * Rain Watermelon
		 * ǎȑ傫ȃXCJ
		 */
		{ 13273,100,  6391,100 },	// Nectar
		/**
		 * Large Rain Watermelon
		 * ǎȑ傫ȃXCJ
		 */
		{ 13274,100,  6391,150 },	// Nectar
		/**
		 * Young Honey Watermelon
		 * c傫ȊÂXCJ
		 */
		{ 13275,100, 14701,2,		//͏uԑ̗͉񕜍
		             14700,2 },		//̗͉͑񕜍
		/**
		 * Defective Honey Watermelon
		 * sǂȑ傫ȊÂXCJ
		 */
		{ 13276, 50,   729,4,		//틭XN[FAO[h
		               730,4,		//hXN[FAO[h
		              6569,2,		//jꂽ틭XN[FAO[h
		              6570,2 },		//jꂽhXN[FAO[h
		{ 13276, 30,  6622,1 },		//l̔`
		{ 13276, 10,  8750,1 },		//㋉ ̐΁Fx67
		{ 13276, 10,  8751,1 },		//㋉ ̐΁Fx70
		{ 13276, 99, 14701,4,		//͏uԑ̗͉񕜍
		             14700,4 },		//̗͉͑񕜍
		{ 13276, 50,  1461,4 },		//NX^FAO[h
		{ 13276, 30,  1462,3 },		//NX^FSO[h
		{ 13276, 50,  2133,4 },		//WFXg[FAO[h
		{ 13276, 30,  2134,3 },		//WFXg[FSO[h
		/**
		 * Rain Honey Watermelon
		 * ǎȑ傫ȊÂXCJ
		 */
		{ 13277,  7,  9570,1,		//bh \E Xg[FXebv14
		              9571,1,		//u[ \E Xg[FXebv14
		              9572,1,		//O[ \E Xg[FXebv14
		             10480,1,		//bh \E Xg[FXebv15
		             10481,1,		//u[ \E Xg[FXebv15
		             10482,1,		//O[ \E Xg[FXebv15
		             13071,1,		//bh \E Xg[FXebv16
		             13072,1,		//u[ \E Xg[FXebv16
		             13073,1 },		//O[ \E Xg[FXebv16
		{ 13277, 35,   729,4,		//틭XN[FAO[h
		               730,4,		//hXN[FAO[h
		               959,3,		//틭XN[FSO[h
		               960,3,		//hXN[FSO[h
		              6569,2,		//jꂽ틭XN[FAO[h
		              6570,2,		//jꂽhXN[FAO[h
		              6577,1,		//jꂽ틭XN[FSO[h
		              6578,1 },		//jꂽhXN[FSO[h
		{ 13277, 28,  6622,3,		//l̔`
		              9625,2,		//l̔`FYp
		              9626,2,		//l̔`FC
		              9627,2 },		//l̔`Fn
		{ 13277, 14,  8750,10 },	//㋉ ̐΁Fx67
		{ 13277, 14,  8751,8 },		//㋉ ̐΁Fx70
		{ 13277, 14,  8752,6 },		//㋉ ̐΁Fx76
		{ 13277, 14,  9575,4 },		//㋉ ̐΁Fx80
		{ 13277, 14, 10485,2 },		//㋉ ̐΁Fx82
		{ 13277, 14, 14168,1 },		//㋉̐΁Fx84
		{ 13277, 21,  8760,1,		//ŏ㋉̐΁Fx67
		              8761,1,		//ŏ㋉̐΁Fx70
		              8762,1,		//ŏ㋉̐΁Fx76
		              9576,1,		//ŏ㋉̐΁Fx80
		             10486,1,		//ŏ㋉̐΁Fx82
		             14169,1 },		//ŏ㋉̐΁Fx84
		{ 13277, 21, 14683,1,		//͐̔FcO[h
		             14684,1,		//͐̔FCO[h
		             14685,1,		//͐̔FBO[h
		             14686,1,		//͐̔FAO[h
		             14687,1,		//͐̔FSO[h
		             14689,1,		//͐_̔FcO[h
		             14690,1,		//͐_̔FCO[h
		             14691,1,		//͐_̔FBO[h
		             14692,1,		//͐_̔FAO[h
		             14693,1,		//͐_̔FSO[h
		             14695,1,		//͓u̔FcO[h
		             14696,1,		//͓u̔FCO[h
		             14697,1,		//͓u̔FBO[h
		             14698,1,		//͓u̔FAO[h
		             14699,1 },		//͓u̔FSO[h
		{ 13277, 99, 14701,9,		//͏uԑ̗͉񕜍
		             14700,9 },		//̗͉͑񕜍
		{ 13277, 63,  1461,8 },		//NX^FAO[h
		{ 13277, 49,  1462,5 },		//NX^FSO[h
		{ 13277, 63,  2133,6 },		//WFXg[FAO[h
		{ 13277, 49,  2134,4 },		//WFXg[FSO[h
		/**
		 * Large Rain Honey Watermelon
		 * ǎȑ傫ȊÂXCJ
		 */
		{ 13278, 10,  9570,1,		//bh \E Xg[FXebv14
		              9571,1,		//u[ \E Xg[FXebv14
		              9572,1,		//O[ \E Xg[FXebv14
		             10480,1,		//bh \E Xg[FXebv15
		             10481,1,		//u[ \E Xg[FXebv15
		             10482,1,		//O[ \E Xg[FXebv15
		             13071,1,		//bh \E Xg[FXebv16
		             13072,1,		//u[ \E Xg[FXebv16
		             13073,1 },		//O[ \E Xg[FXebv16
		{ 13278, 50,   729,4,		//틭XN[FAO[h
		               730,4,		//hXN[FAO[h
		               959,3,		//틭XN[FSO[h
		               960,3,		//hXN[FSO[h
		              6569,2,		//jꂽ틭XN[FAO[h
		              6570,2,		//jꂽhXN[FAO[h
		              6577,1,		//jꂽ틭XN[FSO[h
		              6578,1 },		//jꂽhXN[FSO[h
		{ 13278, 40,  6622,3,		//l̔`
		              9625,2,		//l̔`FYp
		              9626,2,		//l̔`FC
		              9627,2 },		//l̔`Fn
		{ 13278, 20,  8750,10 },	//㋉ ̐΁Fx67
		{ 13278, 20,  8751,8 },		//㋉ ̐΁Fx70
		{ 13278, 20,  8752,6 },		//㋉ ̐΁Fx76
		{ 13278, 20,  9575,4 },		//㋉ ̐΁Fx80
		{ 13278, 20, 10485,2 },		//㋉ ̐΁Fx82
		{ 13278, 20, 14168,1 },		//㋉̐΁Fx84
		{ 13278, 30,  8760,1,		//ŏ㋉̐΁Fx67
		              8761,1,		//ŏ㋉̐΁Fx70
		              8762,1,		//ŏ㋉̐΁Fx76
		              9576,1,		//ŏ㋉̐΁Fx80
		             10486,1,		//ŏ㋉̐΁Fx82
		             14169,1 },		//ŏ㋉̐΁Fx84
		{ 13278, 30, 14683,1,		//͐̔FcO[h
		             14684,1,		//͐̔FCO[h
		             14685,1,		//͐̔FBO[h
		             14686,1,		//͐̔FAO[h
		             14687,1,		//͐̔FSO[h
		             14689,1,		//͐_̔FcO[h
		             14690,1,		//͐_̔FCO[h
		             14691,1,		//͐_̔FBO[h
		             14692,1,		//͐_̔FAO[h
		             14693,1,		//͐_̔FSO[h
		             14695,1,		//͓u̔FcO[h
		             14696,1,		//͓u̔FCO[h
		             14697,1,		//͓u̔FBO[h
		             14698,1,		//͓u̔FAO[h
		             14699,1 },		//͓u̔FSO[h
		{ 13278, 99, 14701,12,		//͏uԑ̗͉񕜍
		             14700,12 },	//̗͉͑񕜍
		{ 13278, 90,  1461,8 },		//NX^FAO[h
		{ 13278, 70,  1462,5 },		//NX^FSO[h
		{ 13278, 90,  2133,6 },		//WFXg[FAO[h
		{ 13278, 70,  2134,4 },		//WFXg[FSO[h
	};

	class TheInstance
	{
		int nectar;
		int success;
		long despawnTime;
	}
	private FastMap<L2ChronoMonsterInstance, TheInstance> _monsterInstances = new FastMap<L2ChronoMonsterInstance, TheInstance>().shared();
	private TheInstance create(L2ChronoMonsterInstance mob)
	{
		TheInstance mons = new TheInstance();
		_monsterInstances.put(mob, mons);
		return mons;
	}
	private TheInstance get(L2ChronoMonsterInstance mob)
	{
		return _monsterInstances.get(mob);
	}
	private void remove(L2ChronoMonsterInstance mob)
	{
		cancelQuestTimer("countdown", mob, null);
		cancelQuestTimer("despawn", mob, null);
		_monsterInstances.remove(mob);
	}

	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		if (event == "countdown")
		{
			final L2ChronoMonsterInstance mob = (L2ChronoMonsterInstance)npc;
			final TheInstance self = get(mob);
			int timeLeft = (int)((self.despawnTime - System.currentTimeMillis() + 500) / 1000);

			switch (timeLeft)
			{
			case 120:
				if (self.nectar == 0)
					autoChat(mob, 1800946);	//lN^[ւ񂩂A2ɋAłI
				break;
			case 60:
				if (self.nectar == 0)
					autoChat(mob, 1800947);	//lN^[ւ񂩂A1ɋAłI
				break;
			case 30:
				if (self.nectar == 0)
					autoChat(mob, 1800943);	//炵߂˂IOI30bȓɂւ񂩂AAłI
				break;
			case 20:
				autoChat(mob, 1800944);	//20bȂłI
				break;
			case 10:
				autoChat(mob, 1800945);	//Ac10bI9DDD8DDD7DDD
				break;
			case 0:
				autoChat(mob, TIMEUP_TEXT);
				break;
			default:
				if ((timeLeft % 20) == 0)
					if (self.nectar == 0)
						autoChat(mob, HUNGRY_TEXT);
				break;
			}
		}
		else if (event == "despawn")
		{
			remove((L2ChronoMonsterInstance)npc);
			npc.deleteMe();
		}
		else if (event == "sound")
		{
			((L2ChronoMonsterInstance)npc).broadcastPacket(new PlaySound(0, "ItemSound3.sys_sow_success", 0, 0, 0, 0, 0));
		}
		else
			return super.onAdvEvent(event, npc, player);
		return null;
	}

	@Override
	public String onAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isPet)
	{
		final L2ChronoMonsterInstance mob = (L2ChronoMonsterInstance)npc;
		L2Weapon weapon;
		final boolean isChronoAttack
			= !isPet
			&& (weapon = attacker.getActiveWeaponItem()) != null && contains(CHRONO_LIST, weapon.getItemId());
		switch (mob.getNpcId())
		{
			case 13271:
			case 13273:
			case 13272:
			case 13274:
				if (Rnd.get(100) < 20)
					autoChat(mob, ATTACK_TEXT);
				break;
			case 13275:
			case 13277:
			case 13276:
			case 13278:
				if (isChronoAttack)
				{
					mob.setIsInvul(false);
					if (damage == 0)
						mob.getStatus().reduceHp(DAMAGE_DEFAULT, attacker);
					else if (damage > DAMAGE_MAX)
						mob.getStatus().setCurrentHp(mob.getStatus().getCurrentHp() + damage - DAMAGE_MAX);
					if (Rnd.get(100) < 20)
						autoChat(mob, CHRONO_TEXT);
				}
				else
				{
					mob.setIsInvul(true);
					mob.setCurrentHp(mob.getMaxHp());
					if (Rnd.get(100) < 20)
						autoChat(mob, NOCHRONO_TEXT);
				}
				break;
			default:
				throw new RuntimeException();
		}
		mob.getStatus().stopHpMpRegeneration();
		return super.onAttack(npc, attacker, damage, isPet);
	}

	@Override
	public String onSkillSee(L2Npc npc, L2PcInstance caster, L2Skill skill, L2Object[] targets, boolean isPet)
	{
		if (skill.getId() == NECTAR_SKILL && targets[0] == npc)
		{
			final L2ChronoMonsterInstance mob = (L2ChronoMonsterInstance)npc;
			switch(mob.getNpcId())
			{
				case 13271:
					randomSpawnYoung(13272, 13273, 13274, mob);
					break;
				case 13275:
					randomSpawnYoung(13276, 13277, 13278, mob);
					break;
				case 13273:
					randomSpawnHigh(13274, mob);
					break;
				case 13277:
					randomSpawnHigh(13278, mob);
					break;
				case 13272:
				case 13276:
					autoChat(mob, 1800974);	//łȂȂɑ厖ɂĂ˂I
					break;
			}
		}
		return null;
	//	return super.onSkillSee(npc,caster,skill,targets,isPet);
	}

	@Override
	public String onKill(L2Npc npc, L2PcInstance killer, boolean isPet)
	{
		final L2ChronoMonsterInstance mob = (L2ChronoMonsterInstance)npc;
		remove(mob);
		autoChat(mob, KILL_TEXT);
		dropItem(mob, killer);
		return super.onKill(npc, killer, isPet);
	}

	@Override
	public String onSpawn(L2Npc npc)
	{
		assert npc instanceof L2ChronoMonsterInstance;
		
		final L2ChronoMonsterInstance mob = (L2ChronoMonsterInstance)npc;
		mob.setOnKillDelay(1500);	//Default 5000ms.
		final TheInstance self = create(mob);
		switch(mob.getNpcId())
		{
			case 13271:
			case 13275:
				startQuestTimer("countdown", 10000, mob, null, true);
				startQuestTimer("despawn", DESPAWN_FIRST + 3333, mob, null);
				self.nectar = 0;
				self.despawnTime = System.currentTimeMillis() + DESPAWN_FIRST;
				autoChat(mob, SPAWN_TEXT);
				break;
			case 13272:
			case 13273:
			case 13274:
			case 13276:
			case 13277:
			case 13278:
				startQuestTimer("countdown", 10000, mob, null, true);
				startQuestTimer("despawn", DESPAWN_NEXT + 3333, mob, null);
				self.nectar = 5;
				self.despawnTime = System.currentTimeMillis() + DESPAWN_NEXT;
				autoChat(mob, GROWUP_TEXT);
				startQuestTimer("sound",3000, mob, null);
				break;
			default:
				throw new RuntimeException();
		}
		return null;
	}

	static {
		Arrays.sort(DROPLIST, new Comparator<int[]>() {
			@Override
			public int compare(int[] a, int[] b) { return a[0] - b[0]; }
		});
	}
	private static final void dropItem(L2ChronoMonsterInstance mob, L2PcInstance player)
	{
		final int npcId = mob.getNpcId();
		for (int[] drop : DROPLIST)
		{
			/**
			 * npcId   = drop[0]
			 * chance  = drop[1]
			 * itemId  = drop[2,4,6,8...]
			 * itemQty = drop[3,5,7,9...]
			 */
			if (npcId == drop[0])
			{
				final int chance = Rnd.get(100);
				if (chance < drop[1])
				{
					int i = 2 + 2 * Rnd.get((drop.length - 2) / 2);
					int itemId = drop[i + 0];
					int itemQty = drop[i + 1];
					if (itemQty > 1) itemQty = Rnd.get(1, itemQty);
					mob.dropItem((L2PcInstance)mob.getSummoner(), itemId, itemQty);
					continue;
				}
			}
			if (npcId < drop[0])
				return; // not found
		}
	}

	private void randomSpawnYoung(int bad, int good, int king, L2ChronoMonsterInstance mob)
	{
		final TheInstance self = get(mob);
		++self.nectar;
		final int[] npcString;
		
		if (Rnd.get(100) < 50)
		{
			++self.success;
			mob.doCast(SkillTable.getInstance().getInfo(4513, 1));
			npcString = NECTAR_TEXT;
		}
		else
		{
			mob.doCast(SkillTable.getInstance().getInfo(4514, 1));
			npcString = POISON_TEXT;
		}
		
		if (self.nectar == 5)
		{
			if (self.success >= 5) 
				spawnNext(king, mob);	// [5..5] 1/6=16.6%: cǎ
			else if (self.success >= 3) 
				spawnNext(good, mob);	// [3..4] 2/6=33.3%: cǎ
			else 
				spawnNext(bad, mob);	// [0..2] 3/6=49.9%: csǂ
		}
		else /*if (self.nectar < 5)*/
		{
			autoChat(mob, npcString);
		}
	}

	private void randomSpawnHigh(int king, L2ChronoMonsterInstance mob)
	{
		final TheInstance self = get(mob);
		if (++self.nectar > 5 && self.nectar <= 15 && Rnd.get(100) < 15 - self.nectar)	// 10% ǎȁǎ
		{
		//	mob.doCast(SkillTable.getInstance().getInfo(4513, 1));
			spawnNext(king, mob);
		}
		else
		{
			mob.doCast(SkillTable.getInstance().getInfo(4514, 1));
			autoChat(mob, POISON_TEXT);
		}
	}

	private void autoChat(L2ChronoMonsterInstance mob, int npcString)
	{
		mob.broadcastPacket(new NpcSay(mob.getObjectId(), Say2.ALL, mob.getNpcId(), npcString));
	}
	private void autoChat(L2ChronoMonsterInstance mob, int[] npcString)
	{
		autoChat(mob, npcString[Rnd.get(npcString.length)]);
	}

	private void spawnNext(int npcId, L2ChronoMonsterInstance oldMob)
	{
		remove(oldMob);
		L2ChronoMonsterInstance newMob = (L2ChronoMonsterInstance)addSpawn(npcId, oldMob.getX(), oldMob.getY(), oldMob.getZ(), oldMob.getHeading(), false, 0, false, oldMob.getInstanceId());
		newMob.setSummoner(oldMob.getSummoner());
		newMob.setTitle(oldMob.getTitle());
		oldMob.deleteMe();
	}

	private Watermelon(int questId, String name, String descr)
	{
		super(questId, name, descr);

		for (int mob : WATERMELON_LIST)
		{
			addAttackId(mob);
			addKillId(mob);
			addSpawnId(mob);
			addSkillSeeId(mob);
		}

		addStartNpc(MANAGER);
		addFirstTalkId(MANAGER);
		addTalkId(MANAGER);
		
		for (Location spawn : getSpawns())
			align(addSpawn(MANAGER, spawn, false, 0))
			.setTitle("XCJCxg");
	}

	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
//		String htmltext = "";
		QuestState st = player.getQuestState(getName());
		if (st == null)
		{
			Quest q = QuestManager.getInstance().getQuest(getName());
			st = q.newQuestState(player);
		}
		switch (npc.getNpcId())
		{
			case MANAGER: return "31227.htm";
		}
		throw new RuntimeException();
	}

	@Override
	public String onEvent(String event, QuestState qs)
	{
		// 31227-1.htm
		return event;
	}

	public static void main(String[] args)
	{
		new Watermelon(-1, qn, "events");
	}
}