/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.npc.NpcBuffers;

import java.util.concurrent.ScheduledFuture;

import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.Say2;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.util.Rnd;

/**
 * @author Layane
 * @author UnAfraid
 * mod JOJO
 * 
 * 31093 ŖSԎ
 * 31094 [`
 */
public class CabaleBuffer extends AbstractNpcAI
{
	private static final int DISTANCE_TO_WATCH_OBJECT = 900;
	private static final int AUTOCHAT_RANGE = 1200;
	private static final int AUTOCHAT_RATE = 8;	// percent
	
	protected static final int[] PREACHER_AUTOCHAT_PLAYER = {
		1000418,	//$s1IȂɖŖS̒I
		1000419,	//$s1IȂɐ]Ă낤I
	};
	protected static final int[] PREACHER_AUTOCHAT_DEFAULT = {
		1000415,	//F̎ҁA߂݂ɕ邪悢IԂȂ̏_~Ղ̂I
		1000416,	//F̎ҁA߂݂ɕ邪悢IԂȂŖS̗\ł낤I
		1000417,	//ŖS̗\ɎXIԂȂI̎オn܂̂I
		1000420,	//I̎𐶂҂A]̕ɗI
	};
	
	protected static final int[] ORATOR_AUTOCHAT_PLAYER = {
		1000424,	//$s1IȂɌ[̏j^悤I
		1000425,	//$s1IȂɐ[̌\^悤I
	};
	protected static final int[] ORATOR_AUTOCHAT_DEFAULT = {
		1000421,	//ł̌[ɎXIł肩o߂̂I
		1000422,	//ł̌[ɎXIׂ̎オn܂̂I
		1000423,	//ł̌[ɎXIԂȂ̊yƂȂ邾낤I
		1000426,	//VJ҂Aڂo܂I
	};
	
	protected CabaleBuffer(String name, String descr)
	{
		super(name, descr);
		addFirstTalkId(SevenSigns.ORATOR_NPC_ID, SevenSigns.PREACHER_NPC_ID);
		addSpawnId(SevenSigns.ORATOR_NPC_ID, SevenSigns.PREACHER_NPC_ID);
	}
	
	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
		return null;
	}
	
	@Override
	public String onSpawn(L2Npc npc)
	{
		new CabaleAI(npc);
		return super.onSpawn(npc);
	}
	
	protected class CabaleAI implements Runnable
	{
		private final L2Npc _npc;
		private final int _playerCabal;
		private final int _skillFighter, _skillMage;
		private final int[] _autoChatPlayer, _autoChatDefault;
		private ScheduledFuture<?> _aiTask;
		
		protected CabaleAI(L2Npc npc)
		{
			_npc = npc;
			
			final int winningCabal = SevenSigns.getInstance().getCabalHighestScore();
			final int losingCabal = winningCabal == SevenSigns.CABAL_DAWN ? SevenSigns.CABAL_DUSK
			                      : winningCabal == SevenSigns.CABAL_DUSK ? SevenSigns.CABAL_DAWN
			                      : SevenSigns.CABAL_NULL;
			
			switch (npc.getNpcId())
			{
			default:
				//_log.warning("__FILE__:__LINE__: " + npc);
			case SevenSigns.PREACHER_NPC_ID:	// 31093 ŖSԎ
				_playerCabal = losingCabal;
				// 4361-1 ŖS̎ - ŖSԎ҂̎􂢁B莞ԁAቺԁB1
				// 4361-2 ŖS̎ - ŖSԎ҂̎􂢁B莞ԁAAAz[hAVbNUɑ΂ϐቺԁB2
				_skillFighter = 4361;
				// 4362-1 ŖS̎ - ŖSԎ҂̎􂢁B莞ԁA@rxቺԁB1
				// 4362-2 ŖS̎ - ŖSԎ҂̎􂢁B莞ԁA@rxAAz[hAVbNUɑ΂ϐቺԁB2
				_skillMage = 4362;
				_autoChatPlayer = PREACHER_AUTOCHAT_PLAYER;
				_autoChatDefault = PREACHER_AUTOCHAT_DEFAULT;
				break;
			case SevenSigns.ORATOR_NPC_ID:	// 31094 [`
				_playerCabal = winningCabal;
				// 4364-1 [̏j - [`҂̏jB莞ԁÂyȂA/oUɑ΂ϐサԁB1
				// 4364-2 [̏j - [`҂̏jB莞ԁÂyȂA/o/z[h/VbN/ჍUɑ΂ϐサԁB2
				_skillFighter = 4364;
				// 4365-1 [̏j - [`҂̏jB莞ԁA_[Wɑ΂閂@LZቺāAz[hA_Uɑ΂ϐサԁB1
				// 4365-2 [̏j - [`҂̏jB莞ԁA_[Wɑ΂閂@LZቺāAz[hA_AVbNAჍUɑ΂ϐサԁB2
				_skillMage = 4365;
				_autoChatPlayer = ORATOR_AUTOCHAT_PLAYER;
				_autoChatDefault = ORATOR_AUTOCHAT_DEFAULT;
				break;
			}
			
			if (_playerCabal != SevenSigns.CABAL_NULL)
				_aiTask = ThreadPoolManager.getInstance().scheduleGeneralWithFixedDelay(this, 3000, 3000);
		}
		
		@Override
		public void run()
		{
			if (!_npc.isVisible())
			{
				_aiTask.cancel(false);
				return;
			}
			if (_npc.getKnownList().getKnownPlayers().size() == 0)
				return;
			
			L2PcInstance target = null;
			
			for (L2PcInstance player : _npc.getKnownList().getKnownPlayers().values())
			{
				if (player == null || player.isInvul())
				{
					continue;
				}
				if (player.isDead() || !player.isVisible() || !_npc.isInsideRadius(player, DISTANCE_TO_WATCH_OBJECT, false, false))
				{
					continue;
				}
				
				final int playerCabal = SevenSigns.getInstance().getPlayerCabal(player.getObjectId());
				
				if (playerCabal == _playerCabal)
				{
					final boolean success = handleCast(player, player.isMageClass() ? _skillMage : _skillFighter);
					
if (com.l2jserver.Config.CabaleBuffer_AI_Chat) {{
					if (success) target = player;
}}
				}
			}
			
if (com.l2jserver.Config.CabaleBuffer_AI_Chat) {{
			if (target != null)
				autoChat(_autoChatPlayer, target);
			else if (Rnd.get(100) < AUTOCHAT_RATE)
				autoChat(_autoChatDefault, null);
}}
		}
		
		/**
		 * For each known player in range, cast either the positive or negative buff. <BR>
		 * The stats affected depend on the player type, either a fighter or a mystic. <BR>
		 * <BR>
		 * Curse of Destruction (Loser)<BR>
		 * - Fighters: -25% Accuracy, -25% Effect Resistance<BR>
		 * - Mystics: -25% Casting Speed, -25% Effect Resistance<BR>
		 * <BR>
		 * <BR>
		 * Blessing of Prophecy (Winner) - Fighters: +25% Max Load, +25% Effect Resistance<BR>
		 * - Mystics: +25% Magic Cancel Resist, +25% Effect Resistance<BR>
		 * @param player 
		 * @param skillId 
		 * @return 
		 */
		private boolean handleCast(L2PcInstance player, int skillId)
		{
		//	if (player.isDead() || !player.isVisible() || !_npc.isInsideRadius(player, DISTANCE_TO_WATCH_OBJECT, false, false))
		//	{
		//		return false;
		//	}
			
			int skillLevel = (player.getLevel() > 40) ? 1 : 2;
			L2Skill skill = SkillTable.getInstance().getInfo(skillId, skillLevel);
			if (player.getFirstEffect(skill) == null)
			{
				skill.getEffects(_npc, player);
				_npc.broadcastPacket(new MagicSkillUse(_npc, player, skill.getId(), skillLevel, skill.getHitTime(), 0));
				SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_FEEL_S1_EFFECT);
				sm.addSkillName(skill);
				player.sendPacket(sm);
				return true;
			}
			
			return false;
		}
		
		private void autoChat(int[] npcStrings, L2PcInstance player)
		{
if (com.l2jserver.Config.CabaleBuffer_AI_Chat) {{
			int npcStringID = npcStrings[Rnd.get(npcStrings.length)];
			NpcSay ns = new NpcSay(_npc.getObjectId(), Say2.ALL, _npc.getNpcId(), npcStringID);
			if (player != null)
				ns.addPcName(player);
			_npc.broadcastPacket(ns, AUTOCHAT_RANGE);
}}
		}
	}
	
	public static void main(String[] args)
	{
		new CabaleBuffer(CabaleBuffer.class.getSimpleName(), "ai/npc");
	}
}
