/***********************************************************************/
/**                                                             **/
/***********************************************************************/

/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.fantasy_isle;

import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.concurrent.ScheduledFuture;

import javolution.util.FastList;
import ai.group_template.L2AttackableAIScript;

import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;

/**
 * Fantasy Isle Parade
 * @author JOJO
 */
public class Parade extends L2AttackableAIScript
{
	private static final boolean DEBUG = true;
	private static final boolean MUSIC = true;
	protected final int[] ACTORS = {
		32381, 32379, 32381,
		32382, 32383, 32384,
		32381, 32385, 32381,
		32384, 32383,32382,
		
		32386,
		32387,
		32388,
		32389,
		32390,
		
		32391,
		32392,
		32393,
		32394,
		32395,
		
		32396,
		32397,
		32398,
		32399,
		32400,
		
		32401,
		32402,
		32403,
		32404,
		
		32405,
		32406,
		32407,
		32408,
		
		32409,
		32411,
		32412,
		32413,
		32414,
		32415,
		
		32416,
		32417,
		32418,
		32419,
		32420,
		
		32421,
		32422,
		32423,
		32429,
		32430,
		
		32447,
		32448,
		32449,
		32450,
		
		32451,
		32452,
		32453,
		32454,
		32455,
		32456,
		
		0,0,0, 32415,
	};
	
	//[gP (270x ks)
	private final L2CharPosition[] START1 = {new L2CharPosition(-54780, -56810, -2015, 49152),new L2CharPosition(-54860, -56810, -2015, 49152),new L2CharPosition(-54940, -56810, -2015, 49152)};
	private final L2CharPosition[] GOAL1  = {new L2CharPosition(-54780, -57965, -2015, 49152),new L2CharPosition(-54860, -57965, -2015, 49152),new L2CharPosition(-54940, -57965, -2015, 49152)};
	//[gQ (180x s)
//	private final L2CharPosition[] START2 = {new L2CharPosition(-55740, -58900, -2015, 32768),new L2CharPosition(-55740, -58820, -2015, 32768),new L2CharPosition(-55740, -58740, -2015, 32768)};//TODO
	private final L2CharPosition[] START2 = {new L2CharPosition(-55715, -58900, -2015, 32768),new L2CharPosition(-55715, -58820, -2015, 32768),new L2CharPosition(-55715, -58740, -2015, 32768)};
	private final L2CharPosition[] GOAL2  = {new L2CharPosition(-60850, -58900, -2015, 32768),new L2CharPosition(-60850, -58820, -2015, 32768),new L2CharPosition(-60850, -58740, -2015, 32768)};
	//[gR (90x s)
	private final L2CharPosition[] START3 = {new L2CharPosition(-61790, -57965, -2015, 16384),new L2CharPosition(-61710, -57965, -2015, 16384),new L2CharPosition(-61630, -57965, -2015, 16384)};
	private final L2CharPosition[] GOAL3  = {new L2CharPosition(-61790, -53890, -2116, 16384),new L2CharPosition(-61710, -53890, -2116, 16384),new L2CharPosition(-61630, -53890, -2116, 16384)};
	//[gS (0x s)
	private final L2CharPosition[] START4 = {new L2CharPosition(-60840, -52990, -2108, 0),new L2CharPosition(-60840, -53070, -2108, 0),new L2CharPosition(-60840, -53150, -2108, 0)};
	private final L2CharPosition[] GOAL4  = {new L2CharPosition(-58620, -52990, -2015, 0),new L2CharPosition(-58620, -53070, -2015, 0),new L2CharPosition(-58620, -53150, -2015, 0)};
	//[gT (315x ks)
	private final L2CharPosition[] START5 = {new L2CharPosition(-57233, -53554, -2015, 57344),new L2CharPosition(-57290, -53610, -2015, 57344),new L2CharPosition(-57346, -53667, -2015, 57344)};
	private final L2CharPosition[] GOAL5  = {new L2CharPosition(-55338, -55435, -2015, 57344),new L2CharPosition(-55395, -55491, -2015, 57344),new L2CharPosition(-55451, -55547, -2015, 57344)};
	
	protected final L2CharPosition[][] START = { START1, START2, START3, START4, START5 };
	protected final L2CharPosition[][] GOAL  = { GOAL1, GOAL2, GOAL3, GOAL4, GOAL5 };
	
	protected ScheduledFuture<?> spawnTask;
	protected ScheduledFuture<?> deleteTask;
	protected ScheduledFuture<?> cleanTask;
	
	protected int npcIndex;
	protected FastList<L2Npc> spawns;
	
	protected void load()
	{
		npcIndex = 0;
		spawns = new FastList<L2Npc>().shared();
	}
	
	protected void clean()
	{
		for (Iterator<L2Npc> it = spawns.iterator(); it.hasNext(); )
		{
			L2Npc actor = it.next();
			actor.deleteMe();
			it.remove();
		}
		spawns = null;
	}
	
	public Parade(int id, String name, String descr)
	{
		super(id, name, descr);
		
		final long diff = timeLeftMilli(8, 0, 0), cycle = 3600000L; // lԂ800JnA6ԂƌJԂ
		if (DEBUG)
		{
			SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm");
			_log.info("Fantasy Isle: Parade script starting at " + format.format(System.currentTimeMillis() + diff) + " and is scheduled each next " + (cycle / 3600000) + " hours.");
		}
		ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new Start(), diff, cycle);
	}
	
	private long timeLeftMilli(int hh, int mm, int ss)
	{
		int now = GameTimeController.getGameTicks() * 60 / 100;
		int dd = (hh * 3600 + mm * 60 + ss) - (now % 86400);
		if (dd < 0)
			dd += 86400;
		
		return dd * 1000L / 6L;
	}
	
	protected class Start implements Runnable
	{
		@Override
		public void run()
		{
			if (DEBUG)
				System.out.println("Fantasy Isle: Parade script start.");
			load();
			spawnTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new Spawn(), 0, 5000);
			deleteTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new Delete(), 10000, 1000);
			cleanTask = ThreadPoolManager.getInstance().scheduleGeneral(new Clean(), 420000);
		}
	}
	
	protected class Spawn implements Runnable
	{
		@Override
		public void run()
		{
			for (int i = 0; i < 3; ++i) {
				if (npcIndex >= ACTORS.length) { spawnTask.cancel(false); return; }
				int npcId = ACTORS[npcIndex++];
				if (npcId == 0) continue;
				for (int route = START.length; --route >= 0;) {
					L2CharPosition start = START[route][i];
					L2CharPosition goal = GOAL[route][i];
					L2Npc actor = addSpawn(npcId, start.x, start.y, start.z, start.heading, false, 0);
					actor.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, goal);
					spawns.add(actor);
					if (MUSIC)
						if (npcIndex == 1) actor.broadcastPacket(new PlaySound("TP05_F"));
				}
			}
		}
	}
	
	protected class Delete implements Runnable
	{
		@Override
		public void run()
		{
			if (spawns.size() > 0)
			{
				for (Iterator<L2Npc> it = spawns.iterator(); it.hasNext(); )
				{
					L2Npc actor = it.next();
					if (actor.getPlanDistanceSq(actor.getXdestination(), actor.getYdestination()) < (100 * 100))
					{
						actor.deleteMe();
						it.remove();
					}
					else if (!actor.isMoving())
					{
						actor.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(actor.getXdestination(), actor.getYdestination(), actor.getZdestination(), actor.getHeading()));
System.out.println("__BASENAME__:__LINE__: "+actor.getNpcId()+" "+actor.getX()+","+actor.getY()+","+actor.getZ()+","+actor.getHeading()+" -> "+actor.getXdestination()+","+actor.getYdestination()+","+actor.getZdestination()+" "+(actor.hasAI() ? actor.getAI().getIntention().name() : "NOAI"));
actor.broadcastPacket(new NpcSay(actor.getObjectId(), 0, actor.getNpcId(), actor.getNpcId()+"/"+actor.getXdestination()+","+actor.getYdestination()+","+actor.getZdestination()));
					}
				}
				if (spawns.size() == 0)
					deleteTask.cancel(false);
			}
		}
	}
	
	protected class Clean implements Runnable
	{
		@Override
		public void run()
		{
			spawnTask.cancel(false);
			deleteTask.cancel(false);
			if (!spawnTask.isDone() || !deleteTask.isDone())
			{
				if (DEBUG)
					System.out.println("Fantasy Isle: Parade try stop.");
				ThreadPoolManager.getInstance().scheduleGeneral(this, 3333);
				return;
			}
			spawnTask = deleteTask = cleanTask = null;
			clean();
			if (DEBUG)
				System.out.println("Fantasy Isle: Parade script done.");
		}
	}
	
	public static void main(String[] args)
	{
		new Parade(-1, "Parade", "fantasy_isle");
	}
}

/**
  F
    Q[Ԃł"24"́AłSԁB܂U{B
    T[oN "6"ɐݒ肳B
    Xe[W͂܂"2030"́AT[oNĂ"1430"Ȃ̂ŁA
    ɊZ(UŊ)QԂQTB

    p[h̓Q[Ԃ
      2:00A8:00A14:00A20:00 ̂PSAUԂƂɂȂB
    Xe[W
      20:30 ̂P̂݁B
*/
