﻿## Active Perl 5.8.8

# L2J_DataPack language tool for Japanese.
# part 3 - *.htm、*.py 中の基本単語を強引に日本語化する.

# "*.ja" や "!build_ja.cgi" に漏れたものの処理。
# 全ファイルを舐め回す、かなり重たい処理なので、できるだけ減らそう。

use utf8;
use warnings;
use strict;
use Encode;

binmode STDOUT,':encoding(cp932)'; $|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $DEBUG = 0; # 1 or 0
my @CC;

my $LogFile = UTF8(__FILE__);
   $LogFile =~ s!\.[^.\/\\]*$!.log!;
open LOG, '>:utf8', FS($LogFile) or die "'$LogFile' $!";

my $ERROR_HEADER;

$SIG{__WARN__} = sub {
	print STDERR $ERROR_HEADER,' ' if $ERROR_HEADER;
	foreach my $m (@_) {
		my $a = $m;
		$a =~ s!build[/\\]dist[/\\]game[/\\](data[/\\])!$1!;
		$a =~ s!build[/\\]dist[/\\]!!;
		if ($a =~ m/^Malformed UTF-8 character \(/) {
			print STDERR $a;
			exit 1;
		}
		print STDERR $a;
		print LOG    $a;
	}
};

$SIG{__DIE__} = sub {
	print STDERR $ERROR_HEADER,' ' if $ERROR_HEADER;
	foreach my $m (@_) {
		my $a = $m;
		$a =~ s!build[/\\]dist[/\\]game[/\\](data[/\\])!$1!;
		$a =~ s!build[/\\]dist[/\\]!!;
		print STDERR $a;
	}
	exit 1;
};

&start('build/dist/');

print LOG "\n";
for (my $i=0; $i <= $#CC; ++$i) {
	if (exists $CC[$i]) {print LOG __FILE__,"($i)\t",$CC[$i],"\n"}
}

close LOG;
exit 0;

sub start {
	my ($subDir) = @_;

	print ' [',$subDir,"]\n";
	opendir DIR, FS($subDir) or die "'$subDir' $!";
	my @files = readdir DIR; $_ = UTF8($_) foreach (@files);
	closedir DIR;

	foreach my $fileName (@files) {
		next if $fileName =~ m/^\./;
		next if $fileName =~ m/ /;
		my $filePath = $subDir.$fileName;
		my $outPath = $filePath;
		   $outPath .= '.text' if $DEBUG;

		if (-d FS($filePath)) {
			$filePath =~ s!^\.\/!!;
			&start($filePath.'/');
			next;
		}

		my ($ext, $encode);
		if    ($fileName =~ /\.html?$/) {$ext = 'htm'; $encode = ':utf8'}
		elsif ($fileName =~ /\.py$/ )   {$ext = 'py' ; $encode = ':encoding(cp932)'}
		else {next}

		print "  $filePath\n" if $DEBUG;
		open FILE, '<'.$encode, FS($filePath) or die "'$filePath' $!";
		read FILE,my $text,-s FILE;
		my $mtime = (stat FILE)[9];
		close FILE;

		my $original = $text;
		$_           = $text;
		$ERROR_HEADER = "'$filePath'";
#
## .py 用 ##
if ($ext eq 'py') {
s/\bQuest for characters level ([0-9]*) and above\b/レベル$1以上のキャラクターのみ遂行できるクエストです。/gsi;	#[4]
s/\bQuest for characters level ([0-9]*) or above\b/レベル$1以上のキャラクターのみ遂行できるクエストです。/gsi;	#[2]
s/\bQuest for characters level ([0-9]*) above\b/レベル$1以上のキャラクターのみ遂行できるクエストです。/gsi;	#[1]

# 余分な句読点を除去
s/。\.+/。/g;	#2009.09.30	#[8]
# 全角文字の後の"."を"。"に #
s/([\x{3000}-\x{EFFF}])\./$1。/g;	#2007.10.01
}

## .htm 用 ##
if ($ext eq 'htm') {

# <a ation="***">～</a>系 #

s!</A>!</a>!g;				#[23]
s!(<a [^>]+?>)[\r\n]+!$1!gs;	#[33]
s![\r\n]+(?=</a>)!!gs;	#[37]

s!(?<=[\x{0100}-\x{FFFF}])[\r\n]+(?=[\x{0100}-\x{FFFF}])!!gs;	#[47]
s!(?<=[\x{0100}-\x{FFFF}])[\r\n]+(?=[^<])!!gs;					#[22]

s!(?<=<a action="bypass -h npc_%objectId%_TerritoryStatus">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!領主、税率情報を見る!s;	#[28]
s!(?<=<a action="bypass -h npc_%objectId%_Link common/crafting_01.htm">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!アイテムを製作する!s;	#[4]
s!(?<=<a action="bypass -h npc_%objectId%_Link common/duals_01.htm">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!二刀流を製作する!s;	#[4]

s!(?<=<a action="bypass -h npc_%objectId%_Chat 0">)[^a-z<]*go back[^a-z<]*(?=<)!戻る!si;	#[4]
s!(?<=<a action="bypass -h npc_%objectId%_Chat 0">)[^a-z<]*back[^a-z<]*(?=<)!戻る!si;	#[30]
s!(?<=<a action="bypass -h npc_%objectId%_Chat 0">)[^a-z<]*return[^a-z<]*(?=<)!戻る!si;	#[12]

# ボタン #

s!<button value="Main"!<button value="メイン"!g;		#[218]
s!<button value="Back"!<button value="戻る"!g;		#[216]
s!<button value="Return"!<button value="戻る"!g;		#[2]
s!<button value="Go Back"!<button value="戻る"!g;	#[3]
s!<button value="Cancel"!<button value="ｷｬﾝｾﾙ"!;		#[8]
s!<button value="Yes"!<button value="はい"!;			#[2]
s!<button value="No"!<button value="いいえ"!;		#[2]
s!<button value="Close"!<button value="閉じる"!;		#[7]
s!<button value="Submit"!<button value="送信"!;		#[1]
print LOG "[".__LINE__."]'$filePath'" if s!<button value="Enter"!<button value="確定"!;	#〓〓 "OK" の方がよさそう...	#[7]

s!(<button value="ｷｬﾝｾﾙ" .*?) width=\d+!$1 width=50!;	#〓〓仮	#[18]
s!(<button[^>]*? height)=1\d\b!$1=20!g;	#〓〓仮					#[149]

# 頻出文・基本単語 #

s/\(Quest for characters level ([0-9]*) and above\.?\)/(レベル$1以上のキャラクターのみ遂行できるクエストです。)/i;	#[29]
s/\(Quest for characters level ([0-9]*) or above\.?\)/(レベル$1以上のキャラクターのみ遂行できるクエストです。)/i;	#[2]

s/(?<=[>"])Say you will take the task\.?(?=["<])/手伝うと言う/si;	#[5]
s/(?<=[>"])I will help you\.?(?=["<])/手伝うと言う/si;				#[7]
s/(?<=[>"])I will help\.?(?=["<])/手伝うと言う/si;					#[3]

s!(?<=>)Back\.?(?=</a>)!戻る!gi;	#[50]
s!(?<=>)Quit\.?(?=</a>)!閉じる!gi;	#[21]
s!(?<=>)Quest\.?(?=</a>)!クエスト!gi;	#[140]
s!(?<=>)Return\.?(?=</a>)!戻る!gi;	#[466]

s!(?<=>)Buy\.?(?=</a>)!買う!gi;	#[3]
s!(?<=>)Teleport\.?(?=</a>)!テレポートする!gi;	#[36]

# 全角文字の前の"The"を消す。 #
s/\bThe ([\x{3000}-\x{EFFF}])/$1/gsi;	#[60]

} # htm用
#
		$ERROR_HEADER = undef;
		$text = $_;
		next if $text eq $original;

		open FILE, '>'.$encode, FS($outPath) or die "'$outPath' $!";
		print FILE $text;
		close FILE;
		utime $mtime, $mtime, FS($outPath);

		my $i = &minidiff($text, $original);
		print  '+',$outPath,"($i)\n";
		print LOG  $outPath,"($i)\n";
	}
}

sub minidiff {
	my ($textA, $textB) = @_;

	$textA =~ s/^\x{FEFF}//;
	$textB =~ s/^\x{FEFF}//;
	my @A = split /\n/,$textA;
	my @B = split /\n/,$textB;
	my $min = $#A <= $#B ? $#A : $#B;
	for (my $i=0; $i <=$min; ++$i) {
		return $i+1 if $A[$i] ne $B[$i];
	}
	return 0;
}
