﻿<?php
/**
 * Character panel file
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @version $Id: CharacterProfile.php 18 2005-05-30 12:34:21Z madest $
 * @package AccountManager
 * @filesource 
 */

/**
 * Access changing panel
 */ 
require_once('classes/modules/CharacterAccess.php');

/**
 * Character info panel
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @version $Id: CharacterProfile.php 18 2005-05-30 12:34:21Z madest $
 * @package AccountManager
 */
class CharacterProfile extends Module
{
	/**
	 * @var string - module output, usually HTML content
	 */
	var $output;

	/**
	 * Constructor loads template and starts content creation
	 */	
	function CharacterProfile()
	{
		$this->Module();
		
		if(isset($_SESSION['acObj']))
		{
		// Default user character panel
			if($this->config->user['view_character']==true || $this->active_user->is_admin() == true)
			{
				$this->template = temp_load($this->config->manager['template_path'].'character_profile.htm');
				$access_panel = "";
				
				if(isset($_GET['do']))
				{				
					switch ($_GET['do']) {					
						// Access module output (Form)
						case "access":
							if($this->active_user->is_admin() == true)
							{
								if(isset($_GET['id']))
								{
									$accessForm = new CharacterAccess($_GET['id']);
									$access_panel = $accessForm->output;
								}
							} else {								
								$access_panel = $access_panel."<font color=red>管理者権限に変更できません</font>";
							}
							break;
						default:
							break;
					}
				}
				$this->characterPanel();
				$this->template =$this->template.$access_panel;
				$this->output = $this->template;
				
			} else {
				$this->output = "<font color=red>ログインしてください！</font>";
			}
		} else {
			$this->output = "<font color=red>ログインしてください！</font>";
		}
	}
	
	/**
	 * Fills character panel with values
	 */
	function characterPanel()
	{
		if(isset($_GET['id']))
		{
			if(is_numeric($_GET['id']))
			{
				$character = new character($_GET['id']);
				if($character->get()== true)
				{
					$r['charId'] = $character->charId;
					$r['account_name'] = $character->account_name;
					$r['char_name'] = $character->char_name;
					$r['class'] = $character->class;
					$r['level'] = $character->level;
					$r['curHp'] = round($character->curHp);
					$r['maxHp'] = $character->maxHp;
					$r['curMp'] = round($character->curMp);
					$r['maxMp'] = $character->maxMp;
					$r['pAtk'] = $character->pAtk;
					$r['mAtk'] = $character->mAtk;
					$r['pDef'] = $character->pDef;
					$r['mDef'] = $character->mDef;
					$r['acc'] = $character->acc;
					$r['crit'] = $character->crit;
					$r['pSpd'] = $character->pSpd;
					$r['mSpd'] = $character->mSpd;
					$r['accesslevel'] = $character->accesslevel;
					
					if($character->online == 1)
					{
						$r['online_status'] = "<font color='green'>オンライン</font>";
					} else {
						$r['online_status'] = "<font color='red'>オフライン</font>";
					}
					
					$this->template = temp_subs($this->template, "char", $r);
				} else {
					$this->template = "<font color=red>キャラクターはいません。</font>";
				}
			} else {
				$this->template = "<font color=red>キャラクターはいません。</font>";
			}
		} else {
			$this->template = "<font color=red>キャラクターはいません。</font>";
		}
	}
}
?>