use utf8;
use strict;
use warnings;

my $PACKAGE = 'jp.sf.l2j.arrayMaps';

&ToIntBoolean('Sorted_K__V_ArrayMap.template');
&ToIntByte('Sorted_K__V_ArrayMap.template');
&ToIntShort('Sorted_K__V_ArrayMap.template');
&ToIntChar('Sorted_K__V_ArrayMap.template');
&ToIntInt('Sorted_K__V_ArrayMap.template');
&ToIntLong('Sorted_K__V_ArrayMap.template');
&ToIntFloat('Sorted_K__V_ArrayMap.template');
&ToIntDouble('Sorted_K__V_ArrayMap.template');
&ToIntObject('Sorted_K_ObjectArrayMap.template');
&ToIntObject('Sorted_K_ArrayListMap.template');

&ToLongBoolean('Sorted_K__V_ArrayMap.template');
&ToLongByte('Sorted_K__V_ArrayMap.template');
&ToLongShort('Sorted_K__V_ArrayMap.template');
&ToLongChar('Sorted_K__V_ArrayMap.template');
&ToLongInt('Sorted_K__V_ArrayMap.template');
&ToLongLong('Sorted_K__V_ArrayMap.template');
&ToLongFloat('Sorted_K__V_ArrayMap.template');
&ToLongDouble('Sorted_K__V_ArrayMap.template');
&ToLongObject('Sorted_K_ObjectArrayMap.template');
&ToLongObject('Sorted_K_ArrayListMap.template');


#&ToLongInt('Sorted_K__V_ArrayMap.template');
#&ToLongLong('Sorted_K__V_ArrayMap.template');
#&ToLongObject('Sorted_K_ObjectArrayMap.template');
#&ToLongObject('Sorted_K_ArrayListMap.template');

exit;

sub ToIntBoolean()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_K_/Int/;
	$output =~ s/_V_/Boolean/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#k#/int/g;
	s/#KT#/Integer/g;
	s/#K#/Int/g;
	s/#KC#/INT/g;

	s/#v#/boolean/g;
	s/#VT#/Boolean/g;
	s/#V#/Boolean/g;
	s/#VC#/BOOLEAN/g;
	s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToIntByte()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_K_/Int/;
	$output =~ s/_V_/Byte/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#k#/int/g;
	s/#KT#/Integer/g;
	s/#K#/Int/g;
	s/#KC#/INT/g;

	s/#v#/byte/g;
	s/#VT#/Byte/g;
	s/#V#/Byte/g;
	s/#VC#/BYTE/g;
	s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToIntShort()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_K_/Int/;
	$output =~ s/_V_/Short/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#k#/int/g;
	s/#KT#/Integer/g;
	s/#K#/Int/g;
	s/#KC#/INT/g;

	s/#v#/short/g;
	s/#VT#/Short/g;
	s/#V#/Short/g;
	s/#VC#/SHORT/g;
	s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToIntChar()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_K_/Int/;
	$output =~ s/_V_/Char/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#k#/int/g;
	s/#KT#/Integer/g;
	s/#K#/Int/g;
	s/#KC#/INT/g;

	s/#v#/char/g;
	s/#VT#/Character/g;
	s/#V#/Char/g;
	s/#VC#/CHAR/g;
	s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToIntInt()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_K_/Int/;
	$output =~ s/_V_/Int/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#k#/int/g;
	s/#KT#/Integer/g;
	s/#K#/Int/g;
	s/#KC#/INT/g;

	s/#v#/int/g;
	s/#VT#/Integer/g;
	s/#V#/Int/g;
	s/#VC#/INT/g;
	s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToIntLong()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_K_/Int/;
	$output =~ s/_V_/Long/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#k#/int/g;
	s/#KT#/Integer/g;
	s/#K#/Int/g;
	s/#KC#/INT/g;

	s/#v#/long/g;
	s/#VT#/Long/g;
	s/#V#/Long/g;
	s/#VC#/LONG/g;
	s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToIntFloat()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_K_/Int/;
	$output =~ s/_V_/Float/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#k#/int/g;
	s/#KT#/Integer/g;
	s/#K#/Int/g;
	s/#KC#/INT/g;

	s/#v#/float/g;
	s/#VT#/Float/g;
	s/#V#/Float/g;
	s/#VC#/FLOAT/g;
	s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToIntDouble()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_K_/Int/;
	$output =~ s/_V_/Double/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#k#/int/g;
	s/#KT#/Integer/g;
	s/#K#/Int/g;
	s/#KC#/INT/g;

	s/#v#/double/g;
	s/#VT#/Double/g;
	s/#V#/Double/g;
	s/#VC#/DOUBLE/g;
	s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToLongBoolean()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_K_/Long/;
	$output =~ s/_V_/Boolean/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#k#/long/g;
	s/#KT#/Long/g;
	s/#K#/Long/g;
	s/#KC#/LONG/g;

	s/#v#/boolean/g;
	s/#VT#/Boolean/g;
	s/#V#/Boolean/g;
	s/#VC#/BOOLEAN/g;
	s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToLongByte()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_K_/Long/;
	$output =~ s/_V_/Byte/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#k#/long/g;
	s/#KT#/Long/g;
	s/#K#/Long/g;
	s/#KC#/LONG/g;

	s/#v#/byte/g;
	s/#VT#/Byte/g;
	s/#V#/Byte/g;
	s/#VC#/BYTE/g;
	s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToLongShort()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_K_/Long/;
	$output =~ s/_V_/Short/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#k#/long/g;
	s/#KT#/Long/g;
	s/#K#/Long/g;
	s/#KC#/LONG/g;

	s/#v#/short/g;
	s/#VT#/Short/g;
	s/#V#/Short/g;
	s/#VC#/SHORT/g;
	s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToLongChar()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_K_/Long/;
	$output =~ s/_V_/Char/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#k#/long/g;
	s/#KT#/Long/g;
	s/#K#/Long/g;
	s/#KC#/LONG/g;

	s/#v#/char/g;
	s/#VT#/Character/g;
	s/#V#/Char/g;
	s/#VC#/CHAR/g;
	s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToLongInt()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_K_/Long/;
	$output =~ s/_V_/Int/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#k#/long/g;
	s/#KT#/Long/g;
	s/#K#/Long/g;
	s/#KC#/LONG/g;

	s/#v#/int/g;
	s/#VT#/Integer/g;
	s/#V#/Int/g;
	s/#VC#/INT/g;
	s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToLongLong()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_K_/Long/;
	$output =~ s/_V_/Long/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#k#/long/g;
	s/#KT#/Long/g;
	s/#K#/Long/g;
	s/#KC#/LONG/g;

	s/#v#/long/g;
	s/#VT#/Long/g;
	s/#V#/Long/g;
	s/#VC#/LONG/g;
	s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToLongFloat()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_K_/Long/;
	$output =~ s/_V_/Float/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#k#/long/g;
	s/#KT#/Long/g;
	s/#K#/Long/g;
	s/#KC#/LONG/g;

	s/#v#/float/g;
	s/#VT#/Float/g;
	s/#V#/Float/g;
	s/#VC#/FLOAT/g;
	s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToLongDouble()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_K_/Long/;
	$output =~ s/_V_/Double/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#k#/long/g;
	s/#KT#/Long/g;
	s/#K#/Long/g;
	s/#KC#/LONG/g;

	s/#v#/double/g;
	s/#VT#/Double/g;
	s/#V#/Double/g;
	s/#VC#/DOUBLE/g;
	s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToIntObject()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_K_/Int/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#k#/int/g;
	s/#KT#/Integer/g;
	s/#K#/Int/g;
	s/#KC#/INT/g;

	s/#v#/V/g;
	s/#VT#/V/g;
	s/#V#/Object/g;
	s/#NULL#/null/g;

	writeAll($output, $_);
}

sub ToLongObject()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_K_/Long/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#k#/long/g;
	s/#KT#/Long/g;
	s/#K#/Long/g;
	s/#KC#/LONG/g;

	s/#v#/V/g;
	s/#VT#/V/g;
	s/#V#/Object/g;
	s/#NULL#/null/g;

	writeAll($output, $_);
}

sub readAll()
{
	my ($path) = @_;
	open FILE, '<', $path;
	binmode FILE;
	read FILE, my $text, -s FILE;
	close FILE;
	return $text;
}

sub writeAll()
{
	my ($path, $text) = @_;
	open FILE, '>', $path;
	binmode FILE;
	print FILE $text;
	close FILE
}
