/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.l2jserver.gameserver.network.serverpackets;

import java.util.ArrayList;
import java.util.List;

import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.NpcStringId;

/**
 * @author Kerberos
 */
public final class NpcSay extends L2GameServerPacket
{
	private final int _objectId;
	private final int _textType;
	private final int _npcId;
	private String _text;
	private final int _npcString;
	private List<String> _parameters;
	
	/**
	 * @param objectId
	 * @param messageType
	 * @param npcId
	 * @param text
	 */
	public NpcSay(int objectId, int messageType, int npcId, String text)
	{
		_objectId = objectId;
		_textType = messageType;
		_npcId = 1000000 + npcId;
		_npcString = -1;
		_text = text;
	}
	
	public NpcSay(int objectId, int messageType, int npcId, int npcString)
	{
		_objectId = objectId;
		_textType = messageType;
		_npcId = 1000000 + npcId;
		_npcString = npcString;	//client side npcstring-*.dat
	}
	
	public NpcSay(int objectId, int messageType, int npcId, NpcStringId npcString)
	{
		this(objectId, messageType, npcId, npcString.getId());
	}
	
	/**
	 * @param text - parameter for argument S1,S2 etc of an npcstring
	 * @return this NpcSay packet object
	 */
	public NpcSay addStringParameter(String text)
	{
		if (_parameters == null)
		{
			_parameters = new ArrayList<>();
		}
		_parameters.add(text);
		return this;
	}
	//[JOJO]-------------------------------------------------
	public NpcSay addString(String text)
	{
		return addStringParameter(text);
	}
	public NpcSay addPcName(L2PcInstance pc)
	{
		return addStringParameter(pc.getName());
	}
	public NpcSay addNpcName(L2Npc npc)
	{
		return addStringParameter(npc.getName());
	}
	public NpcSay addNumber(int number)
	{
		return addStringParameter(String.valueOf(number));
	}
	//-------------------------------------------------------
	
	@Override
	protected final void writeImpl()
	{
		writeC(0x30);
		writeD(_objectId);
		writeD(_textType);
		writeD(_npcId);
		writeD(_npcString);
		if (_npcString == -1)
		{
			writeS(_text);
		}
		else if (_parameters != null)
		{
			for (String s : _parameters)
			{
				writeS(s);
			}
		}
	}
}