/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.individual;

import javolution.util.FastSet;
import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.instancemanager.WalkingManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.clientpackets.Say2;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.util.Rnd;

/**
 * Knoriks AI.
 * @author UnAfraid
 */
public class Knoriks extends AbstractNpcAI
{
	private static final int KNORIKS_ID = 22857;
	private static final int[] ROUTE_ID =
	{
		30,
		31,
		32,
		33,
		34,
		35
	};
	private long CAN_TALK = 0;
	
	private Knoriks(String name, String descr)
	{
		super(name, descr);
		addSpawnId(KNORIKS_ID);
		addAggroRangeEnterId(KNORIKS_ID);
		
if (!com.l2jserver.Config.FIX_onSpawn_for_SpawnTable) {{
		FastSet<L2Spawn> spawns = SpawnTable.getInstance().getSpawnTable();
		for (L2Spawn spawn : spawns)
		{
			if (spawn.getNpcid() == KNORIKS_ID)
			{
				onSpawn(spawn.getLastSpawn());
			}
		}
}}
	}
	
	@Override
	public String onSpawn(L2Npc npc)
	{
		for (int element : ROUTE_ID)
		{
			WalkingManager.getInstance().startMoving(npc, element);
			if ((CAN_TALK & npc.getObjectId()) < 1)
			{
				CAN_TALK |= npc.getObjectId();
			}
		}
		
		return super.onSpawn(npc);
	}
	
	@Override
	public String onAggroRangeEnter(L2Npc npc, L2PcInstance player, boolean isPet)
	{
		if (((CAN_TALK & npc.getObjectId()) > 0) && (Rnd.get(100) < 60))
		{
			if (Rnd.get(100) < 50)
			{
				CAN_TALK &= ~npc.getObjectId();
			}
			npc.broadcastPacket(new NpcSay(npc.getObjectId(), Say2.SHOUT, npc.getNpcId(), NpcStringId.WHOS_THERE_IF_YOU_DISTURB_THE_TEMPER_OF_THE_GREAT_LAND_DRAGON_ANTHARAS_I_WILL_NEVER_FORGIVE_YOU), 1000);
		}
		
		return super.onAggroRangeEnter(npc, player, isPet);
	}
	
	public static void main(String[] args)
	{
		new Knoriks(Knoriks.class.getSimpleName(), "ai");
	}
}
