/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.individual;

import javolution.lang.MathLib;
import ai.npc.AbstractNpcAI;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;

public class FleeNpc extends AbstractNpcAI
{
	private static final int[] MOBS =
	{
		20432,
		22228,
		18150,
		18151,
		18152,
		18153,
		18154,
		18155,
		18156,
		18157
	};
	
	private FleeNpc(String name, String descr)
	{
		super(name, descr);
		addAttackId(MOBS);
		addSkillSeeId(MOBS);
		
		// Disable L2AttackableAIScript.
		Quest attackableAIScript = QuestManager.getInstance().getQuest("L2AttackableAIScript");
		for (int npcId : MOBS)
		{
			L2NpcTemplate t = NpcTable.getInstance().getTemplate(npcId);
			if (t.getBasePAtk() == 0 && t.getBaseMAtk() == 0)
				t.removeQuest(attackableAIScript);
			else
				_log.warning("FleeNpc: WARNING npc " + t.getName() + " must be UPDATE npc SET patk=0,matk=0 WHERE id=" + t.getNpcId());
		}
		if (!Config.FIX_FleeNpc)
			_log.warning("FleeNpc: WARNING Config.FIX_FleeNpc must be true.");
	}
	
	@Override
	public String onSkillSee(L2Npc npc, L2PcInstance caster, L2Skill skill, L2Object[] targets, boolean isPet)
	{
		return Util.contains(targets, npc)
			? onAttack(npc, caster, 0, isPet)
			: super.onSkillSee(npc, caster, skill, targets, isPet);
	}
	
	@Override
	public String onAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isPet)
	{
		L2Attackable mob = (L2Attackable) npc;
		if (mob.isMovementDisabled())
		{
			return null;
		}
		if (mob.getAI().getIntention() == CtrlIntention.AI_INTENTION_MOVE_TO && !(npc.getXdestination() == npc.getSpawn().getLocx() && npc.getYdestination() == npc.getSpawn().getLocy()))
		{
			return null;
		}
		
		int npcId = npc.getNpcId();
		if (npcId >= 18150 && npcId <= 18157)	// Victim
		{
			flee(npc, attacker, 30, 50);
			return null;
		}
		else if (npcId == 20432 || npcId == 22228)	// Elpy
		{
			flee(npc, attacker, 100, 300);
			return null;
		}
		return super.onAttack(npc, attacker, damage, isPet);
	}
	
	private void flee(L2Npc npc, L2PcInstance attacker, int min, int max)
	{
		double r = Rnd.get(min, max);
		double a = Math.atan2(npc.getY() - attacker.getY(), npc.getX() - attacker.getX());
		int x = npc.getX() + (int) Math.round(r * Math.cos(a));
		int y = npc.getY() + (int) Math.round(r * Math.sin(a));
		int z = npc.getZ();
		int h = (int) Math.round(a * 65536 / MathLib.TWO_PI);
		if (Config.GEODATA > 0)
		{
			Location destiny = GeoData.getInstance().moveCheck(npc.getX(), npc.getY(), npc.getZ(), x, y, z, npc.getInstanceId());
			x = destiny.getX();
			y = destiny.getY();
			z = destiny.getZ();
		}
		npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(x, y, z, h));
	}
	
	// Register the new Script at the Script System
	public static void main(String[] args)
	{
		new FleeNpc(FleeNpc.class.getSimpleName(), "ai");
	}
}
