//
// PT3Core.h
//

#ifndef __RY0_DEVICE_PT3_PT3CORE_H__
#define __RY0_DEVICE_PT3_PT3CORE_H__

#include <stdint.h>
#include <windows.h>
#include <process.h>
#include "EARTH_PT3.h"
#include "ry0/device/Tuner.h"

namespace ry0
{
namespace device
{
namespace PT3
{

class PT3Tuner;

class PT3Core
{
    friend class PT3Tuner;

public:

    static const int MAX_TUNERS                         = 4;
    static const int PAGE_SIZE                          = 4096;
    static const int PAGE_COUNT                         = 47;
    static const int PACKET_SIZE                        = 188;
    static const int VIRTUAL_SIZE                       = 4;
    static const int VIRTUAL_COUNT                      = 16;
    static const int LOCK_SIZE                          = 4;
    static const int BUFFER_PAGE_COUNT                  = 511;
    static const int BLOCK_COUNT                        = 2;
    static const int BLOCK_SIZE                         = (PAGE_SIZE * BUFFER_PAGE_COUNT / BLOCK_COUNT);


private:
    CRITICAL_SECTION    _cs;
    EARTH::PT::Device * _device;
    char                _name[64];

    PT3Tuner *          _tuners[MAX_TUNERS];
    bool                _locked[MAX_TUNERS];

    //
    PT3Core(EARTH::PT::Bus *bus, const EARTH::PT::Bus::DeviceInfo *deviceInfo, Tuner *tuners[4], HMODULE multi2_dll);
    ~PT3Core();

    void release(Tuner *tuner);

public:
    EARTH::status setTransferTestMode(Tuner::Type type, uint32_t tuner);
    EARTH::status setTransferPageDescriptorAddress(Tuner::Type type, uint32_t tuner, EARTH::uint64 pageAddress);
    EARTH::status setTransferEnabled(Tuner::Type type, uint32_t tuner, bool enabled);
    bool getCnAgc(EARTH::uint32 tuner, EARTH::uint32 *cn100, EARTH::uint32 *agc, EARTH::uint32 *maxAgc);
    bool setChannel(EARTH::uint32 tuner, int channel);

    const char *name();
};

} // PT3
} // device
} // ry0

#endif // __RY0_DEVICE_PT3_PT3CORE_H__
