// ========================================================================================
//	EARTH_PT.h
//	version 2.0 (2009.09.30)
// ========================================================================================

#ifndef _EARTH_PT_H
#define _EARTH_PT_H

#include "Prefix.h"

namespace EARTH {
namespace PT {
	class Device;
	class Device2;

	// +------------+
	// | oXNX |
	// +------------+
	// oX̃foCX񋓂܂B܂foCXCX^X𐶐܂B
	class Bus {
	public:
		// [@\] Bus CX^X𐶐
		// [] hCo  "windrvr6_EARTHSOFT_PT2", "windrvr6_EARTHSOFT_PT1" ̏Ɏs܂B
		// [Ԓl] STATUS_INVALID_PARAM_ERROR   bus  NULL
		//        STATUS_WDAPI_LOAD_ERROR     LoadLibrary(TEXT("wdapi1002.dll")) ̕Ԓl NULL
		//        STATUS_WD_DriverName_ERROR  WD_DriverName() ̕Ԓl NULL
		//        STATUS_WD_Open_ERROR        WD_Open() ŃG[
		//        STATUS_WD_Version_ERROR     WD_Version() ŃG[B܂̓o[W 10.0.2 łȂ
		//        STATUS_WD_License_ERROR     WD_License() ŃG[
		typedef status (*NewBusFunction)(Bus **bus);

		// [@\] CX^X
		// [] delete ͎g܂B̊֐ĂяoĂB
		// [Ԓl] STATUS_ALL_DEVICES_MUST_BE_DELETED_ERROR  NewDevice() ŐꂽfoCXS Delete() ĂȂ
		virtual status Delete() = 0;

		// [@\] \tgEFAo[W擾
		// [] o[W 2.0 ̏ꍇAl 0x200 ɂȂ܂B
		//         24 rbgł΃oCi݊ɂȂ悤ɓw߂܂̂ŁA
		//        ((version >> 8) == 2) ł邩`FbNĂB 
		// [Ԓl] STATUS_INVALID_PARAM_ERROR   version  NULL
		virtual status GetVersion(uint *version) const = 0;

		// foCX
		struct DeviceInfo {
			uint Bus;			// PCI oXԍ
			uint Slot;			// PCI foCXԍ
			uint Function;		// PCI t@NVԍ (퓮쎞͕K 0 ɂȂ܂)
			uint PTn;			// i (PT1:1 PT2:2)
			uint BadBitCount;	// PCI f[^oX̃rbg
		};

		// [@\] FĂfoCX̃Xg擾
		// [] PCI oXXLĈȉ̏SĖfoCXXgAbv܂B
		//        (PT1) x_ID: 0x10ee / foCXID: 0x211a / TuVXex_ID: ~0x10ee / TuVXeID: ~0x211a
		//        (PT2) x_ID: 0x10ee / foCXID: 0x222a / TuVXex_ID: ~0x10ee / TuVXeID: ~0x222a
		//        
		//        Xbgƃ{[h[q̐ڐGꍇA ID Ƀrbg邱Ƃ܂B
		//        ̂悤ȏ󋵂łfoCXoł悤ɁAmaxBadBitCount Ńrbg̋ew肷邱Ƃł܂B
		//        64rbg(16rbg~4) ̊erbgrArbg maxBadBitCount ȉ̃foCXXgAbv܂B
		//        
		//        deviceInfoCount ͌ĂяoOɃfoCX̏w肵܂Bďo͌foCXԂ܂B
		//        maxBadBitCount  3 ȉ̒lw肵܂B
		//        DeviceInfo::BadBitCount  0 łȂfoCX Device::Open() 邱Ƃ͂ł܂B
		// [Ԓl] STATUS_INVALID_PARAM_ERROR     deviceInfoPtr, deviceInfoCount ̂ꂩ NULL
		//                                        ܂͈ maxBadBitCount  3 傫
		//        STATUS_WD_PciScanCards_ERROR  WD_PciScanCards ŃG[
		virtual status Scan(DeviceInfo *deviceInfoPtr, uint *deviceInfoCount, uint maxBadBitCount = 0) = 0;

		// [@\] foCXCX^X𐶐
		// [] foCX\[X̔r`FbN͂̊֐ł͍s܂BDevice::Open() ōs܂B
		//        Device2 ͔JC^[tF[XłBdevice2  NULL ɂĂB
		// [Ԓl] STATUS_INVALID_PARAM_ERROR   deviceInfoPtr, device ̂ꂩ NULL
		//                                      ܂͈ device2  NULL łȂ
		virtual status NewDevice(const DeviceInfo *deviceInfoPtr, Device **device, Device2 **device2 = NULL) = 0;

	protected:
		virtual ~Bus() {}
	};

	// +----------------+
	// | foCXNX |
	// +----------------+
	// ̃CX^X 1 {[h 1 ɑΉĂ܂B
	class Device {
	public:
		// ----
		// 
		// ----

		// [@\] CX^X
		// [] delete ͎g܂B̊֐ĂяoĂB
		// [Ԓl] STATUS_DEVICE_MUST_BE_CLOSED_ERROR  foCXI[vԂȂ̂ŃCX^XłȂ
		virtual status Delete() = 0;
		
		// ------------------
		// I[vEN[Y
		// ------------------

		// [@\] foCX̃I[v
		// [] ȉ̎菇ɉčs܂B
		//        1. ɃfoCXI[vĂȂmFB
		//        2. rWID (RtBM[V AhX 0x08)  0x01 ł邩𒲂ׂB
		//        3. RtBM[VԂ̃foCXŗLWX^̈g PCI oXł̃rbgȂmFB
		//        4.  SDK Ő䂪\ FPGA H̃o[Wł邩mFB
		// [Ԓl] STATUS_DEVICE_IS_ALREADY_OPEN_ERROR    foCX͊ɃI[vĂ
		//        STATUS_WD_PciGetCardInfo_ERROR         WD_PciGetCardInfo() ŃG[
		//        STATUS_WD_PciGetCardInfo_Bus_ERROR     oX񐔂 1 ȊO
		//        STATUS_WD_PciGetCardInfo_Memory_ERROR  񐔂 1 ȊO
		//        STATUS_WD_CardRegister_ERROR           WD_CardRegister() ŃG[
		//        STATUS_WD_PciConfigDump_ERROR          WD_PciConfigDump() ŃG[
		//        STATUS_CONFIG_REVISION_ERROR           rWID  0x01 łȂ
		//        STATUS_PCI_BUS_ERROR                   PCI oXł̃rbg
		//        STATUS_PCI_BASE_ADDRESS_ERROR          RtBM[VԂ BaseAddress0  0
		//        STATUS_FPGA_VERSION_ERROR              ΉĂȂ FPGA Ho[W
		//        STATUS_WD_CardCleanupSetup_ERROR       WD_CardCleanupSetup() ŃG[
		//        STATUS_DCM_LOCK_TIMEOUT_ERROR          DCM 莞ԌoߌbNԂɂȂȂ
		//        STATUS_DCM_SHIFT_TIMEOUT_ERROR         DCM ̃tF[YVtg莞ԌoߌȂ
		virtual status Open() = 0;

		// [@\] foCX̃N[Y
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		virtual status Close() = 0;

		// --------------------------------------
		// PCI NbNJE^ECeV^C}
		// --------------------------------------

		// [@\] PCI NbNJE^擾
		// [] JE^ 32 rbgłB0xffffffff ̎ 0 ɂȂ܂B
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        counter  NULL
		virtual status GetPciClockCounter(uint *counter) = 0;

		// [@\] PCI CeV^C}l̐ݒE擾
		// []  3 rbg͎ĂȂ߁A擾l 8 ̔{ɂȂ܂B
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        latencyTimer  NULL (GetPciLatencyTimer ̂)
		//        STATUS_WD_PciConfigDump_ERROR    WD_PciConfigDump() ŃG[
		virtual status SetPciLatencyTimer(byte  latencyTimer)       = 0;
		virtual status GetPciLatencyTimer(byte *latencyTimer) const = 0;

		// ------------
		// dE
		// ------------

		enum LnbPower {
			LNB_POWER_OFF,	// It
			LNB_POWER_15V,	// 15V o
			LNB_POWER_11V	// 11V o (mɂ PCI Xbg +12V  0.6V xl)
		};

		// [@\] LNB d
		// [] `[i[̓dƂ͓Ɨɐ\łBftHgl LNB_POWER_OFF łB
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        lnbPower  NULL (GetLnbPower ̂)
		virtual status SetLnbPower(LnbPower  lnbPower)       = 0;
		virtual status GetLnbPower(LnbPower *lnbPower) const = 0;

		// [@\] foCXN[YiُIɂƂȂN[Y܂ށj LNB d
		// [] ftHgl LNB_POWER_OFF łB
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR   foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR         lnbPower  NULL (GetLnbPowerWhenClose ̂)
		//        STATUS_WD_CardCleanupSetup_ERROR  WD_CardCleanupSetup() ŃG[ (SetLnbPowerWhenClose ̂)
		virtual status SetLnbPowerWhenClose(LnbPower  lnbPower)       = 0;
		virtual status GetLnbPowerWhenClose(LnbPower *lnbPower) const = 0;

		// [@\] `[i[dEn[hEFAZbg
		// [] TUNER_POWER_ON_RESET_ENABLE  TUNER_POWER_ON_RESET_DISABLE ̑Jڂɂ͍Œ 15ms ̑҂ԂKvłB
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tunerPowerReset  NULL (GetTunerPowerReset ̂)
		enum TunerPowerReset {				// d^n[hEFAZbg
			TUNER_POWER_OFF,				// It^Cl[u
			TUNER_POWER_ON_RESET_ENABLE,	// I^Cl[u
			TUNER_POWER_ON_RESET_DISABLE	// I^fBZ[u
		};
		virtual status SetTunerPowerReset(TunerPowerReset  tunerPowerReset)       = 0;
		virtual status GetTunerPowerReset(TunerPowerReset *tunerPowerReset) const = 0;

		// [@\] `[i[
		// [] SetTunerPowerReset(TUNER_POWER_ON_RESET_DISABLE) Œ 1s oߌ 1 񂾂Ăяo܂B 
		//         tuner  0 ̃`[i[ԍłB
		//        PT1Ɍ PLL 邽߂ɁAI SetFrequency(tuner, ISDB_S, 0)  SetFrequency(tuner, ISDB_T, 63) 
		//        s܂B
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫
		//        STATUS_POWER_RESET_ERROR         SetTunerPowerReset()  TUNER_POWER_ON_RESET_DISABLE ȊOw肳Ă
		//        STATUS_I2C_ERROR                 IC 烊[hWX^lُ
		virtual status InitTuner(uint tuner) = 0;

		// M
		enum ISDB {
			ISDB_S,
			ISDB_T,

			ISDB_COUNT
		};

		// [@\] `[i[ȓd͐
		// [] `[i[͏ȓd̓IɂȂĂ܂̂ŁAMOɏȓd͂ItɂKv܂B
		//        (PT1) IC ݂̂ΏۂłB`[i[jbg̑̉H SetTunerPowerReset(TUNER_POWER_OFF) ƂȂA
		//              d͂܂BIC ̏d͂̓`[i[W[ 15% łB
		//        (PT2) RFtgGhHŜƕIC ΏۂłB
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫 isdb ͈͊O
		//                                            sleep  NULL (GetTunerSleep ̂)
		virtual status SetTunerSleep(uint tuner, ISDB isdb, bool  sleep)       = 0;
		virtual status GetTunerSleep(uint tuner, ISDB isdb, bool *sleep) const = 0;

		// ----------
		// ǔg
		// ----------

		// [@\] ǔg̐
		// [] offset Ŏg̒\łBPʂ ISDB-S ̏ꍇ 1MHzAISDB-T ̏ꍇ 1/7MHz łB
		//        Ⴆ΁AC24 W 2MHz gɐݒ肷ɂ SetFrequency(tuner, ISDB_T, 23, 7*2) Ƃ܂B
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫 isdb ͈͊O
		//                                            channel  NULL (GetFrequency ̂)
		//        STATUS_TUNER_IS_SLEEP_ERROR      `[i[ȓd͏Ԃ̂ߐݒs (SetFrequency ̂)
		virtual status SetFrequency(uint tuner, ISDB isdb, uint  channel, int  offset = 0)       = 0;
		virtual status GetFrequency(uint tuner, ISDB isdb, uint *channel, int *offset = 0) const = 0;

		// (ISDB-S)
		// PLL gXebv 1MHz ̂߁Aۂɐݒ肳g f' ɂȂ܂B
		// +----+------+---------+---------+ +----+------+---------+---------+ +----+------+---------+---------+
		// | ch | TP # | f (MHz) | f'(MHz) | | ch | TP # | f (MHz) | f'(MHz) | | ch | TP # | f (MHz) | f'(MHz) |
		// +----+------+---------+---------+ +----+------+---------+---------+ +----+------+---------+---------+
		// |  0 | BS 1 | 1049.48 | 1049.00 | | 12 | ND 2 | 1613.00 | ()  | | 24 | ND 1 | 1593.00 | ()  |
		// |  1 | BS 3 | 1087.84 | 1088.00 | | 13 | ND 4 | 1653.00 | ()  | | 25 | ND 3 | 1633.00 | ()  |
		// |  2 | BS 5 | 1126.20 | 1126.00 | | 14 | ND 6 | 1693.00 | ()  | | 26 | ND 5 | 1673.00 | ()  |
		// |  3 | BS 7 | 1164.56 | 1165.00 | | 15 | ND 8 | 1733.00 | ()  | | 27 | ND 7 | 1713.00 | ()  |
		// |  4 | BS 9 | 1202.92 | 1203.00 | | 16 | ND10 | 1773.00 | ()  | | 28 | ND 9 | 1753.00 | ()  |
		// |  5 | BS11 | 1241.28 | 1241.00 | | 17 | ND12 | 1813.00 | ()  | | 29 | ND11 | 1793.00 | ()  |
		// |  6 | BS13 | 1279.64 | 1280.00 | | 18 | ND14 | 1853.00 | ()  | | 30 | ND13 | 1833.00 | ()  |
		// |  7 | BS15 | 1318.00 | ()  | | 19 | ND16 | 1893.00 | ()  | | 31 | ND15 | 1873.00 | ()  |
		// |  8 | BS17 | 1356.36 | 1356.00 | | 20 | ND18 | 1933.00 | ()  | | 32 | ND17 | 1913.00 | ()  |
		// |  9 | BS19 | 1394.72 | 1395.00 | | 21 | ND20 | 1973.00 | ()  | | 33 | ND19 | 1953.00 | ()  |
		// | 10 | BS21 | 1433.08 | 1433.00 | | 22 | ND22 | 2013.00 | ()  | | 34 | ND21 | 1993.00 | ()  |
		// | 11 | BS23 | 1471.44 | 1471.00 | | 23 | ND24 | 2053.00 | ()  | | 35 | ND23 | 2033.00 | ()  |
		// +----+------+---------+---------+ +----+------+---------+---------+ +----+------+---------+---------+
		// 
		// (ISDB-T)
		// +-----+-----+---------+ +-----+-----+---------+ +-----+-----+---------+ +-----+-----+---------+ +-----+-----+---------+
		// | ch. | Ch. | f (MHz) | | ch. | Ch. | f (MHz) | | ch. | Ch. | f (MHz) | | ch. | Ch. | f (MHz) | | ch. | Ch. | f (MHz) |
		// +-----+-----+---------+ +-----+-----+---------+ +-----+-----+---------+ +-----+-----+---------+ +-----+-----+---------+
		// |   0 |   1 |  93+1/7 | |  23 | C24 | 231+1/7 | |  46 | C47 | 369+1/7 | |  69 |  19 | 509+1/7 | |  92 |  42 | 647+1/7 |
		// |   1 |   2 |  99+1/7 | |  24 | C25 | 237+1/7 | |  47 | C48 | 375+1/7 | |  70 |  20 | 515+1/7 | |  93 |  43 | 653+1/7 |
		// |   2 |   3 | 105+1/7 | |  25 | C26 | 243+1/7 | |  48 | C49 | 381+1/7 | |  71 |  21 | 521+1/7 | |  94 |  44 | 659+1/7 |
		// |   3 | C13 | 111+1/7 | |  26 | C27 | 249+1/7 | |  49 | C50 | 387+1/7 | |  72 |  22 | 527+1/7 | |  95 |  45 | 665+1/7 |
		// |   4 | C14 | 117+1/7 | |  27 | C28 | 255+1/7 | |  50 | C51 | 393+1/7 | |  73 |  23 | 533+1/7 | |  96 |  46 | 671+1/7 |
		// |   5 | C15 | 123+1/7 | |  28 | C29 | 261+1/7 | |  51 | C52 | 399+1/7 | |  74 |  24 | 539+1/7 | |  97 |  47 | 677+1/7 |
		// |   6 | C16 | 129+1/7 | |  29 | C30 | 267+1/7 | |  52 | C53 | 405+1/7 | |  75 |  25 | 545+1/7 | |  98 |  48 | 683+1/7 |
		// |   7 | C17 | 135+1/7 | |  30 | C31 | 273+1/7 | |  53 | C54 | 411+1/7 | |  76 |  26 | 551+1/7 | |  99 |  49 | 689+1/7 |
		// |   8 | C18 | 141+1/7 | |  31 | C32 | 279+1/7 | |  54 | C55 | 417+1/7 | |  77 |  27 | 557+1/7 | | 100 |  50 | 695+1/7 |
		// |   9 | C19 | 147+1/7 | |  32 | C33 | 285+1/7 | |  55 | C56 | 423+1/7 | |  78 |  28 | 563+1/7 | | 101 |  51 | 701+1/7 |
		// |  10 | C20 | 153+1/7 | |  33 | C34 | 291+1/7 | |  56 | C57 | 429+1/7 | |  79 |  29 | 569+1/7 | | 102 |  52 | 707+1/7 |
		// |  11 | C21 | 159+1/7 | |  34 | C35 | 297+1/7 | |  57 | C58 | 435+1/7 | |  80 |  30 | 575+1/7 | | 103 |  53 | 713+1/7 |
		// |  12 | C22 | 167+1/7 | |  35 | C36 | 303+1/7 | |  58 | C59 | 441+1/7 | |  81 |  31 | 581+1/7 | | 104 |  54 | 719+1/7 |
		// |  13 |   4 | 173+1/7 | |  36 | C37 | 309+1/7 | |  59 | C60 | 447+1/7 | |  82 |  32 | 587+1/7 | | 105 |  55 | 725+1/7 |
		// |  14 |   5 | 179+1/7 | |  37 | C38 | 315+1/7 | |  60 | C61 | 453+1/7 | |  83 |  33 | 593+1/7 | | 106 |  56 | 731+1/7 |
		// |  15 |   6 | 185+1/7 | |  38 | C39 | 321+1/7 | |  61 | C62 | 459+1/7 | |  84 |  34 | 599+1/7 | | 107 |  57 | 737+1/7 |
		// |  16 |   7 | 191+1/7 | |  39 | C40 | 327+1/7 | |  62 | C63 | 465+1/7 | |  85 |  35 | 605+1/7 | | 108 |  58 | 743+1/7 |
		// |  17 |   8 | 195+1/7 | |  40 | C41 | 333+1/7 | |  63 |  13 | 473+1/7 | |  86 |  36 | 611+1/7 | | 109 |  59 | 749+1/7 |
		// |  18 |   9 | 201+1/7 | |  41 | C42 | 339+1/7 | |  64 |  14 | 479+1/7 | |  87 |  37 | 617+1/7 | | 110 |  60 | 755+1/7 |
		// |  19 |  10 | 207+1/7 | |  42 | C43 | 345+1/7 | |  65 |  15 | 485+1/7 | |  88 |  38 | 623+1/7 | | 111 |  61 | 761+1/7 |
		// |  20 |  11 | 213+1/7 | |  43 | C44 | 351+1/7 | |  66 |  16 | 491+1/7 | |  89 |  39 | 629+1/7 | | 112 |  62 | 767+1/7 |
		// |  21 |  12 | 219+1/7 | |  44 | C45 | 357+1/7 | |  67 |  17 | 497+1/7 | |  90 |  40 | 635+1/7 | +-----+-----+---------+
		// |  22 | C23 | 225+1/7 | |  45 | C46 | 363+1/7 | |  68 |  18 | 503+1/7 | |  91 |  41 | 641+1/7 |
		// +-----+-----+---------+ +-----+-----+---------+ +-----+-----+---------+ +-----+-----+---------+
		// 
		// C24`C27 ́AP[uerǂɂ艺L̎gőMĂꍇ܂B
		// +-----+---------+
		// | Ch. | f (MHz) |
		// +-----+---------+
		// | C24 | 233+1/7 |
		// | C25 | 239+1/7 |
		// | C26 | 245+1/7 |
		// | C27 | 251+1/7 |
		// +-----+---------+

		// ----------
		// g덷
		// ----------

		// [@\] g덷擾
		// [] l̈Ӗ͎̒ʂłB
		//        NbNg덷: clock/100 (ppm)
		//        LAg덷: carrier (Hz)
		//        g̎gx͏\ɍ肷ƁA덷vfƂĈȉ̂悤Ȃ̂l܂B
		//        (ISDB-S) LNB ł̎gϊx / q PLL-IC ɐڑĂUq̐x /  IC ɐڑĂUq̐x
		//        (ISDB-T) n㑤 PLL-IC ɐڑĂUq̐x /  IC ɐڑĂUq̐x
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫 isdb ͈͊O
		//                                            clock, carrier ̂ꂩ NULL
		//        STATUS_TUNER_IS_SLEEP_ERROR      `[i[ȓd͏
		virtual status GetFrequencyOffset(uint tuner, ISDB isdb, int *clock, int *carrier) = 0;

		// --------
		// C/NEAGC
		// --------

		// [@\] C/N  AGC 擾
		// [] C/N ͒჌CeVőł邽߁AAeǐ𒲐̂ɕ֗łB
		//        l̈Ӗ͎̒ʂłB
		//        C/N                : cn100/100 (dB)
		//        ݂ AGC l      : currentAgc
		//        ő厞 AGC l: maxAgc
		//        currentAgc ͈̔͂ 0  maxAgc ܂łłB
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫 isdb ͈͊O
		//                                            cn100, currentAgc, maxAgc ̂ꂩ NULL
		//        STATUS_TUNER_IS_SLEEP_ERROR      `[i[ȓd͏
		virtual status GetCnAgc(uint tuner, ISDB isdb, uint *cn100, uint *currentAgc, uint *maxAgc) = 0;

		// -------------------
		// TS-ID (ISDB-S ̂)
		// -------------------

		// [@\] TS-ID ݒ
		// [] ݒlIC ̓ɔf܂ŎԂ|܂B
		//        GetLayerS() ĂяoOɁAGetIdS() gĐ؂ւƂmFĂB
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫
		virtual status SetIdS(uint tuner, uint id) = 0;

		// [@\] ݏ TS-ID 擾
		// [] GetLayerS() Ŏ擾ł郌ĆÅ֐Ŏ TS-ID ̂̂ɂȂ܂B
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫B܂͈ id  NULL
		virtual status GetIdS(uint tuner, uint *id) = 0;

		// ------------
		// G[[g
		// ------------

		// KwCfbNX
		enum LayerIndex {
			// ISDB-S
			LAYER_INDEX_L = 0,	// Kw
			LAYER_INDEX_H,		// Kw

			// ISDB-T
			LAYER_INDEX_A = 0,	// A Kw
			LAYER_INDEX_B,		// B Kw
			LAYER_INDEX_C		// C Kw
		};

		// Kw
		enum LayerCount {
			// ISDB-S
			LAYER_COUNT_S = LAYER_INDEX_H + 1,

			// ISDB-T
			LAYER_COUNT_T = LAYER_INDEX_C + 1
		};

		// G[[g
		struct ErrorRate {
			uint Numerator, Denominator;
		};

		// [@\] [h\ŒꂽG[[g擾
		// [] ɎԂ|܂AMi𐳊mɔcɂ C/N ł͂Ȃ̃G[[gQlɂĂB
		//        ЂƂ̖ڈƂ 2~10^-4 ȉł΁A[h\ɂقڃG[t[ɂȂƂĂ܂B
		//        G[[g̏WvPʂ͎̒ʂłB
		//        ISDB-S: 1024 t[
		//        ISDB-T: 32 t[ ([h 1,2) / 8 t[ ([h 3)
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner, isdb, layerIndex ͈͊OB܂ errorRate  NULL
		virtual status GetCorrectedErrorRate(uint tuner, ISDB isdb, LayerIndex layerIndex, ErrorRate *errorRate) = 0;

		// [@\] [h\ŒꂽG[[gvZ邽߂̃G[JE^
		// [] SKw̃JE^܂B̊Kw̃JE^Zbg邱Ƃ͂ł܂B
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫 isdb ͈͊O
		virtual status ResetCorrectedErrorCount(uint tuner, ISDB isdb) = 0;

		// [@\] [h\ŒȂ TS pPbg擾
		// [] 24rbĝݗLłiHK͂邽߉Hԍ01 ɂărbgkjB
		//        0x??ffffff ̎ 0x??000000 ɂȂ܂B
		//        TS pPbg 2nd Byte MSB 𐔂ĂlɂȂ܂B
		//        ̃JE^ DMA ]Jnɏ܂B
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫 isdb ͈͊OB܂͈ count  NULL
		virtual status GetErrorCount(uint tuner, ISDB isdb, uint *count) = 0;

		// --------------------------
		// TMCCEC[EbN
		// --------------------------

		// ISDB-S TMCC 
		// (Ql) STD-B20 2.9 TMCC̍\ ` 2.11 TMCC̍XV
		struct TmccS {
			uint Indicator;		// ύXw (5rbg)
			uint Mode[4];		// `[hn (4rbg)
			uint Slot[4];		// `[hnւ̊Xbg (6rbg)
								// [TS^Xbg͎擾ł܂]
			uint Id[8];			// TSԍnɑ΂TS ID (16rbg)
			uint Emergency;		// NM (1rbg)
			uint UpLink;		// AbvN (4rbg)
			uint ExtFlag;		// gtO (1rbg)
			uint ExtData[2];	// g̈ (61rbg)
		};

		// [@\] ISDB-S  TMCC 擾
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫 tmcc  NULL
		virtual status GetTmccS(uint tuner, TmccS *tmcc) = 0;

		// ISDB-S Kw
		struct LayerS {
			uint Mode [LAYER_COUNT_S];	// `[h (3rbg) 
			uint Count[LAYER_COUNT_S];	// _~[Xbg܂߂Xbg (6rbg)
		};

		// [@\] ISDB-S ̃C擾
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫 layerS  NULL
		virtual status GetLayerS(uint tuner, LayerS *layerS) = 0;

		// ISDB-T TMCC 
		// (Ql) STD-B31 3.15.6 TMCC ` 3.15.6.8 ZOg
		struct TmccT {
			uint System;					// VXe (2rbg)
			uint Indicator;					// `p[^؂ւwW (4rbg)
			uint Emergency;					// ً}xpNtO (1rbg)
											// Jg
			uint Partial;					// MtO (1rbg)
											// Kw
			uint Mode      [LAYER_COUNT_T];	// LAϒ (3rbg)
			uint Rate      [LAYER_COUNT_T];	// 􍞂ݕ (3rbg)
			uint Interleave[LAYER_COUNT_T];	// C^[[u (3rbg)
			uint Segment   [LAYER_COUNT_T];	// ZOg (4rbg)
											// [lNXg͎擾ł܂]
			uint Phase;						// AMʑ␳ (3rbg)
			uint Reserved;					// U[u (12rbg)
		};

		// [@\] ISDB-T  TMCC 擾
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫 tmcc  NULL
		virtual status GetTmccT(uint tuner, TmccT *tmcc) = 0;

		// [@\] ISDB-T bN擾
		// [] C݂AȂ̃CG[t[łƂ true ɂȂ܂B
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫 locked  NULL
		virtual status GetLockedT(uint tuner, bool locked[LAYER_COUNT_T]) = 0;

		// MKw
		enum LayerMask {
			LAYER_MASK_NONE,

			// ISDB-S
			LAYER_MASK_L = 1 << LAYER_INDEX_L,
			LAYER_MASK_H = 1 << LAYER_INDEX_H,

			// ISDB-T
			LAYER_MASK_A = 1 << LAYER_INDEX_A,
			LAYER_MASK_B = 1 << LAYER_INDEX_B,
			LAYER_MASK_C = 1 << LAYER_INDEX_C
		};

		// [@\] MKw̐ݒ
		// [] ISDB-S ̒KwMȂ悤ɐݒ肷邱Ƃ͂ł܂B
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫 isdb ͈͊O
		//                                            layerMask ͈͊O (SetLayerEnable ̂)
		//                                            layerMask  NULL (GetLayerEnable ̂)
		virtual status SetLayerEnable(uint tuner, ISDB isdb, LayerMask  layerMask)       = 0;
		virtual status GetLayerEnable(uint tuner, ISDB isdb, LayerMask *layerMask) const = 0;

		// --------
		// DMA ]
		// --------

		// obt@TCY
		enum {
			BUFFER_PAGE_COUNT = 511
		};

		// obt@
		struct BufferInfo {
			uint VirtualSize;
			uint VirtualCount;
			uint LockSize;
		};
		// obt@̓hCo VirtualAlloc(4096*BUFFER_PAGE_COUNT*VirtualSize)  VirtualCount ĂяoƂɂmۂ܂B
		// VirtualCount  2 ȏ̏ꍇ̓obt@邽߁AAhXsAɂȂ邱ƂɂӂB
		// LockSize ̓hCoŃbNPʂłB
		// 
		// VirtualSize ͈̔͂ 0 ȊO̔Cӂ̐lłB
		// (VirtualSize * VirtualCount) ͓]JE^̃rbgɂ鐧󂯂邽߁A͈͂ 1`4095 łB
		// (VirtualSize % LockSize)  0 łȂ΂Ȃ܂B
		// 
		// DMA obt@ CPU 猩ăLbV֎~ɂȂĂ܂B̂߁Aobt@̓eoCgPʂŕ
		// ǂݏoꍇȂǂɑxቺ܂Bɂ̓f[^LbV\ȃɃRs[āA
		// Rs[ꂽf[^ɃANZX܂B

		// [@\] DMA obt@̊mہE
		// [] DMA obt@Jɂ SetBufferInfo(NULL) Ƃ܂B
		//        obt@mۂĂȂƂ GetBufferInfo() ĂяoƁAbufferInfo wSẴo 0 ɂȂ܂B
		//        obt@̍\ύXꍇ́Ã݂obt@Ă߂Ċmۂ܂B
		virtual status SetBufferInfo(const BufferInfo *bufferInfo)       = 0;
		virtual status GetBufferInfo(      BufferInfo *bufferInfo) const = 0;

		// [@\] DMA obt@̃|C^擾
		// [] index Ŏw肵 DMA obt@̃|C^擾܂Bindex ͈̔͂ 0  BufferInfo::VirtualCount-1 łB
		virtual status GetBufferPtr(uint index, void **ptr) const = 0;

		// [@\] ]JE^ZbgECNg
		// [] FPGA Ĥ͎悤ɓ삵܂B
		//			while (true) {
		//				/* ]JE^`FbN */
		//				if (]JE^ == 0) {
		//					TransferInfo::TransferCounter0 = true;
		//					break;
		//				}
		//				if (]JE^ <= 1) {
		//					TransferInfo::TransferCounter1 = true;
		//					/* ł break Ȃ */
		//				}
		//
		//				/* ]JE^fNg */
		//				]JE^--;
		//
		//				/* f[^] */
		//				for (uint i=0; i<BUFFER_PAGE_COUNT; i++) {
		//					/* 4096+64 oCg̃f[^܂܂ő҂ */
		//					while (true) {
		//						if (4096+64 <= obt@̃f[^oCg) {
		//							break;
		//						}
		//					}
		//					/* 4096 oCg̃f[^] */
		//					Transfer();
		//				}
		//			}
		//        zXǵA4096*BUFFER_PAGE_COUNT oCgPʂœ]JE^CNg邱ƂɂȂ܂B
		//        ]JE^ 12 rbgłB
		virtual status ResetTransferCounter() = 0;
		virtual status IncrementTransferCounter() = 0;

		// [@\] Xg[Ƃ̓]
		// [] eXg[]邩ǂݒ肷邱Ƃł܂B
		//        Kv̂ȂXg[Itɂ邱Ƃ PCI oX̑ш𖳑ʂɎgƂȂȂ܂B
		//        DMA ]쒆ɂύX\łB
		virtual status SetStreamEnable(uint tuner, ISDB isdb, bool  enable)       = 0;
		virtual status GetStreamEnable(uint tuner, ISDB isdb, bool *enable) const = 0;

		// [@\] Xg[Ƃ 3 rbg⏕f[^̐ݒ
		// [] 1 TS pPbg(188oCg)  63 }CNpPbggē]܂A
		//        3oCg~63}CNpPbg=189oCgƂȂÃ}CNpPbgɂ͖gp 1 oCg܂B
		//        ̃oCg̉ 3 rbg[U[Rɐݒ肷邱Ƃł܂B
		//        IC ̐M FPGA Ƀf[^荞łł邾 3 rbg̃f[^
		//        t܂̂ŁA^CX^vɗp邱Ƃł܂B
		//        FPGA ł͒l݂̏ PCI NbNɓAl̓ǂݏo TS NbNɓĂ܂B
		//        ̂߁Aݒ肷鐔̓OCR[hȂǂ̃n~O 1 ̂̂gĂB
		virtual status SetStreamGray(uint tuner, ISDB isdb, uint  gray)       = 0;
		virtual status GetStreamGray(uint tuner, ISDB isdb, uint *gray) const = 0;

		// [@\] DMA JnE~̐
		// [] DMA ]͑S CPU ݂邱ƂȂ삵܂B
		//        GetTransferEnable()  true  Ƃ SetTransferEnable(true ) ƂA
		//        GetTransferEnable()  false Ƃ SetTransferEnable(false) ƂƃG[ɂȂ܂B
		//        
		//        GetTransferEnable() Ŏ擾łĺAP SetTransferEnable() ōŌɐݒ肳ꂽlƓłB
		//        ]JE^ 0 ɂȂȂǁAn[hEFA DMA ]Iɒ~v܂A
		//        ̏ꍇł GetTransferEnable() œl͕ς܂B
		virtual status SetTransferEnable(bool  enable)       = 0;
		virtual status GetTransferEnable(bool *enable) const = 0;

		struct TransferInfo {
			bool TransferCounter0;	// ]JE^ 0 ł̂o
			bool TransferCounter1;	// ]JE^ 1 ȉł̂o
			bool BufferOverflow;	// PCI oX𒷊ɓnmۂłȂ߁A{[h FIFO(TCY=8MB) ꂽ
		};							// (̃tÓAxło DMA ]ĊJ܂ŃNA܂)

		// [@\] DMA Ԃ̎擾
		virtual status GetTransferInfo(TransferInfo *) = 0;

		// }CNpPbg̍\
		// +------------+----+----+----+----+----+----+----+----+----+----+----+
		// | rbgʒu | 31 | 30 | 29 | 28 | 27 | 26 | 25 | 24 | 23 | .. |  0 |
		// +------------+----+----+----+----+----+----+----+----+----+----+----+
		// |    e    |      id      |    counter   | st | er |     data     |
		// +------------+--------------+--------------+----+----+--------------+
		// id     : Xg[ID
		// counter: Xg[Ƃ̃JE^
		// st     : TS pPbgJnʒutO
		// er     : G[tO (TransferCounter0  TransferCounter1  BufferOverflow ̘_a)
		// data   : f[^

		// Xg[ID
		// +----+------------------------+
		// | id |                    |
		// +----+------------------------+
		// |  0 | ֎~                   |
		// |  1 | `[i[ԍ0 ISDB-S |
		// |  2 | `[i[ԍ0 ISDB-T |
		// |  3 | `[i[ԍ1 ISDB-S |
		// |  4 | `[i[ԍ1 ISDB-T |
		// |  5 | \                   |
		// |  6 | \                   |
		// |  7 | \                   |
		// +----+------------------------+
		// Xg[ID  0 ɂȂ邱Ƃ͐΂ɂ܂B
		// DMA ]ǂ܂Őił̂𒲂ׂɂ́A]O Xg[ID  0 ɐݒ肵āA
		// ̉ӏ 0 ȊOɂȂǂ𒲂ׂ܂B
		// p͓]O 4 oCg̃}CNpPbg̈ 0 ݁A0 ȊOɂȂǂ𒲂ׂ邱ƂɂȂ܂B

		// }CNpPbg TS pPbgč\@ɂĂ̓TvR[hQƂB
		// ̊֐Ăяo 188 oCgɖȂpPbg邱ƂA؎̂ďKvłB
		// ESetTunerSleep()
		// ESetFrequency()
		// ESetIdS()
		// ESetLayerEnable()
		// ESetStreamEnable()
		// ESetTransferEnable(true)

	protected:
		virtual ~Device() {}
	};

	enum Status {
		// G[Ȃ
		STATUS_OK,

		// ʓIȃG[
		STATUS_GENERAL_ERROR = (1)*0x100,
		STATUS_NOT_IMPLIMENTED,
		STATUS_INVALID_PARAM_ERROR,
		STATUS_OUT_OF_MEMORY_ERROR,
		STATUS_INTERNAL_ERROR,

		// oXNX̃G[
		STATUS_WDAPI_LOAD_ERROR = (2)*256,	// wdapi1002.dll [hłȂ
		STATUS_ALL_DEVICES_MUST_BE_DELETED_ERROR,

		// foCXNX̃G[
		STATUS_PCI_BUS_ERROR = (3)*0x100,
		STATUS_CONFIG_REVISION_ERROR,
		STATUS_FPGA_VERSION_ERROR,
		STATUS_PCI_BASE_ADDRESS_ERROR,
		STATUS_FLASH_MEMORY_ERROR,

		STATUS_DCM_LOCK_TIMEOUT_ERROR,
		STATUS_DCM_SHIFT_TIMEOUT_ERROR,

		STATUS_POWER_RESET_ERROR,
		STATUS_I2C_ERROR,
		STATUS_TUNER_IS_SLEEP_ERROR,

		STATUS_PLL_OUT_OF_RANGE_ERROR,
		STATUS_PLL_LOCK_TIMEOUT_ERROR,

		STATUS_VIRTUAL_ALLOC_ERROR,
		STATUS_DMA_ADDRESS_ERROR,
		STATUS_BUFFER_ALREADY_ALLOCATED_ERROR,

		STATUS_DEVICE_IS_ALREADY_OPEN_ERROR,
		STATUS_DEVICE_IS_NOT_OPEN_ERROR,

		STATUS_BUFFER_IS_IN_USE_ERROR,
		STATUS_BUFFER_IS_NOT_ALLOCATED_ERROR,

		STATUS_DEVICE_MUST_BE_CLOSED_ERROR,

		// WinDriver ֘ÃG[
		STATUS_WD_DriverName_ERROR = (4)*0x100,

		STATUS_WD_Open_ERROR,
		STATUS_WD_Close_ERROR,

		STATUS_WD_Version_ERROR,
		STATUS_WD_License_ERROR,

		STATUS_WD_PciScanCards_ERROR,

		STATUS_WD_PciConfigDump_ERROR,

		STATUS_WD_PciGetCardInfo_ERROR,
		STATUS_WD_PciGetCardInfo_Bus_ERROR,
		STATUS_WD_PciGetCardInfo_Memory_ERROR,

		STATUS_WD_CardRegister_ERROR,
		STATUS_WD_CardUnregister_ERROR,

		STATUS_WD_CardCleanupSetup_ERROR,

		STATUS_WD_DMALock_ERROR,
		STATUS_WD_DMAUnlock_ERROR,

		STATUS_WD_DMASyncCpu_ERROR,
		STATUS_WD_DMASyncIo_ERROR
	};

	// ------------------------------
	// Cxgɂ铮̏ڍ
	// ------------------------------

	// 1. {[h̓dꂽƂ́An[hEFA͈ȉ̏ԂɂȂ܂B
	//    ESetLnbPower(LNB_POWER_OFF)
	//    ESetTunerPowerReset(TUNER_POWER_OFF)
	//    EDMA ͒~
	// 2. PCI ZbgAT[gꂽƂAdƓԂɂȂ܂B
	// 3. AvP[VُIꍇ܂߃foCXN[YƂ́Aȉ̏ԂɎs܂B
	//    EDMA ~
	//    ESetLnbPower([SetLnbPowerWhenClose() Ŏw肳ꂽl])
	//    ESetTunerPowerReset(TUNER_POWER_OFF)
	//    EDMA obt@
}
}

#endif
