//
// InternetTextMessageBody.cpp
//

#include <stdlib.h>

#include "net/InternetTextMessageBody.h"

using namespace Raym;

namespace NET
{

InternetTextMessageBody::InternetTextMessageBody()
{
    _body = NULL;
    _data = NULL;
}

InternetTextMessageBody::~InternetTextMessageBody()
{
    RELEASE(_body);
    RELEASE(_data);
}

InternetTextMessageBody *InternetTextMessageBody::alloc()
{
    return new InternetTextMessageBody();
}

InternetTextMessageBody *InternetTextMessageBody::initWithString(String *string)
{
    if (string != NULL)
    {
        _body = string->retain();
        return this;
    }

    release();
    return NULL;
}

InternetTextMessageBody *InternetTextMessageBody::initWithData(Data *data)
{

    if (data != NULL)
    {
        _data = data->retain();
        return this;
    }

    release();
    return NULL;
}

InternetTextMessageBody *InternetTextMessageBody::retain()
{
    Object::retain();
    return this;
}

InternetTextMessageBody *InternetTextMessageBody::autorelease()
{
    Object::autorelease();
    return this;
}

String *InternetTextMessageBody::body()
{
    return _body;
}

Data *InternetTextMessageBody::data()
{
    return _data;
}

const char *InternetTextMessageBody::className()
{
    return "NET::InternetTextMessageBody";
}

} // NET
