/**
 * @file PAT.h
 *
 */

#pragma once

#include "mpeg2/ts/Table.h"

namespace MPEG2
{
namespace TS
{

class PAT : public Table
{
public:
    uint8_t         _table_id;                  //  8
    uint8_t         _section_syntax_indicator;  //  1
                                                //  1  '0'
                                                //  2  reserved
    uint16_t        _section_length;            // 12
    uint16_t        _transport_stream_id;       // 16
                                                //  2  reserved
    uint8_t         _version_number;            //  5
    uint8_t         _current_next_indicator;    //  1
    uint8_t         _section_number;            //  8
    uint8_t         _last_section_number;       //  8
    uint16_t        _program_count;
    struct _program
    {
        uint16_t    _program_number;            // 16
                                                //  3  reserved
        uint16_t    _pid;                       // 13
    } *             _programs;
                                                // 32  CRC

protected:
    bool decode_section();

public:
    PAT();
    PAT(const PAT &pat);
    ~PAT();
    void reset();
    bool isEqual(PAT *pat);
};

} // TS
} // MPEG2
