//
//
//

#pragma once

#include <Raym/Object.h>

namespace Raym
{

class Timer;

class TimerDelegate
{
public:
    virtual void timerExpired(Timer *timer, void *userInfo) = 0;
};

class Timer : public Object
{
private:
    TimeInterval      _interval;
    TimerDelegate *   _delegate;
    void *              _userInfo;
    bool                _repeats;
    enum _state
    {
        ST_IDLE,
        ST_READY,
        ST_RUN,
        ST_DONE
    }                   _state;

    bool start();

protected:
    Timer();
    ~Timer();


public:
    static Timer *scheduledTimerWithTimeInterval(TimeInterval interval, TimerDelegate *delegate, void *userInfo, bool repeats);
    static Timer *alloc();

    Timer *initWithTimeInterval(TimeInterval interval, TimerDelegate *delegate, void *userInfo, bool repeats);
    void fire();

    void invalidate();

    void run();

    void setRepeats(bool repeats);
    void setTimeInterval(TimeInterval interval);
    void setUserInfo(void *userInfo);
    bool valid();

    virtual const char *className();
};

} // Raym

