﻿/**
 * @file Service.h
 *
 */

#pragma once

#ifdef _WIN32
#include <windows.h>
#endif

#include "Raym/Object.h"

namespace Raym
{

class Service : public Object
{
private:
    LPWSTR  _serviceName;
    SERVICE_STATUS_HANDLE   _serviceStatus;

protected:
    Service();
    ~Service();

public:
    static Service *alloc();
    virtual Service *init(LPWSTR serviceName);
    void serviceMain(DWORD dwArgc, PTSTR *pszArgv);
    bool setServiceStatus(SERVICE_STATUS *ss);
    virtual void start();
    virtual void stop();

    void sleep();
    void shutdown();
    void cancelShutdown();
    bool setWakeSchedule(int year, int month, int day, int hour, int min);
    void resetWakeSchedule();

    static const char *GetHomeDirectory();
    static const char *GetExecutePath();
    static const char *GetPublicDirectory();

    // Win32 サービスのエントリポイント
    static int main(Service *(*allocator)(), LPWSTR serviceName, int argc, char *argv[]);
};

} // Raym

#define ServiceMain(SVCCLASS, SVCNAME, ARGC, ARGV) Raym::Service::main((Raym::Service *(*)())SVCCLASS::alloc, SVCNAME, ARGC, ARGV)
