﻿/**
 * @file Service.cpp
 *
 */

#include <process.h>

#define DBG_LEVEL 3
#include "Raym/Log.h"
#include "Raym/Raym.h"

namespace Raym
{

static Service *sharedService_  = NULL;

DWORD WINAPI _HandlerEx(DWORD dwControl, DWORD dwEventType, LPVOID lpEventData, LPVOID lpContext)
{
    DebugLog2("%s() start.", __FUNCTION__);

    DWORD result = ERROR_CALL_NOT_IMPLEMENTED;

    Service *service = (Service *)lpContext;
    SERVICE_STATUS ss;

    switch (dwControl)
    {
    case SERVICE_CONTROL_STOP:
    case SERVICE_CONTROL_PRESHUTDOWN:

        ss.dwServiceType = SERVICE_WIN32_OWN_PROCESS;
        ss.dwWin32ExitCode = NO_ERROR;
        ss.dwServiceSpecificExitCode = 0;
        ss.dwCheckPoint = 1;
        ss.dwWaitHint = 50000;
        ss.dwControlsAccepted = SERVICE_ACCEPT_STOP | SERVICE_ACCEPT_PRESHUTDOWN;
        ss.dwCurrentState = SERVICE_STOP_PENDING;

        if (service->setServiceStatus(&ss))
        {
            DebugLog2("call stop()");
            service->stop();

            ss.dwCurrentState = SERVICE_STOPPED;
            ss.dwCheckPoint = 0;
            ss.dwWaitHint = 0;
              
            if (!service->setServiceStatus(&ss))
            {
                DebugLog0("error: SetServiceStatus(): %u", GetLastError());
            }
        }
        else
        {
            DebugLog0("error: SetServiceStatus(): %u", GetLastError());
        }

        result = NO_ERROR;
        break;
    }

    DebugLog2("%s() end.", __FUNCTION__);

    return result;
}

VOID WINAPI _ServiceMain(DWORD dwArgc, PTSTR* pszArgv)
{
    if (sharedService_ != NULL)
    {
        sharedService_->serviceMain(dwArgc, pszArgv);
    }
}

void Service::serviceMain(DWORD dwArgc, PTSTR* pszArgv)
{
    DebugLog2("%s() start.", __FUNCTION__);

    _serviceStatus = RegisterServiceCtrlHandlerEx(_serviceName, _HandlerEx, this);
    if (_serviceStatus == NULL)
    {
        DebugLog0("error: RegisterServiceCtrlHandler(): %u", GetLastError());
        return;
    }

    SERVICE_STATUS ss;
    ss.dwServiceType = SERVICE_WIN32_OWN_PROCESS;
    ss.dwWin32ExitCode = NO_ERROR;
    ss.dwServiceSpecificExitCode = 0;
    ss.dwCheckPoint = 1;
    ss.dwWaitHint = 15000;
    ss.dwControlsAccepted = SERVICE_ACCEPT_STOP | SERVICE_ACCEPT_PRESHUTDOWN;
    ss.dwCurrentState = SERVICE_START_PENDING;

    if (!SetServiceStatus(_serviceStatus, &ss))
    {
        DebugLog0("error: SetServiceStatus(): %u", GetLastError());
        return;
    }

    //
    start();

    DebugLog2("%s() end.", __FUNCTION__);
}

Service::Service()
{
    DebugLog2("%s", __FUNCTION__);
}

Service::~Service()
{
    DebugLog2("%s", __FUNCTION__);
}

int Service::main(Service *(*allocator)(), LPWSTR serviceName, int argc, char *argv[])
{
    int result = -1;

#ifdef RAYM_MEMORY_CHECK
    DebugLog0("");
    DebugLog0("Service::main() global_raym_count_ = %d", Raym::global_raym_count_);
#endif

    // ARP生成
    AutoreleasePool *pool = AutoreleasePool::alloc()->init();

    // winsockの初期化
    WSADATA wsaData;
    WSAStartup(MAKEWORD(2,2), &wsaData);

    SERVICE_TABLE_ENTRY ServiceTable[] =
    {
        {serviceName, _ServiceMain},
        {NULL, NULL}
    };

    sharedService_ = allocator();

    if (sharedService_ != NULL)
    {
        if (sharedService_->init(serviceName))
        {
            StartServiceCtrlDispatcher(ServiceTable);
        }
    }

    sharedService_->release();

    // winsockのリソース解放
    WSACleanup();

    // ARP解放
    pool->release();

#ifdef RAYM_MEMORY_CHECK
    DebugLog0("Service::main() global_raym_count_ = %d", Raym::global_raym_count_);
#endif

    return result;
}

Service *Service::init(LPWSTR serviceName)
{
    _serviceName = serviceName;
    _serviceStatus = NULL;
    return this;
}

bool Service::setServiceStatus(SERVICE_STATUS *ss)
{
    return SetServiceStatus(_serviceStatus, ss) ? true : false;
}

void Service::start()
{
    DebugLog2("%s", __FUNCTION__);
}

void Service::stop()
{
    DebugLog2("%s", __FUNCTION__);
}

void Service::sleep()
{
    DebugLog2("%s", __FUNCTION__);
}

void Service::shutdown()
{
    DebugLog2("%s", __FUNCTION__);
    system("shutdown /s /t 180");
}

void Service::cancelShutdown()
{
    DebugLog2("%s", __FUNCTION__);
    system("shutdown /a");
}

bool Service::setWakeSchedule(int year, int month, int day, int hour, int min)
{
    return false;
}

void Service::resetWakeSchedule()
{
}

//
// remark: This function is not thread safe.
//
const char *Service::GetHomeDirectory(void)
{
    static char home_directory_[MAX_PATH + 1];

    memset(home_directory_, 0x00, sizeof(home_directory_));

    TCHAR strbuf[MAX_PATH + 1];
    size_t len = GetEnvironmentVariable(L"USERPROFILE", strbuf, sizeof(strbuf));
    if (len > 0)
    {
        errno_t e;
        size_t returnValue;
        e = wcstombs_s(&returnValue, home_directory_, sizeof(home_directory_), strbuf, _TRUNCATE);
        if (e == 0)
        {
            return home_directory_;
        }
    }
    return NULL;
}

//
// remark: This function is not thread safe.
//
const char *Service::GetExecutePath(void)
{
    static char execute_path_[MAX_PATH + 1];
    memset(execute_path_, 0x00, sizeof(execute_path_));

    TCHAR strbuf[MAX_PATH + 1];
    if (GetModuleFileName(NULL, strbuf, MAX_PATH) != 0)
    {
        errno_t e;
        size_t returnValue;
        e = wcstombs_s(&returnValue, execute_path_, sizeof(execute_path_), strbuf, _TRUNCATE);
        if (e == 0)
        {
            return execute_path_;
        }
    }
    return NULL;
}

//
// remark: This function is not thread safe.
//
const char *Service::GetPublicDirectory(void)
{
    static char public_directory_[MAX_PATH + 1];

    memset(public_directory_, 0x00, sizeof(public_directory_));

    TCHAR strbuf[MAX_PATH + 1];
    size_t len = GetEnvironmentVariable(L"PUBLIC", strbuf, sizeof(strbuf));
    if (len > 0)
    {
        errno_t e;
        size_t returnValue;
        e = wcstombs_s(&returnValue, public_directory_, sizeof(public_directory_), strbuf, _TRUNCATE);
        if (e == 0)
        {
            return public_directory_;
        }
    }
    return NULL;
}

} // Raym
