﻿//
//
//

#pragma once

#include <Raym/Object.h>
#include <Raym/Dictionary.h>
#ifdef _WIN32
#include <windows.h>
#include <tlhelp32.h>
#endif

namespace Raym
{

class RunningApplication : public Object
{
public:
    const static char *KEY_IMAGE;
    const static char *KEY_MEMORY;
    const static char *KEY_STATUS;
    const static char *KEY_USER;
    const static char *KEY_CPU;
    const static char *KEY_PACKAGE;

private:
    int         _pid;
    String *  _execPath;
    String *  _memory;
    String *  _status;
    String *  _user;
    String *  _cpu;
    String *  _package;

protected:
    RunningApplication();
    ~RunningApplication();

public:
    static RunningApplication *alloc();
    RunningApplication *initWithPID(int pid, Dictionary *dict);

    bool isRunning();
    String *executePath();


    virtual const char *className();
};

} // Raym

