//
// HTTPURLResponse.h
//

#pragma once

#include <Raym/Object.h>
#include <Raym/String.h>
#include <Raym/Dictionary.h>
#include <Raym/URLResponse.h>

namespace Raym
{

class HTTPURLResponse : public URLResponse
{
protected:
    HTTPURLResponse();
    ~HTTPURLResponse();

    Integer       _statusCode;
    String *      _HTTPVersion;
    Dictionary *  _headerFields;

public:
    static HTTPURLResponse *alloc();
    HTTPURLResponse *initWithURL(URL *url, Integer statusCode, String *HTTPVersion, Dictionary *headerFields);
    Integer statusCode();
    Dictionary *allHeaderFields();

//    virtual String *description();
    virtual const char *className();
};

} // Raym

