//
// Dictionary.h
//

#pragma once

#include <vector>

#include <Raym/Object.h>
#include <Raym/String.h>
#include <Raym/Array.h>
#include <Raym/Number.h>
//#include <Raym/URL.h>

namespace Raym
{

class Dictionary : public Object
{
protected:
    Dictionary();
    ~Dictionary();

    class KeyAndValue : public Object
    {
    protected:
        KeyAndValue();
        ~KeyAndValue();
        String *    _key;
        Object *    _value;
    public:
        static KeyAndValue *keyAndValue(String *key, Object *value);
        String *key();
        Object *value();

        virtual const char *className();
    };

    std::vector<Object *> _dict;


//    static Dictionary *dictionaryWithData(Data *data, StringEncoding encoding);
//    static Array *arrayWithData(Data *data, StringEncoding encoding);

    void writeTo(int fd, int level);
    void writeValue(int fd, int level, Object *value);

    std::string toString(int level);
    std::string toStringValue(int level, Object *value);

public:
    //
    static Dictionary *dictionaryWithCapacity(UInteger numItems);
    static Dictionary *dictionaryWithDictionary(Dictionary *dictionary);
//    static Dictionary *dictionaryWithContentsOfURL(URL *url);
    static Dictionary *alloc();
    Dictionary *initWithCapacity(UInteger numItems);
    Dictionary *initWithDictionary(Dictionary *dictionary);
    Dictionary *initWithContentsOfFile(String *path);
    Dictionary *initWithContentsOfFile(const char *path);
    Dictionary *retain();
    Dictionary *autorelease();

    void setObject(Object *object, String *forKey);
    Object *objectForKey(String *key);
    void removeObjectForKey(String *key);
    void removeObjectForKey(const char *key);

    void setObject(Object *object, const char *forKey);
    Object *objectForKey(const char *key);
    void setString(String *string, const char *forKey);
    void setString(const char *string, const char *forKey);
    String *stringForKey(String *key);
    String *stringForKey(const char *key);
    void setInteger(int value, String *key);
    void setInteger(int value, const char *key);
    int integerForKey(String *key);
    int integerForKey(const char *key);
    Dictionary *dictionaryForKey(String *key);
    Dictionary *dictionaryForKey(const char *key);
    Array *arrayForKey(String *key);
    Array *arrayForKey(const char *key);
    void setBool(bool value, String *key);
    void setBool(bool value, const char *key);
    bool boolForKey(String *key);
    bool boolForKey(const char *key);

    Array *allKeys();
    UInteger count();

    bool writeToFile(String *path, bool atomically);
    bool writeToFile(const char *path, bool atomically);

    std::string toString();

//    virtual String *description();
    virtual const char *className();
};

} // Raym

