//
// Date.h
//

#pragma once

#ifdef _WIN32
#include <winsock.h>

struct timezone 
{
    int tz_minuteswest; /* minutes W of Greenwich */
    int tz_dsttime;     /* type of dst correction */
};

int gettimeofday(struct timeval *tv, struct timezone *tz);

#else
#include <sys/time.h>
#endif

#include <Raym/Object.h>

namespace Raym
{

typedef double TimeInterval;

class Date : public Object
{
private:
    struct timeval  _time;
    struct timezone _zone;

protected:
    Date();
    ~Date();

public:
    static Date *alloc();
    static Date *date();
    static Date *dateWithTimeIntervalSinceNow(TimeInterval seconds);

    Date *init();
    Date *initWithTimeInterval(TimeInterval seconds, Date *refDate);
    Date *initWithTimeIntervalSinceNow(TimeInterval seconds);

    Date *dateByAddingTimeInterval(TimeInterval seconds);

    TimeInterval timeIntervalSinceDate(Date *anotherDate);
    ComparisonResult compare(Date *anotherDate);

    virtual const char *className();
};

} // Raym

