(defpackage igo.queue
  (:use :common-lisp :igo.type)
  (:nicknames :queue)
  (:shadow push)
  (:export make-queue
	   push
	   push-all
	   clear
	   front
	   empty?
	   each))
(in-package :igo.queue)

;;;;;;;;;;;
;;; declaim
(declaim #.igo::*optimize-fastest*
	 (inline resize push push-all clear front empty? make-queue)) 
	 
;;;;;;;;;;
;;; struct
(defstruct (queue (:type vector)
		  (:constructor make-queue (&aux (buf (make-array 16))))
		  (:conc-name ""))
  (buf #() :type simple-vector)
  (pos 0   :type array-index))

;;;;;;;;;;;;;;;;;;;;;
;;; internal function
(defun resize (queue new-size)
  (setf (buf queue) (adjust-array (buf queue) new-size)))

;;;;;;;;;;;;;;;;;;;;;
;;; external function
(defun push (elem queue &aux (buf (buf queue)) (pos (pos queue)))
  (declare #.igo::*optimize-fastest*)
  (when (= pos (length buf))
    (setf buf (resize queue (* pos 2))))
  (setf (aref buf pos) elem)
  (incf (pos queue)))

(defun push-all (que1 que2)
  (let ((new-pos (the array-index (+ (pos que1) (pos que2))))
	(buf1    (buf que1))
	(buf2    (buf que2)))
    (declare (simple-vector buf1 buf2))
    (when (>= new-pos (length buf2))
      (setf buf2 (resize que2 (the array-index (round (* new-pos 1.5))))))
    (setf (subseq buf2 (pos que2) new-pos) buf1
	  (pos que2) new-pos)))

(defmacro each ((var queue &optional (start 0)) &body body)
  (let ((i   (gensym))
	(buf (gensym))
	(que (gensym)))
    `(let* ((,que ,queue)
	    (,buf (buf ,que)))
       (loop FOR ,i FROM ,start BELOW (pos ,que)
	     FOR ,var = (aref ,buf ,i) DO
         ,@body))))

(defun clear (queue)
  (setf (pos queue) 0))

(defun front (queue)
  (aref (buf queue) 0))

(defun empty? (queue)
  (zerop (pos queue)))