/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: PhraseProperty.cpp 63 2011-05-21 01:19:01Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifdef _MSC_VER
#pragma warning(disable:4996)
#endif

#include "spcf/sapi/utils/PhraseProperty.hpp"

#include "spcf/sapi/utils/WChar2Char.hpp"

using namespace std;

namespace spcf {

	class PhraseProperty_i {
	public:
		string name_;
		bool hasVal_;
		long val_;
		bool hasValStr_;
		string valstr_;

	public:
		PhraseProperty_i();
		PhraseProperty_i(const string& name);
		PhraseProperty_i(const string& name, long val);
		PhraseProperty_i(const string& name, const string& valstr);
		PhraseProperty_i(const string& name, long val, const string& valstr);
		PhraseProperty_i(const string& name, bool hasVal, long val, bool hasValStr, const string& valstr);
	};

	PhraseProperty::PhraseProperty() : impl(new PhraseProperty_i()) {
	}

	PhraseProperty::PhraseProperty(const string& name) :
	impl(new PhraseProperty_i(name)) {
	}

	PhraseProperty::PhraseProperty(const string& name, long val) :
	impl(new PhraseProperty_i(name, val)) {
	}

	PhraseProperty::PhraseProperty(const string& name, const string& valstr) :
	impl(new PhraseProperty_i(name, valstr)) {
	}

	PhraseProperty::PhraseProperty(const string& name, long val, const string& valstr) :
	impl(new PhraseProperty_i(name, val, valstr)) {
	}

	PhraseProperty::~PhraseProperty() {
		delete impl;
	}

	PhraseProperty::operator bool() const {
		return !impl->name_.empty();
	}

	bool PhraseProperty::operator!() const {
		return impl->name_.empty();
	}

	const string& PhraseProperty::getName() const {
		return impl->name_;
	}

	bool PhraseProperty::hasVal() const {
		return impl->hasVal_;
	}

	long PhraseProperty::getVal() const {
		return impl->val_;
	}

	bool PhraseProperty::hasValStr() const {
		return impl->hasValStr_;
	}

	const string& PhraseProperty::getValStr() const {
		return impl->valstr_;
	}



	PhraseProperty_i::PhraseProperty_i() : name_(""), hasVal_(false), hasValStr_(false) {
	}

	PhraseProperty_i::PhraseProperty_i(const string& name) :
	name_(name), hasVal_(false), hasValStr_(false) {
	}

	PhraseProperty_i::PhraseProperty_i(const string& name, long val) :
	name_(name), hasVal_(true), val_(val), hasValStr_(false) {
	}

	PhraseProperty_i::PhraseProperty_i(const string& name, const string& valstr) :
	name_(name), hasVal_(false), hasValStr_(true), valstr_(valstr) {
	}

	PhraseProperty_i::PhraseProperty_i(const string& name, long val, const string& valstr) :
	name_(name), hasVal_(true), val_(val), hasValStr_(true), valstr_(valstr) {
	}

}  // namespace spcf
