/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: Controller.cpp 33 2011-05-11 13:08:26Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifdef _MSC_VER
#pragma warning(disable:4996)
#endif

#include "spcf/core/Controller.hpp"

#include "spcf/core/Context.hpp"
#include "spcf/core/Engine.hpp"
#include "spcf/core/Processor.hpp"
#include "spcf/core/View.hpp"

namespace spcf {

	class Controller_i {
	public:
		EnginePtr engine_;
		ProcessorPtr processor_;
		ViewPtr view_;
	};

	Controller::Controller() : impl(new Controller_i) {
	}

	Controller::~Controller() {
		Context context;

		if (impl->processor_) {
			impl->processor_->finish(context);
		}

		if (impl->view_) {
			impl->view_->finish(context);
		}

		if (impl->engine_) {
			impl->engine_->destroy();
		}
		delete impl;
	}

	const EnginePtr& Controller::getEngine() const {
		return impl->engine_;
	}

	void Controller::setEngine(const EnginePtr& engine) {
		if (impl->engine_) {
			impl->engine_->destroy();
		}

		engine->setController(*this);
		engine->init();
		impl->engine_ = engine;
	}

	const ProcessorPtr& Controller::getProcessor() const {
		return impl->processor_;
	}

	void Controller::setProcessor(const ProcessorPtr& processor) {
		if (impl->processor_) {
			Context context;

			impl->processor_->finish(context);
		}

		impl->processor_ = processor;
		impl->processor_->setController(*this);
	}

	const ViewPtr& Controller::getView() const {
		return impl->view_;
	}

	void Controller::setView(const ViewPtr& view) {
		if (impl->view_) {
			Context context;

			impl->view_->finish(context);
		}

		impl->view_ = view;
		impl->view_->setController(*this);
	}

	void Controller::start() {
		Context context;

		if (impl->processor_) {
			impl->processor_->start(context);
		}

		if (impl->view_) {
			impl->view_->start(context);
		}

		impl->engine_->start();
	}

	void Controller::stop() {
		Context context;

		impl->engine_->stop();

		if (impl->processor_) {
			impl->processor_->stop(context);
		}

		if (impl->view_) {
			impl->view_->stop(context);
		}
	}

	void Controller::soundStarted() {
		Context context;

		if (impl->processor_) {
			impl->processor_->soundStarted(context);
		}

		if (impl->view_) {
			impl->view_->soundStarted(context);
		}
	}

	void Controller::soundStoped() {
		Context context;

		if (impl->processor_) {
			impl->processor_->soundStoped(context);
		}

		if (impl->view_) {
			impl->view_->soundStoped(context);
		}
	}

	void Controller::recognized(Recognition& recognition) {
		Context context;

		if (impl->processor_) {
			impl->processor_->recognized(context, recognition);
		}

		if (impl->view_) {
			impl->view_->recognized(context, recognition);
		}
	}

}  // namespace spcf
