/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: Engine.hpp 14 2011-05-09 04:08:06Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _SPEECH_CONTROLLER_FRAMEWORK_CORE_ENGINE_HPP_
#define _SPEECH_CONTROLLER_FRAMEWORK_CORE_ENGINE_HPP_

#include <boost/shared_ptr.hpp>

namespace spcf {

	class Controller;
	class Grammar;
	typedef boost::shared_ptr<Grammar> GrammarPtr;

	class Engine_i;

	class Engine {
	private:
		Engine_i* impl;

	public:
		Engine();
		virtual ~Engine();

	private:
		Engine(const Engine& engine);
		Engine& operator=(const Engine& engine);

	public:
		void setController(Controller& controller);
		Controller& getController();

	public:
		virtual void init() = 0;
		virtual void start() = 0;
		virtual void stop() = 0;
		virtual void destroy() = 0;

	public:
		virtual void addGrammar(const GrammarPtr& grammar) = 0;
		virtual GrammarPtr getGrammar(const std::string& name) = 0;
		virtual GrammarPtr removeGrammar(const std::string& name) = 0;
		virtual void clearGrammar() = 0;
	};

}  // namespace spcf

#endif
