/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: NumericalGrammar.cpp 23 2011-05-10 02:25:55Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifdef _MSC_VER
#pragma warning(disable:4996)
#endif

#include "spcf/grammar/NumericalGrammar.hpp"

#include "spcf/core/GrammarPhrase.hpp"
#include "spcf/core/GrammarTransition.hpp"

#include <stdlib.h>

using namespace std;

namespace spcf {

	class NumericalGrammar_i {
	public:
		NumericalGrammar_i();

	public:
		void setGrammar(NumericalGrammar& self, const string* propertyName);

	public:
		GrammarPhrasePtr getGrammarPhrase(const string* propertyName, int number);
	};

	NumericalGrammar::NumericalGrammar(const string& name) :
			GrammarCommonImpl(name), impl(new NumericalGrammar_i()) {
		impl->setGrammar(*this, 0);
	}

	NumericalGrammar::NumericalGrammar(const string& name, const string& propertyName) :
			GrammarCommonImpl(name), impl(new NumericalGrammar_i()) {
		impl->setGrammar(*this, &propertyName);
	}

	NumericalGrammar::~NumericalGrammar() {
		delete impl;
	}

	NumericalGrammar_i::NumericalGrammar_i() {
	}

	void NumericalGrammar_i::setGrammar(NumericalGrammar& self, const string* propertyName) {
		for (int i = 0; i < 10; ++i) {
			self.addGrammarTransition(GrammarTransitionPtr(
				new GrammarTransition(getGrammarPhrase(propertyName, i),
					Grammar::START_STATE_NAME, Grammar::FINISH_STATE_NAME)));
		}
	}

	GrammarPhrasePtr NumericalGrammar_i::getGrammarPhrase(const string* propertyName, int number) {
		char buffer[3];
		itoa(number, buffer, 10);

		if (propertyName) {
			return GrammarPhrasePtr(new GrammarPhrase(buffer, *propertyName, number, buffer));
		} else {
			return GrammarPhrasePtr(new GrammarPhrase(buffer));
		}
	}

}  // namespace spcf
