#include "stdafx.h"
#include "GVOShipRoute.h"


GVOShipRoute::GVOShipRoute()
{
}


GVOShipRoute::~GVOShipRoute()
{
}


void GVOShipRoute::addRoutePoint( const GVONormalizedPoint & point )
{
	if ( m_lines.empty() ) {
		m_lines.push_back( Line() );
	}
	Line & line = m_lines.back();
	if ( line.empty() ) {
		line.push_back( point );
		return;
	}
	const GVONormalizedPoint & prevPoint = line.back();
	if ( prevPoint.isEqualValue( point ) ) {
		return;
	}

	// Eׂꍇ͐𕪊

	const float k_threshold = 0.5f;
	if ( prevPoint.x() < point.x() && (k_threshold <= (point.x() - prevPoint.x())) ) {
		// ɌČׂꍇ
		const GVONormalizedPoint leftSideSubPoint( point.x() - 1.0f, point.y() );
		const GVONormalizedPoint rightSideSubPoint( prevPoint.x() + 1.0f, prevPoint.y() );

		line.push_back( leftSideSubPoint );
		m_lines.emplace( m_lines.end(), std::move( Line{ rightSideSubPoint, point } ) );
	}
	else if ( point.x() < prevPoint.x() && (k_threshold <= (prevPoint.x() - point.x())) ) {
		// ɌČׂꍇ
		const GVONormalizedPoint rightSideSubPoint( point.x() + 1.0f, point.y() );
		const GVONormalizedPoint leftSideSubPoint( prevPoint.x() - 1.0f, prevPoint.y() );

		line.push_back( rightSideSubPoint );
		m_lines.emplace( m_lines.end(), std::move( Line{ leftSideSubPoint, point } ) );
	}
	else {
		line.push_back( point );
	}
}
