/*
 * Decompiled with CFR 0.152.
 */
package jp.co.olympus.camerakit;

import android.graphics.Point;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeoutException;
import jp.co.olympus.camerakit.OLYCamera;
import jp.co.olympus.camerakit.OLYCameraFileInfo;
import jp.co.olympus.camerakit.OLYCameraKitException;
import jp.co.olympus.camerakit.OLYCameraLog;
import jp.co.olympus.camerakit.g;
import jp.co.olympus.camerakit.h;
import jp.co.olympus.camerakit.internal.c;
import jp.co.olympus.camerakit.internal.d;
import jp.co.olympus.camerakit.internal.e;
import jp.co.olympus.camerakit.k;
import jp.co.olympus.camerakit.l;

public class OLYCameraPlaybackTrait {
    private OLYCamera.e a;

    protected OLYCameraPlaybackTrait(OLYCamera.e adapter) {
        if (adapter == null) {
            throw new NullPointerException();
        }
        if (!(adapter instanceof OLYCamera.e)) {
            throw new IllegalAccessError();
        }
        this.a = adapter;
    }

    public void downloadContentList(final OLYCamera.DownloadContentListCallback callback) {
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.c() && !this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Playback' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (callback == null) {
            // empty if block
        }
        this.a.a(new Runnable(){

            @Override
            public void run() {
                ArrayList<OLYCameraFileInfo> list = new ArrayList<OLYCameraFileInfo>();
                List<OLYCameraFileInfo> directoryList = null;
                try {
                    directoryList = OLYCameraPlaybackTrait.this.a.a(new OLYCamera.c<List<OLYCameraFileInfo>, h>(){

                        @Override
                        public List<OLYCameraFileInfo> a(h value) throws Exception {
                            return value.b("/DCIM", 10.0, null);
                        }
                    });
                }
                catch (Exception e2) {
                    OLYCameraKitException theException = new OLYCameraKitException(e2);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (directoryList == null) {
                    throw new AssertionError();
                }
                for (OLYCameraFileInfo directory : directoryList) {
                    if (directory.getFiletype() != OLYCameraFileInfo.Filetype.Directory) continue;
                    String dcfRoot = directory.getDirectoryPath();
                    String dcfDirectoryName = directory.getFilename();
                    final String dcfDirectoryPath = dcfRoot + "/" + dcfDirectoryName;
                    List<OLYCameraFileInfo> fileList = null;
                    try {
                        fileList = OLYCameraPlaybackTrait.this.a.a(new OLYCamera.c<List<OLYCameraFileInfo>, h>(){

                            @Override
                            public List<OLYCameraFileInfo> a(h value) throws Exception {
                                return value.b(dcfDirectoryPath, 10.0, null);
                            }
                        });
                    }
                    catch (Exception e3) {
                        OLYCameraKitException theException = new OLYCameraKitException(e3);
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        if (callback != null) {
                            callback.onErrorOccurred(theException);
                        }
                        return;
                    }
                    if (fileList == null) {
                        throw new AssertionError();
                    }
                    for (OLYCameraFileInfo file : fileList) {
                        if (file.getFiletype() != OLYCameraFileInfo.Filetype.File) continue;
                        list.add(file);
                    }
                }
                if (callback != null) {
                    callback.onCompleted(list);
                }
            }
        });
    }

    public void downloadContentThumbnail(final String path, final OLYCamera.DownloadImageCallback callback) {
        OLYCameraLog.i("path=%s", path);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.c() && !this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Playback' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (callback == null) {
            // empty if block
        }
        if (path == null || path.length() == 0) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'path' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        this.a.a(new Runnable(){

            @Override
            public void run() {
                if (callback != null) {
                    OLYCamera.ProgressEvent e2 = new OLYCamera.ProgressEvent(0.0f, true);
                    callback.onProgress(e2);
                    if (e2.a()) {
                        OLYCameraLog.w("Cancel downloading a thumbnail.", new Object[0]);
                        OLYCameraKitException theException = new OLYCameraKitException("Request is canceled by user action.");
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        if (callback != null) {
                            callback.onErrorOccurred(theException);
                        }
                        return;
                    }
                }
                jp.co.olympus.camerakit.internal.g thumbnail = null;
                try {
                    thumbnail = OLYCameraPlaybackTrait.this.a.a(new OLYCamera.c<jp.co.olympus.camerakit.internal.g, h>(){

                        @Override
                        public jp.co.olympus.camerakit.internal.g a(h value) throws Exception {
                            return value.c(path, 10.0, new l(){

                                @Override
                                public void a(k e2) {
                                    if (callback != null) {
                                        OLYCamera.ProgressEvent progressEvent = new OLYCamera.ProgressEvent(e2.b(), e2.c());
                                        callback.onProgress(progressEvent);
                                        if (progressEvent.a()) {
                                            OLYCameraLog.w("Cancel downloading a thumbnail.", new Object[0]);
                                            e2.e();
                                        }
                                    }
                                }
                            });
                        }
                    });
                }
                catch (Exception e3) {
                    OLYCameraKitException theException = new OLYCameraKitException(e3);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (thumbnail == null) {
                    throw new AssertionError();
                }
                if (callback != null) {
                    OLYCamera.ProgressEvent e4 = new OLYCamera.ProgressEvent(1.0f, true);
                    callback.onProgress(e4);
                    if (e4.a()) {
                        OLYCameraLog.w("Cancel downloading a thumbnail.", new Object[0]);
                        OLYCameraKitException theException = new OLYCameraKitException("Request is canceled by user action.");
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        if (callback != null) {
                            callback.onErrorOccurred(theException);
                        }
                        return;
                    }
                }
                if (callback != null) {
                    callback.onCompleted(thumbnail.a(), thumbnail.b());
                }
            }
        });
    }

    public void downloadContentScreennail(final String path, final OLYCamera.DownloadImageCallback callback) {
        OLYCameraLog.i("path=%s", path);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Playback' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (callback == null) {
            // empty if block
        }
        if (path == null || path.length() == 0) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'path' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        this.a.a(new Runnable(){

            @Override
            public void run() {
                if (callback != null) {
                    OLYCamera.ProgressEvent e2 = new OLYCamera.ProgressEvent(0.0f, true);
                    callback.onProgress(e2);
                    if (e2.a()) {
                        OLYCameraLog.w("Cancel downloading a reduced image.", new Object[0]);
                        OLYCameraKitException theException = new OLYCameraKitException("Request is canceled by user action.");
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        if (callback != null) {
                            callback.onErrorOccurred(theException);
                        }
                        return;
                    }
                }
                jp.co.olympus.camerakit.internal.g screennail = null;
                try {
                    screennail = OLYCameraPlaybackTrait.this.a.a(new OLYCamera.c<jp.co.olympus.camerakit.internal.g, h>(){

                        @Override
                        public jp.co.olympus.camerakit.internal.g a(h value) throws Exception {
                            return value.d(path, 10.0, new l(){

                                @Override
                                public void a(k e2) {
                                    if (callback != null) {
                                        OLYCamera.ProgressEvent progressEvent = new OLYCamera.ProgressEvent(e2.b(), e2.c());
                                        callback.onProgress(progressEvent);
                                        if (progressEvent.a()) {
                                            OLYCameraLog.w("Cancel downloading a reduced image.", new Object[0]);
                                            e2.e();
                                        }
                                    }
                                }
                            });
                        }
                    });
                }
                catch (Exception e3) {
                    OLYCameraKitException theException = new OLYCameraKitException(e3);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (screennail == null) {
                    throw new AssertionError();
                }
                if (callback != null) {
                    OLYCamera.ProgressEvent e4 = new OLYCamera.ProgressEvent(1.0f, true);
                    callback.onProgress(e4);
                    if (e4.a()) {
                        OLYCameraLog.w("Cancel downloading a reduced image.", new Object[0]);
                        OLYCameraKitException theException = new OLYCameraKitException("Request is canceled by user action.");
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        if (callback != null) {
                            callback.onErrorOccurred(theException);
                        }
                        return;
                    }
                }
                if (callback != null) {
                    callback.onCompleted(screennail.a(), screennail.b());
                }
            }
        });
    }

    public void downloadImage(final String path, final float resize, final OLYCamera.DownloadImageCallback callback) {
        OLYCameraLog.i("path=%s, resize=%s", path, resize == Float.MAX_VALUE ? "none" : String.format("%f", Float.valueOf(resize)));
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.c() && !this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Playback' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (callback == null) {
            // empty if block
        }
        if (path == null || path.length() == 0) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'path' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!new ArrayList<Float>(){
            private static final long b = 8497083491877445835L;
            {
                this.add(Float.valueOf(1024.0f));
                this.add(Float.valueOf(1600.0f));
                this.add(Float.valueOf(1920.0f));
                this.add(Float.valueOf(2048.0f));
                this.add(Float.valueOf(Float.MAX_VALUE));
            }
        }.contains(Float.valueOf(resize))) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'resize' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (this.a.d() && resize != Float.MAX_VALUE) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'resize' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        class A {
            boolean a = false;

            A() {
            }
        }
        final A box = new A();
        if (this.a.c()) {
            box.a = true;
        }
        this.a.a(new Runnable(){
            {
            }

            @Override
            public void run() {
                jp.co.olympus.camerakit.internal.g image = null;
                try {
                    image = resize == Float.MAX_VALUE ? OLYCameraPlaybackTrait.this.a.a(new OLYCamera.c<jp.co.olympus.camerakit.internal.g, h>(){

                        @Override
                        public jp.co.olympus.camerakit.internal.g a(h value) throws Exception {
                            return value.a(path, box.a, 60.0, new l(){

                                @Override
                                public void a(k e2) {
                                    if (callback != null) {
                                        OLYCamera.ProgressEvent progressEvent = new OLYCamera.ProgressEvent(e2.b(), e2.c());
                                        callback.onProgress(progressEvent);
                                        if (progressEvent.a()) {
                                            OLYCameraLog.w("Cancel downloading an image.", new Object[0]);
                                            e2.e();
                                        }
                                    }
                                }
                            });
                        }
                    }) : OLYCameraPlaybackTrait.this.a.a(new OLYCamera.c<jp.co.olympus.camerakit.internal.g, h>(){

                        @Override
                        public jp.co.olympus.camerakit.internal.g a(h value) throws Exception {
                            return value.a(path, resize, 10.0, new l(){

                                @Override
                                public void a(k e2) {
                                    if (callback != null) {
                                        OLYCamera.ProgressEvent progressEvent = new OLYCamera.ProgressEvent(e2.b(), e2.c());
                                        callback.onProgress(progressEvent);
                                        if (progressEvent.a()) {
                                            OLYCameraLog.w("Cancel downloading an image.", new Object[0]);
                                            e2.e();
                                        }
                                    }
                                }
                            });
                        }
                    });
                }
                catch (Exception e2) {
                    OLYCameraKitException theException = new OLYCameraKitException(e2);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (image == null) {
                    throw new AssertionError();
                }
                if (callback != null) {
                    callback.onCompleted(image.a(), image.b());
                }
            }
        });
    }

    public void downloadContent(final String path, final OLYCamera.DownloadContentCallback callback) {
        OLYCameraLog.i("path=%s", path);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Playback' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (callback == null) {
            // empty if block
        }
        if (path == null || path.length() == 0) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'path' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        class B {
            boolean a = false;

            B() {
            }
        }
        final B box = new B();
        if (path.toLowerCase(Locale.ENGLISH).endsWith(".jpg") || path.toLowerCase(Locale.ENGLISH).endsWith(".orf")) {
            box.a = true;
        }
        this.a.a(new Runnable(){
            {
            }

            @Override
            public void run() {
                jp.co.olympus.camerakit.internal.g image = null;
                try {
                    image = OLYCameraPlaybackTrait.this.a.a(new OLYCamera.c<jp.co.olympus.camerakit.internal.g, h>(){

                        @Override
                        public jp.co.olympus.camerakit.internal.g a(h value) throws Exception {
                            return value.a(path, box.a, 60.0, new l(){

                                @Override
                                public void a(k e2) {
                                    if (callback != null) {
                                        OLYCamera.ProgressEvent progressEvent = new OLYCamera.ProgressEvent(e2.b(), e2.c());
                                        callback.onProgress(progressEvent);
                                        if (progressEvent.a()) {
                                            OLYCameraLog.w("Cancel downloading a file.", new Object[0]);
                                            e2.e();
                                        }
                                    }
                                }
                            });
                        }
                    });
                }
                catch (Exception e2) {
                    OLYCameraKitException theException = new OLYCameraKitException(e2);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (image == null) {
                    throw new AssertionError();
                }
                if (callback != null) {
                    callback.onCompleted(image.a());
                }
            }
        });
    }

    public void downloadLargeContent(final String path, final OLYCamera.DownloadLargeContentCallback callback) {
        OLYCameraLog.i("path=%s", path);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Playback' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (callback == null) {
            // empty if block
        }
        if (path == null || path.length() == 0) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'path' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        this.a.a(new Runnable(){

            @Override
            public void run() {
                try {
                    OLYCameraPlaybackTrait.this.a.a(new OLYCamera.c<Void, h>(){

                        @Override
                        public Void a(h value) throws Exception {
                            value.a(path, 60.0, new l(){

                                @Override
                                public void a(k e2) {
                                    if (callback == null) {
                                        return;
                                    }
                                    byte[] data = e2.a();
                                    OLYCamera.ProgressEvent progressEvent = new OLYCamera.ProgressEvent(e2.b(), e2.c());
                                    callback.onProgress(data, progressEvent);
                                    if (progressEvent.a()) {
                                        OLYCameraLog.w("Cancel downloading a file.", new Object[0]);
                                        e2.e();
                                    }
                                }
                            });
                            return null;
                        }
                    });
                }
                catch (Exception e2) {
                    OLYCameraKitException theException = new OLYCameraKitException(e2);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (callback != null) {
                    callback.onCompleted();
                }
            }
        });
    }

    public int countNumberOfContents() throws OLYCameraKitException {
        int numberOfDcf;
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.c() && !this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Playback' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            numberOfDcf = this.a.a(new OLYCamera.c<Integer, h>(){

                @Override
                public Integer a(h value) throws Exception {
                    return value.F(10.0);
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            OLYCameraLog.w("The value that the mothod returns is not trusted.", new Object[0]);
            throw theException;
        }
        return numberOfDcf;
    }

    public Map<String, Object> inquireContentInformation(final String path) throws OLYCameraKitException {
        Map<String, Object> contentInfo;
        OLYCameraLog.i("path=%s", path);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Playback' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (path == null || path.length() == 0) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'path' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        final boolean isMovie = path.endsWith(".mov") || path.endsWith(".MOV");
        try {
            contentInfo = this.a.a(new OLYCamera.c<Map<String, Object>, h>(){

                @Override
                public Map<String, Object> a(h value) throws Exception {
                    if (isMovie) {
                        return value.d(path, 10.0);
                    }
                    return value.i(path, 10.0);
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (contentInfo == null) {
            throw new AssertionError();
        }
        return contentInfo;
    }

    public void uploadImage(final byte[] imageData, final int imageWidth, final int imageHeight, final Date createdDate, final Date modifiedDate, final OLYCamera.ProgressCallback callback) {
        OLYCameraLog.i("imageData=%d, imageWidth=%d, imageHeight=%d, createdDate=%s, modifiedDate=%s", imageData != null ? imageData.length : 0, imageWidth, imageHeight, createdDate, modifiedDate);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Playback' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (callback == null) {
            // empty if block
        }
        if (imageData == null || imageData.length == 0) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'imageData' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (imageWidth <= 0) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'imageWidth' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (imageHeight <= 0) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'imageHeight' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (createdDate == null) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'createdDate' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (modifiedDate == null) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'modifiedDate' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        this.a.a(new Runnable(){

            @Override
            public void run() {
                e eventQueue = OLYCameraPlaybackTrait.this.a.i();
                eventQueue.a();
                Map<String, Object> result = null;
                try {
                    result = OLYCameraPlaybackTrait.this.a.a(new OLYCamera.c<Map<String, Object>, h>(){

                        @Override
                        public Map<String, Object> a(h value) throws Exception {
                            return value.R(10.0);
                        }
                    });
                }
                catch (Exception e2) {
                    OLYCameraKitException theException = new OLYCameraKitException(e2);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (result == null) {
                    throw new AssertionError();
                }
                int maxdatasize = Integer.parseInt((String)result.get("maxdatasize"));
                if (imageData.length > maxdatasize) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'imageDsata' is invalid.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                Point maxResolution = g.d((String)result.get("maxresolution"));
                if (maxResolution == null) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (imageWidth > maxResolution.x || imageHeight > maxResolution.y) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The value for parameters 'imageWidth' and 'imageHeight' are invalid.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                int writableQuantity = 0;
                try {
                    writableQuantity = OLYCameraPlaybackTrait.this.a.a(new OLYCamera.c<Integer, h>(){

                        @Override
                        public Integer a(h value) throws Exception {
                            return value.f(imageData.length, 10.0);
                        }
                    });
                }
                catch (Exception e3) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException(e3);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (writableQuantity <= 0) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("Uploading any image is not permitted.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                try {
                    OLYCameraPlaybackTrait.this.a.a(new OLYCamera.c<Void, h>(){

                        @Override
                        public Void a(h value) throws Exception {
                            value.a(imageData, createdDate, modifiedDate, TimeZone.getDefault(), 60.0);
                            return null;
                        }
                    });
                }
                catch (Exception e4) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException(e4);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                long timeoutInMillis = 10000L;
                jp.co.olympus.camerakit.internal.c event = null;
                try {
                    event = eventQueue.a(timeoutInMillis);
                    while (event != null && event.a() != c.a.t) {
                        if (event != null && event.a() == c.a.m) {
                            float progress = ((d.f)event.c()).a();
                            if (callback != null) {
                                callback.onProgress(new OLYCamera.ProgressEvent(progress, false));
                            }
                        }
                        event = eventQueue.a(timeoutInMillis);
                    }
                }
                catch (TimeoutException e5) {
                    event = null;
                }
                if (event == null) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera did not respond in time.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                Map<String, Object> cameraStatus = null;
                try {
                    cameraStatus = OLYCameraPlaybackTrait.this.a.a(new OLYCamera.c<Map<String, Object>, h>(){

                        @Override
                        public Map<String, Object> a(h value) throws Exception {
                            return value.H(10.0);
                        }
                    });
                }
                catch (Exception e6) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException(e6);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                OLYCameraPlaybackTrait.this.a.e().updateWithCommandResultOfGetState(cameraStatus);
                eventQueue.b();
                if (callback != null) {
                    callback.onCompleted();
                }
            }
        });
    }

    public void developRawImage(final String path, final String parameters, final boolean preview, final OLYCamera.DownloadImageCallback callback) {
        OLYCameraLog.i("path=%s, parameters=%s, preview=%s", path, parameters, String.valueOf(preview));
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Playback' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (callback == null) {
            // empty if block
        }
        if (path == null || path.length() == 0) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'path' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (parameters == null) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'parameterss' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        this.a.a(new Runnable(){

            @Override
            public void run() {
                e eventQueue = OLYCameraPlaybackTrait.this.a.f();
                eventQueue.a();
                try {
                    OLYCameraPlaybackTrait.this.a.a(new OLYCamera.c<Void, h>(){

                        @Override
                        public Void a(h value) throws Exception {
                            value.a(path, parameters, preview, 10.0);
                            return null;
                        }
                    });
                }
                catch (Exception e2) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException(e2);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                long timeoutInMillis = 10000L;
                jp.co.olympus.camerakit.internal.c event = null;
                try {
                    event = eventQueue.a(timeoutInMillis);
                    while (event != null && event.a() != c.a.p) {
                        if (event != null && event.a() == c.a.m) {
                            float progress = ((d.f)event.c()).a();
                            if (callback != null) {
                                callback.onProgress(new OLYCamera.ProgressEvent(progress, false));
                            }
                        }
                        event = eventQueue.a(timeoutInMillis);
                    }
                }
                catch (TimeoutException e3) {
                    event = null;
                }
                if (event == null) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera did not respond in time.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                Map<String, Object> cameraStatus = null;
                try {
                    cameraStatus = OLYCameraPlaybackTrait.this.a.a(new OLYCamera.c<Map<String, Object>, h>(){

                        @Override
                        public Map<String, Object> a(h value) throws Exception {
                            return value.H(10.0);
                        }
                    });
                }
                catch (Exception e4) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException(e4);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                OLYCameraPlaybackTrait.this.a.e().updateWithCommandResultOfGetState(cameraStatus);
                jp.co.olympus.camerakit.internal.g image = null;
                if (preview) {
                    try {
                        image = OLYCameraPlaybackTrait.this.a.a(new OLYCamera.c<jp.co.olympus.camerakit.internal.g, h>(){

                            @Override
                            public jp.co.olympus.camerakit.internal.g a(h value) throws Exception {
                                return value.K(10.0);
                            }
                        });
                    }
                    catch (Exception e5) {
                        eventQueue.b();
                        OLYCameraKitException theException = new OLYCameraKitException(e5);
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        if (callback != null) {
                            callback.onErrorOccurred(theException);
                        }
                        return;
                    }
                }
                eventQueue.b();
                if (callback != null) {
                    if (image != null) {
                        callback.onCompleted(image.a(), image.b());
                    } else {
                        callback.onCompleted(null, null);
                    }
                }
            }
        });
    }

    public void mergeVideoClips(final String parameters, final OLYCamera.ProgressCallback callback) {
        OLYCameraLog.i("parameters=%s", parameters);
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Playback' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (callback == null) {
            // empty if block
        }
        if (parameters == null) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'parameterss' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        this.a.a(new Runnable(){

            @Override
            public void run() {
                e eventQueue = OLYCameraPlaybackTrait.this.a.g();
                if (callback != null) {
                    OLYCamera.ProgressEvent e2 = new OLYCamera.ProgressEvent(0.0f, true);
                    callback.onProgress(e2);
                    if (e2.a()) {
                        OLYCameraLog.w("Cancel resizing video frame.", new Object[0]);
                        OLYCameraKitException theException = new OLYCameraKitException("Request is canceled by user action.");
                        callback.onErrorOccurred(theException);
                        return;
                    }
                }
                boolean isCanceled = false;
                eventQueue.a();
                try {
                    OLYCameraPlaybackTrait.this.a.a(new OLYCamera.c<Void, h>(){

                        @Override
                        public Void a(h value) throws Exception {
                            value.e(parameters, 10.0);
                            return null;
                        }
                    });
                }
                catch (Exception e3) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException(e3);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                long timeoutInMillis = 180000L;
                jp.co.olympus.camerakit.internal.c event = null;
                try {
                    event = eventQueue.a(timeoutInMillis);
                    while (event != null && event.a() != c.a.s) {
                        if (event != null && event.a() == c.a.m && !isCanceled) {
                            float progress = ((d.f)event.c()).a();
                            OLYCamera.ProgressEvent progressEvent = new OLYCamera.ProgressEvent(progress, true);
                            callback.onProgress(progressEvent);
                            if (progressEvent.a()) {
                                try {
                                    OLYCameraPlaybackTrait.this.a.a(new OLYCamera.c<Void, h>(){

                                        @Override
                                        public Void a(h value) throws Exception {
                                            value.P(10.0);
                                            return null;
                                        }
                                    });
                                    isCanceled = true;
                                }
                                catch (Exception e4) {
                                    // empty catch block
                                }
                            }
                        }
                        event = eventQueue.a(timeoutInMillis);
                    }
                }
                catch (TimeoutException e5) {
                    event = null;
                }
                if (event == null) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera did not respond in time.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                Map<String, Object> cameraStatus = null;
                try {
                    cameraStatus = OLYCameraPlaybackTrait.this.a.a(new OLYCamera.c<Map<String, Object>, h>(){

                        @Override
                        public Map<String, Object> a(h value) throws Exception {
                            return value.H(10.0);
                        }
                    });
                }
                catch (Exception e6) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException(e6);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                OLYCameraPlaybackTrait.this.a.e().updateWithCommandResultOfGetState(cameraStatus);
                eventQueue.b();
                if (isCanceled) {
                    OLYCameraLog.w("Cancel editing video frame.", new Object[0]);
                    if (callback != null) {
                        OLYCameraKitException theException = new OLYCameraKitException("Request is canceled by user action.");
                        callback.onErrorOccurred(theException);
                    }
                } else if (callback != null) {
                    callback.onCompleted();
                }
            }
        });
    }

    public void resizeVideoFrame(final String path, final float resize, c quality, final OLYCamera.ProgressCallback callback) {
        OLYCameraLog.i("path=%s, resize=%f, quality=%s", new Object[]{path, Float.valueOf(resize), quality});
        if (!this.a.a()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Playback' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (resize != 1280.0f) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'resize' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (callback == null) {
            // empty if block
        }
        if (path == null || path.length() == 0) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'path' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if ((double)resize < 1.0 || resize > 1920.0f) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'resize' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        final String qualityParam = (String)new EnumMap<c, String>(c.class){
            {
                this.put(c.a, "fine");
                this.put(c.b, "normal");
            }
        }.get((Object)quality);
        if (qualityParam == null) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'quality' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        this.a.a(new Runnable(){

            @Override
            public void run() {
                e eventQueue = OLYCameraPlaybackTrait.this.a.h();
                boolean isCanceled = false;
                eventQueue.a();
                try {
                    OLYCameraPlaybackTrait.this.a.a(new OLYCamera.c<Void, h>(){

                        @Override
                        public Void a(h value) throws Exception {
                            value.a(path, resize, qualityParam, 10.0);
                            return null;
                        }
                    });
                }
                catch (Exception e2) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException(e2);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                long timeoutInMillis = 180000L;
                jp.co.olympus.camerakit.internal.c event = null;
                try {
                    event = eventQueue.a(timeoutInMillis);
                    while (event != null && event.a() != c.a.s) {
                        if (event != null && event.a() == c.a.m || !isCanceled) {
                            float progress = ((d.f)event.c()).a();
                            OLYCamera.ProgressEvent progressEvent = new OLYCamera.ProgressEvent(progress, true);
                            callback.onProgress(progressEvent);
                            if (progressEvent.a()) {
                                try {
                                    OLYCameraPlaybackTrait.this.a.a(new OLYCamera.c<Void, h>(){

                                        @Override
                                        public Void a(h value) throws Exception {
                                            value.Q(10.0);
                                            return null;
                                        }
                                    });
                                    isCanceled = true;
                                }
                                catch (Exception e3) {
                                    // empty catch block
                                }
                            }
                        }
                        event = eventQueue.a(timeoutInMillis);
                    }
                }
                catch (TimeoutException e4) {
                    event = null;
                }
                if (event == null) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera did not respond in time.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                Map<String, Object> cameraStatus = null;
                try {
                    cameraStatus = OLYCameraPlaybackTrait.this.a.a(new OLYCamera.c<Map<String, Object>, h>(){

                        @Override
                        public Map<String, Object> a(h value) throws Exception {
                            return value.H(10.0);
                        }
                    });
                }
                catch (Exception e5) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException(e5);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                OLYCameraPlaybackTrait.this.a.e().updateWithCommandResultOfGetState(cameraStatus);
                eventQueue.b();
                if (isCanceled) {
                    OLYCameraLog.w("Cancel resizing video frame.", new Object[0]);
                    if (callback != null) {
                        OLYCameraKitException theException = new OLYCameraKitException("Request is canceled by user action.");
                        callback.onErrorOccurred(theException);
                    }
                } else if (callback != null) {
                    callback.onCompleted();
                }
            }
        });
    }

    public static final class c
    extends Enum<c> {
        public static final /* enum */ c a = new c();
        public static final /* enum */ c b = new c();
        private static final /* synthetic */ c[] c;

        public static c[] a() {
            return (c[])c.clone();
        }

        public static c a(String name) {
            return Enum.valueOf(c.class, name);
        }

        static {
            c = new c[]{a, b};
        }
    }
}

