/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbLinkbaseLocatorDAO {

    // singleton쐬
    private static XbLinkbaseLocatorDAO instance = new XbLinkbaseLocatorDAO();
    // Connectionϐ
    private Connection conn = null;

    // RXgN^
    public XbLinkbaseLocatorDAO() {
    }

    // CX^X擾
    public static XbLinkbaseLocatorDAO getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    protected int insert(XbLinkbaseLocatorObj obj) throws XbException {
        final String query = "insert into xb_linkbase_locator values (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = null;

        try {
            // SQLݒ
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setLong(index++, obj.getLocator_id());
            stmt.setLong(index++, obj.getLinkbaseref_id());
            stmt.setString(index++, obj.getLoc_href());
            stmt.setString(index++, obj.getLoc_identifier());
            stmt.setString(index++, obj.getLoc_label());
            stmt.setString(index++, obj.getLoc_title());
            stmt.setString(index++, obj.getLoc_role());

            // SQL@s
            int count = stmt.executeUpdate();

            return count;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}