/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbLinkbaseArcDAO {

    // singleton쐬
    private static XbLinkbaseArcDAO instance = new XbLinkbaseArcDAO();
    // Connectionϐ
    private Connection conn = null;

    // RXgN^
    private XbLinkbaseArcDAO() {
    }

    // CX^X擾
    public static XbLinkbaseArcDAO getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    protected int insert(XbLinkbaseArcObj obj) throws XbException {
        final String query = "insert into xb_linkbase_arc values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = null;

        try {
            // SQLݒ
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setLong(index++, obj.getArc_id());
            stmt.setLong(index++, obj.getLinkbaseref_id());
            stmt.setString(index++, obj.getArc_show());
            stmt.setString(index++, obj.getArc_title());
            stmt.setString(index++, obj.getArc_from());
            stmt.setString(index++, obj.getArc_to());
            stmt.setString(index++, obj.getArc_arcrole());
            stmt.setString(index++, obj.getArc_use());
            stmt.setLong(index++, obj.getArc_priority());
            stmt.setDouble(index++, obj.getCalculation_weight());
            stmt.setDouble(index++, obj.getPresentation_order());

            // SQL@s
            int count = stmt.executeUpdate();

            return count;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}