/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

import jp.co.going.xbrl.common.XbException;

/**
 * h^caɓo^NX
 * 
 * @author Going Dot Com Inc.
 */
class XbItemTypeDAO {
    // singleton쐬
    private static final XbItemTypeDAO instance = new XbItemTypeDAO();
    // Connectionϐ
    private Connection conn = null;

    // RXgN^
    private XbItemTypeDAO() {
    }

    // CX^X擾
    protected static synchronized XbItemTypeDAO getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    private int getCount(String strTypeName, String strVerSion) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // CXg
            int relist = 0;
            strb_sql.append("select ");
            strb_sql.append("type_name, ");
            strb_sql.append("attribute_name, ");
            strb_sql.append("specification_no, ");
            strb_sql.append("creation_date ");
            strb_sql.append("from xb_item_type ");
            strb_sql.append("where type_name = ? ");
            strb_sql.append("and specification_no = ?");
            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());
            int index = 1;
            stmt.setString(index++, strTypeName);
            stmt.setString(index++, strVerSion);

            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                relist++;
            }
            // ʃZbgN[Y
            rs.close();
            // Xe[ggN[Y
            stmt.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        }
    }

    private String getContextType(String strTypeName, String strVerSion) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // CXg
            String type = "";
            strb_sql.append("select ");
            strb_sql.append("attribute_name ");
            strb_sql.append("from xb_item_type ");
            strb_sql.append("where type_name = ? ");
            strb_sql.append("and specification_no = ?");
            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());
            int index = 1;
            stmt.setString(index++, strTypeName);
            stmt.setString(index++, strVerSion);

            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                type = rs.getString("attribute_name");
                rs.close();
                stmt.close();
            } else {
                rs.close();
                stmt.close();
                throw new XbException("Io[Wɑ݂Ȃ^`Ă܂B");
            }

            return type;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        }
    }

    protected void insert(String name, String type, String spec, Date date) throws XbException {
        final String query = "insert into xb_item_type values (?, ?, ?, ?)";
        PreparedStatement stmt = null;

        try {
            // d`FbN
            int count = this.getCount(name, spec);
            // itemo^
            if (count == 0) {
                stmt = conn.prepareStatement(query);

                // contextType擾
                String contextType = this.getContextType(type, spec);

                // SQLݒ
                int index = 1;
                stmt.setString(index++, name);
                stmt.setString(index++, contextType);
                stmt.setString(index++, spec);
                stmt.setTimestamp(index++, new java.sql.Timestamp(date.getTime()));
                // SQL@s
                stmt.executeUpdate();
            }
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}