/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbItemTopDAO {

    // singleton쐬
    private static XbItemTopDAO instance = new XbItemTopDAO();
    // Connectionϐ
    private Connection conn = null;

    // RXgN^
    private XbItemTopDAO() {
    }

    // CX^X擾
    public static synchronized XbItemTopDAO getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    private ArrayList<XbItemTopObj> getItemTop(long grpId) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();

            strb_sql.append("select ");
            strb_sql.append("la.taxonomy_group_id as taxonomy_group_id, ");
            strb_sql.append("la.taxonomy_item_id as taxonomy_item_id, ");
            strb_sql.append("la.label_lang as item_lang, ");
            strb_sql.append("la.resource_value as item_name ");
            strb_sql.append("from ");
            strb_sql.append("xb_item_label la, ");
            strb_sql.append("(select ");
            strb_sql.append("wk1.taxonomy_group_id, ");
            strb_sql.append("wk1.parent_taxonomy_item_id as parent_taxonomy_item_id ");
            strb_sql.append("from xb_item_work wk1 ");
            strb_sql.append("where not exists ( ");
            strb_sql.append("select wk2.taxonomy_item_id ");
            strb_sql.append("from xb_item_work wk2 ");
            strb_sql.append("where wk2.taxonomy_item_id = wk1.parent_taxonomy_item_id) ");
            strb_sql.append("group by wk1.taxonomy_group_id,wk1.parent_taxonomy_item_id) top ");
            strb_sql.append("where la.taxonomy_group_id = ? ");
            strb_sql.append("and top.parent_taxonomy_item_id = la.taxonomy_item_id");

            // Xe[gg쐬
            stmt = conn.prepareStatement(strb_sql.toString());
            stmt.setLong(1, grpId);

            ResultSet rs = stmt.executeQuery();
            ArrayList<XbItemTopObj> relist = new ArrayList<XbItemTopObj>();
            while (rs.next()) {
                XbItemTopObj Obj = new XbItemTopObj();
                Obj.setTaxonomyGroupId(rs.getLong("taxonomy_group_id"));
                Obj.setTaxonomyItemId(rs.getLong("taxonomy_item_id"));
                Obj.setLang(rs.getString("item_lang"));
                Obj.setValue(rs.getString("item_name"));
                relist.add(Obj);
            }
            // ʃZbgN[Y
            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    private void insert(ArrayList<XbItemTopObj> obj) throws XbException {
        final String query = "insert into xb_item_top (taxonomy_group_id, taxonomy_item_id, item_lang, item_name) values (?, ?, ?, ?)";
        PreparedStatement stmt = null;

        try {
            // SQLݒ
            stmt = conn.prepareStatement(query);

            for (int i = 0; i < obj.size(); i++) {
                XbItemTopObj label = obj.get(i);

                int index = 1;
                stmt.setLong(index++, label.getTaxonomyGroupId());
                stmt.setLong(index++, label.getTaxonomyItemId());
                stmt.setString(index++, label.getLang());
                stmt.setString(index++, label.getValue());

                // SQL@s
                stmt.executeUpdate();
            }
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    // Xe[ggN[Y
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    protected ArrayList<XbItemTopObj> setItemTop(long grpId) throws XbException {
        // TOPACe擾
        ArrayList<XbItemTopObj> itemTop = this.getItemTop(grpId);
        // TOPACeo^
        this.insert(itemTop);

        return itemTop;
    }
}