/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.sample.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.sample.dao.obj.XbUnitMeasureObj;

/**
 * @author Masako Okayasu
 */
public class XbUnitMeasureDao {

    // singleton쐬
    private static XbUnitMeasureDao instance = new XbUnitMeasureDao();
    // Connectionϐ
    private Connection conn = null;

    // e[u
    private String table1 = "xb_unit_measure";
    private String table2 = "xb_measure";

    // RXgN^
    public XbUnitMeasureDao() {
    }

    // CX^X擾
    public static synchronized XbUnitMeasureDao getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    public void insert(XbUnitMeasureObj obj) throws XbException {
        final String query = "insert into xb_unit_measure values (?, ?, ?, ?)";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setLong(index++, obj.getUnit_id());
            stmt.setLong(index++, obj.getMeasure_id());
            stmt.setLong(index++, obj.getPresentation_order());
            stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreation_date().getTime()));

            // SQL@s
            stmt.executeUpdate();
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public ArrayList<XbUnitMeasureObj> selectAll(long unit_id) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("unit_id, ");
            strb_sql.append(table1 + ".measure_id, ");
            strb_sql.append("measure_name, ");
            strb_sql.append("money_flag, ");
            strb_sql.append("value, ");
            strb_sql.append("presentation_order, ");
            strb_sql.append(table1 + ".creation_date ");
            strb_sql.append("from " + table1 + ", " + table2 + " ");
            strb_sql.append("where unit_id=? ");
            strb_sql.append("and " + table1 + ".measure_id=" + table2 + ".measure_id ");
            strb_sql.append("order by presentation_order, ");
            strb_sql.append(table1 + ".measure_id ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setLong(index++, unit_id);

            ResultSet rs = stmt.executeQuery();
            ArrayList<XbUnitMeasureObj> relist = new ArrayList<XbUnitMeasureObj>();
            while (rs.next()) {
                XbUnitMeasureObj obj = new XbUnitMeasureObj();
                obj.setUnit_id(rs.getLong("unit_id"));
                obj.setMeasure_id(rs.getLong("measure_id"));
                obj.setMeasure_name(rs.getString("measure_name"));
                obj.setMoney_flag(rs.getShort("money_flag"));
                obj.setValue(rs.getString("value"));
                obj.setPresentation_order(rs.getInt("presentation_order"));
                obj.setCreation_date(rs.getDate("creation_date"));
                relist.add(obj);
            }

            // ʃZbgN[Y
            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public XbUnitMeasureObj select(long unit_id, long measure_id) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("unit_id, ");
            strb_sql.append(table1 + ".measure_id, ");
            strb_sql.append("measure_name, ");
            strb_sql.append("money_flag, ");
            strb_sql.append("value, ");
            strb_sql.append("presentation_order, ");
            strb_sql.append(table1 + ".creation_date ");
            strb_sql.append("from " + table1 + ", " + table2 + " ");
            strb_sql.append("where unit_id=? ");
            strb_sql.append("and " + table1 + ".measure_id=? ");
            strb_sql.append("and " + table1 + ".measure_id=" + table2 + ".measure_id ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setLong(index++, unit_id);
            stmt.setLong(index++, measure_id);

            ResultSet rs = stmt.executeQuery();
            XbUnitMeasureObj obj = null;
            while (rs.next()) {
                obj = new XbUnitMeasureObj();
                obj.setUnit_id(rs.getLong("unit_id"));
                obj.setMeasure_id(rs.getLong("measure_id"));
                obj.setMeasure_name(rs.getString("measure_name"));
                obj.setMoney_flag(rs.getShort("money_flag"));
                obj.setValue(rs.getString("value"));
                obj.setPresentation_order(rs.getInt("presentation_order"));
                obj.setCreation_date(rs.getDate("creation_date"));
            }

            // ʃZbgN[Y
            rs.close();

            return obj;
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}