/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.sample.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.sample.dao.obj.XbUnitDivideObj;

/**
 * @author Masako Okayasu
 */
public class XbUnitDivideDao {

    // singleton쐬
    private static XbUnitDivideDao instance = new XbUnitDivideDao();
    // Connectionϐ
    private Connection conn = null;

    // RXgN^
    public XbUnitDivideDao() {
    }

    // CX^X擾
    public static synchronized XbUnitDivideDao getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    public void insert(XbUnitDivideObj obj) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("insert into ");
            strb_sql.append("xb_unit_divide ");
            strb_sql.append("values ");
            strb_sql.append("(?,?,?,?,?)");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setLong(index++, obj.getUnit_id());
            stmt.setLong(index++, obj.getDivide_id());
            stmt.setInt(index++, obj.getOperator_type());
            stmt.setLong(index++, obj.getPresentation_order());
            stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreation_date().getTime()));

            // SQL@s
            stmt.executeUpdate();
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public ArrayList<XbUnitDivideObj> selectAll(long unit_id) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("unit_id, ");
            strb_sql.append("divide_id, ");
            strb_sql.append("operator_type, ");
            strb_sql.append("presentation_order, ");
            strb_sql.append("creation_date ");
            strb_sql.append("from xb_unit_divide ");
            strb_sql.append("where UNIT_ID=? ");
            strb_sql.append("order by presentation_order, divide_id ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setLong(index++, unit_id);

            ResultSet rs = stmt.executeQuery();
            ArrayList<XbUnitDivideObj> relist = new ArrayList<XbUnitDivideObj>();
            while (rs.next()) {
                XbUnitDivideObj obj = new XbUnitDivideObj();
                obj.setUnit_id(rs.getLong("unit_id"));
                obj.setDivide_id(rs.getLong("divide_id"));
                obj.setOperator_type(rs.getInt("operator_type"));
                obj.setPresentation_order(rs.getInt("presentation_order"));
                obj.setCreation_date(rs.getDate("creation_date"));
                relist.add(obj);
            }

            // ʃZbgN[Y
            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public XbUnitDivideObj select(long unit_id, long divide_id) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("unit_id, ");
            strb_sql.append("divide_id, ");
            strb_sql.append("operator_type, ");
            strb_sql.append("presentation_order, ");
            strb_sql.append("creation_date ");
            strb_sql.append("from xb_unit_divide ");
            strb_sql.append("where unit_id=? ");
            strb_sql.append("and divide_id=? ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setLong(index++, unit_id);
            stmt.setLong(index++, divide_id);

            ResultSet rs = stmt.executeQuery();
            XbUnitDivideObj obj = null;
            while (rs.next()) {
                obj = new XbUnitDivideObj();
                obj.setUnit_id(rs.getLong("unit_id"));
                obj.setDivide_id(rs.getLong("divide_id"));
                obj.setOperator_type(rs.getInt("operator_type"));
                obj.setPresentation_order(rs.getInt("presentation_order"));
                obj.setCreation_date(rs.getDate("creation_date"));
            }

            // ʃZbgN[Y
            rs.close();

            return obj;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public long getNextId() throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("max(divide_id)+1 AS max ");
            strb_sql.append("from xb_unit_divide ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            ResultSet rs = stmt.executeQuery();
            rs.next();

            return (rs.getLong("max") == 0 ? 1 : rs.getLong("max"));
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}