/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.sample.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.sample.dao.obj.XbUnitObj;

/**
 * @author Masako Okayasu
 */
public class XbUnitDao {

    // singleton쐬
    private static XbUnitDao instance = new XbUnitDao();
    // Connectionϐ
    private Connection conn = null;

    // RXgN^
    public XbUnitDao() {
    }

    // CX^X擾
    public static synchronized XbUnitDao getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    public void insert(XbUnitObj obj) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("insert into ");
            strb_sql.append("xb_unit ");
            strb_sql.append("values ");
            strb_sql.append("(?,?,?,?,?)");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setLong(index++, obj.getUnit_id());
            stmt.setString(index++, obj.getUnit_name());
            stmt.setString(index++, obj.getName());
            stmt.setLong(index++, obj.getPresentation_order());
            stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreation_date().getTime()));

            // SQL@s
            stmt.executeUpdate();
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public ArrayList<XbUnitObj> selectAll() throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("unit_id, ");
            strb_sql.append("unit_name, ");
            strb_sql.append("name, ");
            strb_sql.append("presentation_order, ");
            strb_sql.append("creation_date ");
            strb_sql.append("from xb_unit ");
            strb_sql.append("order by presentation_order, unit_id ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            ResultSet rs = stmt.executeQuery();
            ArrayList<XbUnitObj> relist = new ArrayList<XbUnitObj>();
            while (rs.next()) {
                XbUnitObj obj = new XbUnitObj();
                obj.setUnit_id(rs.getInt("unit_id"));
                obj.setUnit_name(rs.getString("unit_name"));
                obj.setName(rs.getString("name"));
                obj.setPresentation_order(rs.getInt("presentation_order"));
                obj.setCreation_date(rs.getDate("creation_date"));
                relist.add(obj);
            }

            // ʃZbgN[Y
            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public XbUnitObj select(long unit_id) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("unit_id, ");
            strb_sql.append("unit_name, ");
            strb_sql.append("name, ");
            strb_sql.append("presentation_order, ");
            strb_sql.append("creation_date ");
            strb_sql.append("from xb_unit ");
            strb_sql.append("where unit_id=? ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setLong(index++, unit_id);

            ResultSet rs = stmt.executeQuery();
            XbUnitObj obj = null;
            while (rs.next()) {
                obj = new XbUnitObj();
                obj.setUnit_id(rs.getInt("unit_id"));
                obj.setUnit_name(rs.getString("unit_name"));
                obj.setName(rs.getString("name"));
                obj.setPresentation_order(rs.getInt("presentation_order"));
                obj.setCreation_date(rs.getDate("creation_date"));
            }

            // ʃZbgN[Y
            rs.close();

            return obj;
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public long getNextId() throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("max(unit_id)+1 AS max ");
            strb_sql.append("from xb_unit ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            ResultSet rs = stmt.executeQuery();
            rs.next();

            return (rs.getLong("max") == 0 ? 1 : rs.getLong("max"));
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}