/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.sample.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.sample.dao.obj.XbItemObj;

/**
 * @author Masako Okayasu
 */
public class XbItemDao {

    // singleton쐬
    private static XbItemDao instance = new XbItemDao();
    // Connectionϐ
    private Connection conn = null;

    // e[u
    private String table1 = "xb_item";
    private String table2 = "xb_mapping";

    // RXgN^
    private XbItemDao() {
    }

    // CX^X擾
    public static synchronized XbItemDao getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    public void insert(XbItemObj obj) throws XbException {
        final String query = "insert into xb_item (item_order, taxonomy_group_id, taxonomy_id, taxonomy_item_id, item_type, parent_taxonomy_item_id, parent_item_type, presentation_order, item_lang, item_name) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setInt(index++, obj.getItem_order());
            stmt.setLong(index++, obj.getTaxonomy_group_id());
            stmt.setLong(index++, obj.getTaxonomy_id());
            stmt.setLong(index++, obj.getTaxonomy_item_id());
            stmt.setString(index++, obj.getItem_type());
            stmt.setLong(index++, obj.getParent_taxonomy_item_id());
            stmt.setString(index++, obj.getParent_item_type());
            stmt.setInt(index++, obj.getPresentation_order());

            stmt.setString(index++, obj.getItem_lang());
            stmt.setString(index++, obj.getItem_name());

            // SQL@s
            stmt.executeUpdate();
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public ArrayList<XbItemObj> selectAll(long taxonomy_group_id, long parent_taxonomy_item_id, String item_lang) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("item_order, ");
            strb_sql.append("taxonomy_group_id, ");
            strb_sql.append("taxonomy_id, ");
            strb_sql.append("taxonomy_item_id, ");
            strb_sql.append("item_type, ");
            strb_sql.append("parent_taxonomy_item_id, ");
            strb_sql.append("parent_item_type, ");
            strb_sql.append("presentation_order, ");
            strb_sql.append("item_lang, ");
            strb_sql.append("item_name ");
            strb_sql.append("from " + table1 + " ");
            strb_sql.append("where taxonomy_group_id=? ");
            strb_sql.append("and parent_taxonomy_item_id=? ");
            strb_sql.append("and item_lang=? ");
            strb_sql.append("order by item_order ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setLong(index++, taxonomy_group_id);
            stmt.setLong(index++, parent_taxonomy_item_id);
            stmt.setString(index++, item_lang);

            ResultSet rs = stmt.executeQuery();
            ArrayList<XbItemObj> relist = new ArrayList<XbItemObj>();
            while (rs.next()) {
                XbItemObj obj = new XbItemObj();
                obj.setItem_order(rs.getInt("item_order"));
                obj.setTaxonomy_group_id(rs.getLong("taxonomy_group_id"));
                obj.setTaxonomy_id(rs.getLong("taxonomy_id"));
                obj.setTaxonomy_item_id(rs.getLong("taxonomy_item_id"));
                obj.setItem_type(rs.getString("item_type"));
                obj.setParent_taxonomy_item_id(rs.getLong("parent_taxonomy_item_id"));
                obj.setParent_item_type(rs.getString("parent_item_type"));
                obj.setPresentation_order(rs.getInt("presentation_order"));
                obj.setItem_lang(rs.getString("item_lang"));
                obj.setItem_name(rs.getString("item_name"));
                relist.add(obj);
            }

            // ʃZbgN[Y
            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public XbItemObj select(long taxonomy_group_id, long taxonomy_item_id, String item_lang) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("item_order, ");
            strb_sql.append("taxonomy_group_id, ");
            strb_sql.append("taxonomy_id, ");
            strb_sql.append("taxonomy_item_id, ");
            strb_sql.append("item_type, ");
            strb_sql.append("parent_taxonomy_item_id, ");
            strb_sql.append("parent_item_type, ");
            strb_sql.append("presentation_order, ");
            strb_sql.append("item_lang, ");
            strb_sql.append("item_name ");
            strb_sql.append("from " + table1 + " ");
            strb_sql.append("where taxonomy_group_id=? ");
            strb_sql.append("and taxonomy_item_id=? ");
            strb_sql.append("and item_lang=? ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setLong(index++, taxonomy_group_id);
            stmt.setLong(index++, taxonomy_item_id);
            stmt.setString(index++, item_lang);

            ResultSet rs = stmt.executeQuery();
            XbItemObj obj = null;
            while (rs.next()) {
                obj = new XbItemObj();
                obj.setItem_order(rs.getInt("item_order"));
                obj.setTaxonomy_group_id(rs.getLong("taxonomy_group_id"));
                obj.setTaxonomy_id(rs.getLong("taxonomy_id"));
                obj.setTaxonomy_item_id(rs.getLong("taxonomy_item_id"));
                obj.setItem_type(rs.getString("item_type"));
                obj.setParent_taxonomy_item_id(rs.getLong("parent_taxonomy_item_id"));
                obj.setParent_item_type(rs.getString("parent_item_type"));
                obj.setPresentation_order(rs.getInt("presentation_order"));
                obj.setItem_lang(rs.getString("item_lang"));
                obj.setItem_name(rs.getString("item_name"));
            }

            // ʃZbgN[Y
            rs.close();

            return obj;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public ArrayList<XbItemObj> selectTuple(long taxonomy_group_id, String item_lang) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("item_order, ");
            strb_sql.append(table1 + ".taxonomy_group_id, ");
            strb_sql.append(table1 + ".taxonomy_item_id, ");
            strb_sql.append("parent_taxonomy_item_id, ");
            strb_sql.append("user_item_id, ");
            strb_sql.append("item_type, ");
            strb_sql.append("item_name ");
            strb_sql.append("from " + table1 + ", ");
            strb_sql.append(table2 + " ");
            strb_sql.append("where " + table1 + ".taxonomy_group_id=? ");
            strb_sql.append("and " + table1 + ".taxonomy_group_id=" + table2 + ".taxonomy_group_id ");
            strb_sql.append("and " + table1 + ".taxonomy_item_id=" + table2 + ".taxonomy_item_id ");
            strb_sql.append("and item_lang=? ");
            strb_sql.append("and tuple_child_flag=1 ");
            strb_sql.append("order by item_order ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setLong(index++, taxonomy_group_id);
            stmt.setString(index++, item_lang);

            ResultSet rs = stmt.executeQuery();
            ArrayList<XbItemObj> relist = new ArrayList<XbItemObj>();
            while (rs.next()) {
                XbItemObj obj = new XbItemObj();
                obj.setItem_order(rs.getInt("item_order"));
                obj.setTaxonomy_group_id(rs.getLong("taxonomy_group_id"));
                obj.setTaxonomy_item_id(rs.getLong("taxonomy_item_id"));
                obj.setParent_taxonomy_item_id(rs.getLong("parent_taxonomy_item_id"));
                obj.setUser_item_id(rs.getLong("user_item_id"));
                obj.setItem_type(rs.getString("item_type"));
                obj.setItem_name(rs.getString("item_name"));
                relist.add(obj);
            }

            // ʃZbgN[Y
            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}