/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.sample.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.sample.dao.obj.XbEntityIdentifierObj;

/**
 * @author Masako Okayasu
 */
public class XbEntityIdentifierDao {

    // singleton쐬
    private static XbEntityIdentifierDao instance = new XbEntityIdentifierDao();
    // Connectionϐ
    private Connection conn = null;

    // e[u
    private String table1 = "xb_entity_identifier";
    private String table2 = "xb_identifier";

    // RXgN^
    public XbEntityIdentifierDao() {
    }

    // CX^X擾
    public static synchronized XbEntityIdentifierDao getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    public void insert(XbEntityIdentifierObj obj) throws XbException {
        final String query = "insert into xb_entity_identifier values (?, ?, ?, ?)";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setLong(index++, obj.getEntity_id());
            stmt.setLong(index++, obj.getIdentifier_id());
            stmt.setLong(index++, obj.getPresentation_order());
            stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreation_date().getTime()));

            // SQL@s
            stmt.executeUpdate();
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public ArrayList<XbEntityIdentifierObj> selectAll(long entity_id) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("entity_id, ");
            strb_sql.append(table1 + ".identifier_id, ");
            strb_sql.append("identifier_name, ");
            strb_sql.append("schema, ");
            strb_sql.append("value, ");
            strb_sql.append("presentation_order, ");
            strb_sql.append(table1 + ".creation_date ");
            strb_sql.append("from " + table1 + ", " + table2 + " ");
            strb_sql.append("where ENTITY_ID=? ");
            strb_sql.append("and " + table1 + ".IDENTIFIER_ID=" + table2 + ".IDENTIFIER_ID ");
            strb_sql.append("order by PRESENTATION_ORDER, " + table1 + ".IDENTIFIER_ID ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setLong(index++, entity_id);

            ResultSet rs = stmt.executeQuery();
            ArrayList<XbEntityIdentifierObj> relist = new ArrayList<XbEntityIdentifierObj>();
            while (rs.next()) {
                XbEntityIdentifierObj obj = new XbEntityIdentifierObj();
                obj.setEntity_id(rs.getLong("entity_id"));
                obj.setIdentifier_id(rs.getLong("identifier_id"));
                obj.setIdentifier_name(rs.getString("identifier_name"));
                obj.setSchema(rs.getString("schema"));
                obj.setValue(rs.getString("value"));
                obj.setPresentation_order(rs.getInt("presentation_order"));
                obj.setCreation_date(rs.getDate("creation_date"));
                relist.add(obj);
            }

            // ʃZbgN[Y
            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public XbEntityIdentifierObj select(long entity_id, long identifier_id) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("entity_id, ");
            strb_sql.append(table1 + ".identifier_id, ");
            strb_sql.append("identifier_name, ");
            strb_sql.append("schema, ");
            strb_sql.append("value, ");
            strb_sql.append("presentation_order, ");
            strb_sql.append(table1 + ".creation_date ");
            strb_sql.append("from " + table1 + ", " + table2 + " ");
            strb_sql.append("where entity_id=? ");
            strb_sql.append("and " + table1 + ".identifier_id=? ");
            strb_sql.append("and " + table1 + ".identifier_id=" + table2 + ".identifier_id ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setLong(index++, entity_id);
            stmt.setLong(index++, identifier_id);

            ResultSet rs = stmt.executeQuery();
            XbEntityIdentifierObj obj = null;
            while (rs.next()) {
                obj = new XbEntityIdentifierObj();
                obj.setEntity_id(rs.getLong("entity_id"));
                obj.setIdentifier_id(rs.getLong("identifier_id"));
                obj.setIdentifier_name(rs.getString("identifier_name"));
                obj.setSchema(rs.getString("schema"));
                obj.setValue(rs.getString("value"));
                obj.setPresentation_order(rs.getInt("presentation_order"));
                obj.setCreation_date(rs.getDate("creation_date"));
            }

            // ʃZbgN[Y
            rs.close();

            return obj;
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}