/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.sample.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.sample.dao.obj.XbEntityObj;

/**
 * @author Masako Okayasu
 */
public class XbEntityDao {

    // singleton쐬
    private static XbEntityDao instance = new XbEntityDao();
    // Connectionϐ
    private Connection conn = null;

    // RXgN^
    public XbEntityDao() {
    }

    // CX^X擾
    public static synchronized XbEntityDao getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    public void insert(XbEntityObj obj) throws XbException {
        final String query = "insert into xb_entity values (?, ?, ?, ?)";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setLong(index++, obj.getEntity_id());
            stmt.setString(index++, obj.getEntity_name());
            stmt.setLong(index++, obj.getPresentation_order());
            stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreation_date().getTime()));

            // SQL@s
            stmt.executeUpdate();
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public ArrayList<XbEntityObj> selectAll() throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("entity_id, ");
            strb_sql.append("entity_name, ");
            strb_sql.append("presentation_order, ");
            strb_sql.append("creation_date ");
            strb_sql.append("from xb_entity ");
            strb_sql.append("order by presentation_order, entity_id ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            ResultSet rs = stmt.executeQuery();
            ArrayList<XbEntityObj> relist = new ArrayList<XbEntityObj>();
            while (rs.next()) {
                XbEntityObj obj = new XbEntityObj();
                obj.setEntity_id(rs.getInt("entity_id"));
                obj.setEntity_name(rs.getString("entity_name"));
                obj.setPresentation_order(rs.getInt("presentation_order"));
                obj.setCreation_date(rs.getDate("creation_date"));
                relist.add(obj);
            }

            // ʃZbgN[Y
            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public XbEntityObj select(long entity_id) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("entity_id, ");
            strb_sql.append("entity_name, ");
            strb_sql.append("presentation_order, ");
            strb_sql.append("creation_date ");
            strb_sql.append("from xb_entity ");
            strb_sql.append("where entity_id=? ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setLong(index++, entity_id);

            ResultSet rs = stmt.executeQuery();
            XbEntityObj obj = null;
            while (rs.next()) {
                obj = new XbEntityObj();
                obj.setEntity_id(rs.getInt("entity_id"));
                obj.setEntity_name(rs.getString("entity_name"));
                obj.setPresentation_order(rs.getInt("presentation_order"));
                obj.setCreation_date(rs.getDate("creation_date"));
            }

            // ʃZbgN[Y
            rs.close();

            return obj;
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public long getNextId() throws XbException {
        final String query = "select max(entity_id)+1 as max from xb_entity";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);

            ResultSet rs = stmt.executeQuery();
            rs.next();

            return (rs.getLong("max") == 0 ? 1 : rs.getLong("max"));
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}