/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbUnitDivideDAO {
    // singleton쐬
    private static final XbUnitDivideDAO instance = new XbUnitDivideDAO();
    private Connection conn = null;

    // RXgN^
    private XbUnitDivideDAO() {
    }

    // CX^X擾
    protected static synchronized XbUnitDivideDAO getInstance(Connection connection) {
        // CX^X𐶐
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    protected ArrayList<XbUnitDivideObj> getDivide(long unitId) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            strb_sql.append("select ");
            strb_sql.append("ud.unit_id as unit_id ");
            strb_sql.append(", ud.divide_id as divide_id ");
            strb_sql.append(", dm.divide_type as divide_type ");
            strb_sql.append(", m.measure_id as measure_id ");
            strb_sql.append(", m.money_flag as money_flag ");
            strb_sql.append(", m.value as value ");
            strb_sql.append("from ");
            strb_sql.append("xb_unit_divide ud ");
            strb_sql.append(", xb_divide_measure dm ");
            strb_sql.append(", xb_measure m ");
            strb_sql.append("where ");
            strb_sql.append("ud.unit_id = ? ");
            strb_sql.append("and ud.divide_id = dm.divide_id ");
            strb_sql.append("and dm.measure_id = m.measure_id ");
            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());
            int index = 1;

            stmt.setLong(index++, unitId);

            ResultSet rs = stmt.executeQuery();

            ArrayList<XbUnitDivideObj> relist = new ArrayList<XbUnitDivideObj>();
            while (rs.next()) {
                XbUnitDivideObj obj = new XbUnitDivideObj();
                obj.setUnitId(rs.getLong("unit_id"));
                obj.setDivideId(rs.getLong("divide_id"));
                obj.setDivideType(rs.getShort("divide_type"));
                obj.setMeasureId(rs.getLong("measure_id"));
                obj.setMoneyFlag(rs.getInt("money_flag") == 1);
                obj.setValue(rs.getString("value"));

                relist.add(obj);
            }
            // ʃZbgN[Y
            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}