/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbTupleDataDAO {

    // singleton쐬
    private static final XbTupleDataDAO instance = new XbTupleDataDAO();
    private Connection conn = null;

    // RXgN^
    private XbTupleDataDAO() {
    }

    // CX^X擾
    protected static synchronized XbTupleDataDAO getInstance(Connection connection) {
        // CX^X𐶐
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    protected ArrayList<XbTupleDataObj> getTupleData(long groupId, long contextId) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();

            // CXg
            strb_sql.append("select ");
            strb_sql.append("tuple.item_order as item_order ");
            strb_sql.append(", tuple.taxonomy_group_id as taxonomy_group_id ");
            strb_sql.append(", tuple.taxonomy_item_id as taxonomy_item_id ");
            strb_sql.append(", tuple.taxonomy_item_seq as taxonomy_item_seq ");
            strb_sql.append(", tuple.parent_taxonomy_item_id as parent_taxonomy_item_id ");
            strb_sql.append(", tuple.parent_taxonomy_item_seq as parent_taxonomy_item_seq ");
            strb_sql.append(", tuple.item_value as item_value ");
            strb_sql.append(", map.item_precision as item_precision ");
            strb_sql.append(", map.item_decimal as item_decimal ");
            strb_sql.append(", sort.context_type as context_type ");
            strb_sql.append(", foot.parent_etc_id as parent_etc_id ");
            strb_sql.append(", attr.value as value ");
            strb_sql.append("from ");
            strb_sql.append("(((xb_tuple_data tuple ");
            strb_sql.append("left outer join xb_mapping map ");
            strb_sql.append("on tuple.taxonomy_group_id = map.taxonomy_group_id ");
            strb_sql.append("and tuple.taxonomy_item_id = map.taxonomy_item_id) ");
            strb_sql.append("inner join xb_item sort ");
            strb_sql.append("on tuple.item_order = sort.item_order ");
            strb_sql.append("and tuple.taxonomy_group_id = sort.taxonomy_group_id ");
            strb_sql.append("and tuple.taxonomy_item_id = sort.taxonomy_item_id) ");
            strb_sql.append("left outer join xb_item_footnote foot ");
            strb_sql.append("on map.user_item_id = foot.main_id ");
            strb_sql.append("and map.etc_id = foot.etc_id) ");
            strb_sql.append("left outer join xb_etc_attributes attr ");
            strb_sql.append("on foot.etc_id = attr.etc_id ");
            strb_sql.append("and attr.etc_type = 3 ");
            strb_sql.append("and attr.name = 'href' ");
            strb_sql.append("where ");
            strb_sql.append("tuple.taxonomy_group_id = ? ");
            strb_sql.append("and tuple.context_id = ? ");
            strb_sql
                    .append("group by tuple.item_order, tuple.taxonomy_group_id, tuple.taxonomy_item_id, tuple.taxonomy_item_seq, tuple.parent_taxonomy_item_id, tuple.parent_taxonomy_item_seq, tuple.item_value, map.item_precision, map.item_decimal, sort.context_type, foot.parent_etc_id, attr.value");
            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());
            int index = 1;

            stmt.setLong(index++, groupId);
            stmt.setLong(index++, contextId);

            ResultSet rs = stmt.executeQuery();

            ArrayList<XbTupleDataObj> relist = new ArrayList<XbTupleDataObj>();
            while (rs.next()) {
                // TuXg
                XbTupleDataObj obj = new XbTupleDataObj();
                obj.setItemOrder(rs.getInt("item_order"));
                obj.setTaxonomyGroupId(rs.getLong("taxonomy_group_id"));
                obj.setTaxonomyItemId(rs.getLong("taxonomy_item_id"));
                obj.setTaxonomyItemSeq(rs.getInt("taxonomy_item_seq"));
                obj.setParentTaxonomyItemId(rs.getLong("parent_taxonomy_item_id"));
                obj.setParentTaxonomyItemSeq(rs.getInt("parent_taxonomy_item_seq"));
                obj.setItemValue(rs.getString("item_value"));
                obj.setItemPrecision(rs.getInt("item_precision"));
                obj.setItemDecimal(rs.getInt("item_decimal"));
                obj.setContextType(rs.getString("context_type"));
                obj.setParentEtcId(rs.getLong("parent_etc_id"));
                obj.setValue(rs.getString("value"));
                relist.add(obj);
            }
            // ʃZbgN[Y
            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}